/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.forgerock.audit.events.handlers.FileBasedEventHandlerConfiguration;
import org.forgerock.util.Reject;
import org.forgerock.util.time.Duration;

public class CsvAuditEventHandlerConfiguration
extends FileBasedEventHandlerConfiguration {
    @JsonProperty(required=true)
    @JsonPropertyDescription(value="audit.handlers.csv.logDirectory")
    private String logDirectory;
    @JsonPropertyDescription(value="audit.handlers.csv.formatting")
    private CsvFormatting formatting = new CsvFormatting();
    @JsonPropertyDescription(value="audit.handlers.csv.security")
    private CsvSecurity security = new CsvSecurity();
    @JsonPropertyDescription(value="audit.handlers.csv.buffering")
    protected EventBufferingConfiguration buffering = new EventBufferingConfiguration();

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(String directory) {
        this.logDirectory = directory;
    }

    public CsvFormatting getFormatting() {
        return this.formatting;
    }

    public void setFormatting(CsvFormatting formatting) {
        this.formatting = (CsvFormatting)Reject.checkNotNull((Object)formatting);
    }

    public CsvSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(CsvSecurity security) {
        this.security = (CsvSecurity)Reject.checkNotNull((Object)security);
    }

    public EventBufferingConfiguration getBuffering() {
        return this.buffering;
    }

    public void setBufferingConfiguration(EventBufferingConfiguration bufferingConfiguration) {
        this.buffering = bufferingConfiguration;
    }

    public boolean isUsableForQueries() {
        return true;
    }

    public static class EventBufferingConfiguration {
        @JsonPropertyDescription(value="audit.handlers.csv.buffering.enabled")
        private boolean enabled;
        @JsonPropertyDescription(value="audit.handlers.csv.buffering.autoFlush")
        private boolean autoFlush = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isAutoFlush() {
            return this.autoFlush;
        }

        public void setAutoFlush(boolean auto) {
            this.autoFlush = auto;
        }
    }

    public static class CsvSecurity {
        @JsonPropertyDescription(value="audit.handlers.csv.security.enabled")
        private boolean enabled = false;
        @JsonPropertyDescription(value="audit.handlers.csv.security.filename")
        private String filename;
        @JsonPropertyDescription(value="audit.handlers.csv.security.password")
        private String password;
        @JsonPropertyDescription(value="audit.handlers.csv.security.keyStoreHandlerName")
        private String keyStoreHandlerName;
        @JsonPropertyDescription(value="audit.handlers.csv.security.signatureInterval")
        private String signatureInterval;
        @JsonIgnore
        private Duration signatureIntervalDuration;

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public void setSignatureInterval(String signatureInterval) {
            this.signatureInterval = signatureInterval;
            this.signatureIntervalDuration = Duration.duration((String)signatureInterval);
        }

        public String getSignatureInterval() {
            return this.signatureInterval;
        }

        public Duration getSignatureIntervalDuration() {
            return this.signatureIntervalDuration;
        }

        public void setKeyStoreHandlerName(String keyStoreName) {
            this.keyStoreHandlerName = keyStoreName;
        }

        public String getKeyStoreHandlerName() {
            return this.keyStoreHandlerName;
        }
    }

    public static class CsvFormatting {
        @JsonPropertyDescription(value="audit.handlers.csv.formatting.quoteChar")
        private char quoteChar = (char)34;
        @JsonPropertyDescription(value="audit.handlers.csv.formatting.delimiterChar")
        private char delimiterChar = (char)44;
        @JsonPropertyDescription(value="audit.handlers.csv.formatting.endOfLineSymbols")
        private String endOfLineSymbols = System.getProperty("line.separator");

        public char getQuoteChar() {
            return this.quoteChar;
        }

        public void setQuoteChar(char quoteChar) {
            this.quoteChar = quoteChar;
        }

        public char getDelimiterChar() {
            return this.delimiterChar;
        }

        public void setDelimiterChar(char delimiterChar) {
            this.delimiterChar = delimiterChar;
        }

        public String getEndOfLineSymbols() {
            return this.endOfLineSymbols;
        }

        public void setEndOfLineSymbols(String endOfLineSymbols) {
            this.endOfLineSymbols = endOfLineSymbols;
        }
    }
}

