/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.TemplateTag;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;

final class TemplateFile {
    private static final String DEFAULT_RESOURCES_PATH = "org/forgerock/opendj/ldif";
    private static final String DEFAULT_TEMPLATE_PATH = "example.template";
    private static final String FIRST_NAME_FILE = "first.names";
    private static final String LAST_NAME_FILE = "last.names";
    private static final int INFINITE_ENTRIES = -1;
    private final Map<String, String[]> fileLines = new HashMap<String, String[]>();
    private int firstNameIndex;
    private int lastNameIndex;
    private int nameLoopCounter;
    private int nameUniquenessCounter = 1;
    private final Map<DN, Branch> branches = new LinkedHashMap<DN, Branch>();
    private final Map<String, String> constants;
    private final Map<String, TemplateTag> registeredTags = new LinkedHashMap<String, TemplateTag>();
    private final Map<String, Template> templates = new LinkedHashMap<String, Template>();
    private final Random random;
    private String firstName;
    private String lastName;
    private boolean generateBranches;
    private String resourcePath;
    private String[] firstNames = new String[0];
    private String[] lastNames = new String[0];
    private final Schema schema;
    private static final String INCLUDE_LABEL = "include ";
    private static final String DEFINE_LABEL = "define ";
    private static final String BRANCH_LABEL = "branch: ";
    private static final String TEMPLATE_LABEL = "template: ";
    private static final String SUBORDINATE_TEMPLATE_LABEL = "subordinatetemplate: ";
    private static final String RDNATTR_LABEL = "rdnattr: ";
    private static final String EXTENDS_LABEL = "extends: ";
    private static final int PARSING_STATIC_TEXT = 0;
    private static final int PARSING_REPLACEMENT_TAG = 1;
    private static final int PARSING_ATTRIBUTE_TAG = 2;
    private static final int PARSING_ESCAPED_CHAR = 3;
    private Iterator<Branch> branchesIterator;
    private Branch currentBranch;
    private TemplateEntry nextEntry;

    TemplateFile(Schema schema, Map<String, String> constants, String resourcePath) throws IOException {
        this(schema, constants, resourcePath, new Random(), true);
    }

    TemplateFile(Schema schema, Map<String, String> constants, String resourcePath, Random random, boolean generateBranches) throws IOException {
        Reject.ifNull((Object[])new Object[]{schema, random});
        this.generateBranches = generateBranches;
        this.schema = schema;
        this.constants = constants != null ? constants : new HashMap();
        this.resourcePath = resourcePath;
        this.random = random;
        this.registerDefaultTags();
        this.retrieveFirstAndLastNames();
    }

    TemplateTag getTag(String lowerName) {
        return this.registeredTags.get(lowerName);
    }

    private void registerDefaultTags() {
        Class[] defaultTagClasses;
        for (Class c : defaultTagClasses = new Class[]{TemplateTag.AttributeValueTag.class, TemplateTag.DNTag.class, TemplateTag.FileTag.class, TemplateTag.FirstNameTag.class, TemplateTag.GUIDTag.class, TemplateTag.IfAbsentTag.class, TemplateTag.IfPresentTag.class, TemplateTag.LastNameTag.class, TemplateTag.ListTag.class, TemplateTag.ParentDNTag.class, TemplateTag.PresenceTag.class, TemplateTag.RandomTag.class, TemplateTag.RDNTag.class, TemplateTag.SequentialTag.class, TemplateTag.StaticTextTag.class, TemplateTag.UnderscoreDNTag.class, TemplateTag.UnderscoreParentDNTag.class}) {
            try {
                TemplateTag t = (TemplateTag)c.newInstance();
                this.registeredTags.put(t.getName().toLowerCase(), t);
            }
            catch (Exception e) {
                throw new RuntimeException(CoreMessages.ERR_ENTRY_GENERATOR_CANNOT_INSTANTIATE_TAG.get((Object)c.getName()).toString(), e);
            }
        }
    }

    Random getRandom() {
        return this.random;
    }

    private void retrieveFirstAndLastNames() throws IOException {
        List<String> names;
        try (BufferedReader first = this.getReader(FIRST_NAME_FILE);){
            if (first == null) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_COULD_NOT_FIND_NAME_FILE.get((Object)FIRST_NAME_FILE));
            }
            names = this.readLines(first);
            this.firstNames = names.toArray(new String[names.size()]);
        }
        try (BufferedReader last = this.getReader(LAST_NAME_FILE);){
            if (last == null) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_COULD_NOT_FIND_NAME_FILE.get((Object)LAST_NAME_FILE));
            }
            names = this.readLines(last);
            this.lastNames = names.toArray(new String[names.size()]);
        }
    }

    void nextFirstAndLastNames() {
        this.firstName = this.firstNames[this.firstNameIndex++];
        this.lastName = this.lastNames[this.lastNameIndex++];
        if (this.nameUniquenessCounter > 1) {
            this.lastName = this.lastName + this.nameUniquenessCounter;
        }
        if (this.firstNameIndex >= this.firstNames.length) {
            this.firstNameIndex = 0;
            if (this.firstNames.length > this.lastNames.length) {
                this.lastNameIndex = ++this.nameLoopCounter;
                if (this.lastNameIndex >= this.lastNames.length) {
                    this.lastNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
        if (this.lastNameIndex >= this.lastNames.length) {
            this.lastNameIndex = 0;
            if (this.lastNames.length > this.firstNames.length) {
                this.firstNameIndex = ++this.nameLoopCounter;
                if (this.firstNameIndex >= this.firstNames.length) {
                    this.firstNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
    }

    String getFirstName() {
        return this.firstName;
    }

    String getLastName() {
        return this.lastName;
    }

    void parse(List<LocalizableMessage> warnings) throws IOException, DecodeException {
        this.parse(DEFAULT_TEMPLATE_PATH, warnings);
    }

    void parse(String templateFilename, List<LocalizableMessage> warnings) throws IOException, DecodeException {
        try (BufferedReader templateReader = this.getReader(templateFilename);){
            File file;
            if (templateReader == null) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_COULD_NOT_FIND_TEMPLATE_FILE.get((Object)templateFilename));
            }
            if (this.resourcePath == null && (file = this.getFile(templateFilename)) != null) {
                this.resourcePath = file.getCanonicalFile().getParentFile().getAbsolutePath();
            }
            List<String> fileLines = this.readLines(templateReader);
            String[] lines = fileLines.toArray(new String[fileLines.size()]);
            this.parse(lines, warnings);
        }
    }

    void parse(InputStream inputStream, List<LocalizableMessage> warnings) throws IOException, DecodeException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            List<String> fileLines = this.readLines(reader);
            String[] lines = fileLines.toArray(new String[fileLines.size()]);
            this.parse(lines, warnings);
        }
    }

    void parse(String[] lines, List<LocalizableMessage> warnings) throws DecodeException {
        TemplateData templateData = new TemplateData();
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            String currentRawLine = lines[lineNumber];
            if (currentRawLine.isEmpty() || currentRawLine.startsWith("#")) continue;
            String line = this.replaceConstants(currentRawLine, lineNumber, this.constants, warnings);
            String lowerLine = line.toLowerCase();
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (lowerLine.startsWith(INCLUDE_LABEL)) {
                this.parseInclude(line, templateData.tags);
                continue;
            }
            if (lowerLine.startsWith(DEFINE_LABEL)) {
                this.parseDefine(lineNumber, line, this.constants, warnings);
                continue;
            }
            if (lowerLine.startsWith(BRANCH_LABEL)) {
                lineNumber = this.parseBranch(lineNumber, line, lines, templateData, warnings);
                continue;
            }
            if (lowerLine.startsWith(TEMPLATE_LABEL)) {
                lineNumber = this.parseTemplate(lineNumber, line, lines, templateData, warnings);
                continue;
            }
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_UNEXPECTED_TEMPLATE_FILE_LINE.get((Object)line, (Object)(lineNumber + 1)));
        }
        for (Branch b : templateData.branches.values()) {
            b.completeBranchInitialization(templateData.templates, this.generateBranches);
        }
        for (Template t : templateData.templates.values()) {
            t.completeTemplateInitialization(templateData.templates);
        }
        this.registeredTags.putAll(templateData.tags);
        this.branches.putAll(templateData.branches);
        this.templates.putAll(templateData.templates);
        if (this.branchesIterator == null) {
            this.branchesIterator = this.branches.values().iterator();
            if (this.branchesIterator.hasNext()) {
                this.currentBranch = this.branchesIterator.next();
            }
        }
    }

    private void parseInclude(String line, Map<String, TemplateTag> templateFileIncludeTags) throws DecodeException {
        TemplateTag tag;
        String className = line.substring(INCLUDE_LABEL.length()).trim();
        Class<?> tagClass = null;
        try {
            tagClass = Class.forName(className);
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_CANNOT_LOAD_TAG_CLASS.get((Object)className);
            throw DecodeException.fatalError(message, e);
        }
        try {
            tag = (TemplateTag)tagClass.newInstance();
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_CANNOT_INSTANTIATE_TAG.get((Object)className);
            throw DecodeException.fatalError(message, e);
        }
        String lowerName = tag.getName().toLowerCase();
        if (this.registeredTags.containsKey(lowerName) || templateFileIncludeTags.containsKey(lowerName)) {
            LocalizableMessage message = CoreMessages.ERR_ENTRY_GENERATOR_CONFLICTING_TAG_NAME.get((Object)className, (Object)tag.getName());
            throw DecodeException.fatalError(message);
        }
        templateFileIncludeTags.put(lowerName, tag);
    }

    private void parseDefine(int lineNumber, String line, Map<String, String> templateFileConstants, List<LocalizableMessage> warnings) throws DecodeException {
        String lowerName;
        int equalPos = line.indexOf(61, DEFINE_LABEL.length());
        if (equalPos < 0) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_DEFINE_MISSING_EQUALS.get((Object)(lineNumber + 1)));
        }
        String name = line.substring(DEFINE_LABEL.length(), equalPos).trim();
        if (name.length() == 0) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_DEFINE_NAME_EMPTY.get((Object)(lineNumber + 1)));
        }
        String value = line.substring(equalPos + 1);
        if (value.length() == 0) {
            warnings.add(CoreMessages.ERR_ENTRY_GENERATOR_WARNING_DEFINE_VALUE_EMPTY.get((Object)name, (Object)(lineNumber + 1)));
        }
        if (!templateFileConstants.containsKey(lowerName = name.toLowerCase())) {
            templateFileConstants.put(lowerName, value);
        }
    }

    private int parseBranch(int startLineNumber, String startLine, String[] lines, TemplateData templateData, List<LocalizableMessage> warnings) throws DecodeException {
        String[] branchLines = this.parseLinesUntilEndOfBlock(startLineNumber, startLine, lines, warnings);
        Branch branch = this.parseBranchDefinition(branchLines, startLineNumber, templateData.tags, warnings);
        DN branchDN = branch.getBranchDN();
        if (templateData.branches.containsKey(branchDN)) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_CONFLICTING_BRANCH_DN.get((Object)String.valueOf(branchDN), (Object)(startLineNumber + 1)));
        }
        templateData.branches.put(branchDN, branch);
        return startLineNumber + branchLines.length;
    }

    private int parseTemplate(int startLineNumber, String startLine, String[] lines, TemplateData templateData, List<LocalizableMessage> warnings) throws DecodeException {
        String[] templateLines = this.parseLinesUntilEndOfBlock(startLineNumber, startLine, lines, warnings);
        Template template = this.parseTemplateDefinition(startLineNumber, templateLines, templateData, warnings);
        String lowerName = template.getName().toLowerCase();
        if (templateData.templates.containsKey(lowerName)) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_CONFLICTING_TEMPLATE_NAME.get((Object)String.valueOf(template.getName()), (Object)(startLineNumber + 1)));
        }
        templateData.templates.put(lowerName, template);
        return startLineNumber + templateLines.length;
    }

    private String[] parseLinesUntilEndOfBlock(int startLineNumber, String startLine, String[] lines, List<LocalizableMessage> warnings) {
        ArrayList<String> lineList = new ArrayList<String>();
        String line = startLine;
        lineList.add(line);
        int lineNumber = startLineNumber;
        while (++lineNumber < lines.length && (line = lines[lineNumber]).length() != 0) {
            line = this.replaceConstants(line, lineNumber, this.constants, warnings);
            lineList.add(line);
        }
        return lineList.toArray(new String[lineList.size()]);
    }

    private String replaceConstants(String line, int lineNumber, Map<String, String> constants, List<LocalizableMessage> warnings) {
        String newLine = line;
        int closePos = line.lastIndexOf(93);
        while (true) {
            if (closePos > 0 && newLine.charAt(closePos - 1) == '\\') {
                closePos = newLine.lastIndexOf(93, closePos - 1);
                continue;
            }
            if (closePos > 0) {
                StringBuilder lineBuffer = new StringBuilder(newLine);
                int openPos = newLine.lastIndexOf(91, closePos);
                if (openPos > 0 && newLine.charAt(openPos - 1) != '\\' || openPos == 0) {
                    String constantName = newLine.substring(openPos + 1, closePos).toLowerCase();
                    String constantValue = constants.get(constantName);
                    if (constantValue != null) {
                        lineBuffer.replace(openPos, closePos + 1, constantValue);
                    } else {
                        warnings.add(CoreMessages.WARN_ENTRY_GENERATOR_WARNING_UNDEFINED_CONSTANT.get((Object)constantName, (Object)(lineNumber + 1)));
                    }
                }
                if (openPos >= 0) {
                    closePos = openPos;
                }
                newLine = lineBuffer.toString();
                closePos = newLine.lastIndexOf(93, closePos);
            }
            if (closePos <= 0) break;
        }
        return newLine;
    }

    private Branch parseBranchDefinition(String[] branchLines, int startLineNumber, Map<String, TemplateTag> tags, List<LocalizableMessage> warnings) throws DecodeException {
        DN branchDN;
        String dnString = branchLines[0].substring(BRANCH_LABEL.length()).trim();
        try {
            branchDN = DN.valueOf(dnString, this.schema);
        }
        catch (Exception e) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_CANNOT_DECODE_BRANCH_DN.get((Object)dnString, (Object)(startLineNumber + 1)));
        }
        Branch branch = new Branch(this, branchDN, this.schema);
        for (int i = 1; i < branchLines.length; ++i) {
            String line = branchLines[i];
            String lowerLine = line.toLowerCase();
            int lineNumber = startLineNumber + i;
            if (lowerLine.startsWith("#")) continue;
            if (lowerLine.startsWith(SUBORDINATE_TEMPLATE_LABEL)) {
                Pair<String, Integer> pair = this.parseSubordinateTemplate(lineNumber, line, Element.BRANCH, dnString, warnings);
                String templateName = (String)pair.getFirst();
                int numEntries = (Integer)pair.getSecond();
                branch.addSubordinateTemplate(templateName, numEntries);
                continue;
            }
            TemplateLine templateLine = this.parseTemplateLine(line, lineNumber, branch, null, Element.BRANCH, tags, warnings);
            branch.addExtraLine(templateLine);
        }
        return branch;
    }

    private Template parseTemplateDefinition(int startLineNumber, String[] templateLines, TemplateData templateData, List<LocalizableMessage> warnings) throws DecodeException {
        int lineCount;
        Map<String, TemplateTag> tags = templateData.tags;
        Map<String, Template> definedTemplates = templateData.templates;
        String templateName = templateLines[0].substring(TEMPLATE_LABEL.length()).trim();
        Template parentTemplate = null;
        ArrayList<AttributeType> rdnAttributes = new ArrayList<AttributeType>();
        ArrayList<String> subordinatesTemplateNames = new ArrayList<String>();
        ArrayList<Integer> numberOfentriesPerTemplate = new ArrayList<Integer>();
        for (lineCount = 1; lineCount < templateLines.length; ++lineCount) {
            int lineNumber = startLineNumber + lineCount;
            String line = templateLines[lineCount];
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("#")) continue;
            if (lowerLine.startsWith(EXTENDS_LABEL)) {
                String parentTemplateName = line.substring(EXTENDS_LABEL.length()).trim();
                parentTemplate = definedTemplates.get(parentTemplateName.toLowerCase());
                if (parentTemplate != null) continue;
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TEMPLATE_INVALID_PARENT_TEMPLATE.get((Object)parentTemplateName, (Object)(lineNumber + 1), (Object)templateName));
            }
            if (lowerLine.startsWith(RDNATTR_LABEL)) {
                String rdnAttrNames = lowerLine.substring(RDNATTR_LABEL.length()).trim();
                StringTokenizer tokenizer = new StringTokenizer(rdnAttrNames, "+");
                while (tokenizer.hasMoreTokens()) {
                    rdnAttributes.add(this.schema.getAttributeType(tokenizer.nextToken()));
                }
                continue;
            }
            if (!lowerLine.startsWith(SUBORDINATE_TEMPLATE_LABEL)) break;
            Pair<String, Integer> pair = this.parseSubordinateTemplate(lineNumber, line, Element.BRANCH, templateName, warnings);
            subordinatesTemplateNames.add((String)pair.getFirst());
            numberOfentriesPerTemplate.add((Integer)pair.getSecond());
        }
        ArrayList<TemplateLine> parentLines = parentTemplate == null ? new ArrayList() : parentTemplate.getTemplateLines();
        Template template = new Template(this, templateName, rdnAttributes, subordinatesTemplateNames, numberOfentriesPerTemplate, parentLines);
        while (lineCount < templateLines.length) {
            String line = templateLines[lineCount];
            String lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("#")) {
                int lineNumber = startLineNumber + lineCount;
                TemplateLine templateLine = this.parseTemplateLine(line, lineNumber, null, template, Element.TEMPLATE, tags, warnings);
                template.addTemplateLine(templateLine);
            }
            ++lineCount;
        }
        return template;
    }

    private Pair<String, Integer> parseSubordinateTemplate(int lineNumber, String line, Element element, String elementName, List<LocalizableMessage> warnings) throws DecodeException {
        String templateName;
        int colonPos = line.indexOf(58, SUBORDINATE_TEMPLATE_LABEL.length());
        int numEntries = -1;
        if (colonPos <= SUBORDINATE_TEMPLATE_LABEL.length()) {
            templateName = line.substring(SUBORDINATE_TEMPLATE_LABEL.length(), line.length()).trim();
        } else {
            templateName = line.substring(SUBORDINATE_TEMPLATE_LABEL.length(), colonPos).trim();
            try {
                numEntries = Integer.parseInt(line.substring(colonPos + 1).trim());
                if (numEntries == 0) {
                    warnings.add(CoreMessages.WARN_ENTRY_GENERATOR_SUBORDINATE_ZERO_ENTRIES.get((Object)(lineNumber + 1), (Object)element.getLabel(), (Object)elementName, (Object)templateName));
                }
            }
            catch (NumberFormatException nfe) {
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_SUBORDINATE_CANT_PARSE_NUMENTRIES.get((Object)templateName, (Object)(lineNumber + 1), (Object)element.getLabel(), (Object)elementName));
            }
        }
        return Pair.of((Object)templateName, (Object)numEntries);
    }

    private TemplateLine parseTemplateLine(String line, int lineNumber, Branch branch, Template template, Element element, Map<String, TemplateTag> tags, List<LocalizableMessage> warnings) throws DecodeException {
        String elementName = element == Element.BRANCH ? branch.getBranchDN().toString() : template.getName();
        String lowerLine = line.toLowerCase();
        int colonPos = lowerLine.indexOf(58);
        if (colonPos < 0) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_NO_COLON_IN_TEMPLATE_LINE.get((Object)(lineNumber + 1), (Object)element.getLabel(), (Object)elementName));
        }
        if (colonPos == 0) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_NO_ATTR_IN_TEMPLATE_LINE.get((Object)(lineNumber + 1), (Object)element.getLabel(), (Object)elementName));
        }
        AttributeType attributeType = this.schema.getAttributeType(lowerLine.substring(0, colonPos));
        int length = line.length();
        int pos = colonPos + 1;
        boolean valueIsURL = false;
        boolean valueIsBase64 = false;
        if (pos < length) {
            if (lowerLine.charAt(pos) == '<') {
                valueIsURL = true;
                ++pos;
            } else if (lowerLine.charAt(pos) == ':') {
                valueIsBase64 = true;
                ++pos;
            }
        }
        while (pos < length && lowerLine.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            warnings.add(CoreMessages.WARN_ENTRY_GENERATOR_NO_VALUE_IN_TEMPLATE_LINE.get((Object)(lineNumber + 1), (Object)element.getLabel(), (Object)elementName));
        }
        int phase = 0;
        int previousPhase = 0;
        ArrayList<TemplateTag> tagList = new ArrayList<TemplateTag>();
        StringBuilder buffer = new StringBuilder();
        while (pos < length) {
            char c = line.charAt(pos);
            block0 : switch (phase) {
                case 0: {
                    TemplateTag t;
                    switch (c) {
                        case '\\': {
                            phase = 3;
                            previousPhase = 0;
                            break block0;
                        }
                        case '<': {
                            String[] args;
                            if (buffer.length() > 0) {
                                t = new TemplateTag.StaticTextTag();
                                args = new String[]{buffer.toString()};
                                ((TemplateTag.StaticTextTag)t).initializeForBranch(this.schema, this, branch, args, lineNumber, warnings);
                                tagList.add(t);
                                buffer = new StringBuilder();
                            }
                            phase = 1;
                            break block0;
                        }
                        case '{': {
                            String[] args;
                            if (buffer.length() > 0) {
                                t = new TemplateTag.StaticTextTag();
                                args = new String[]{buffer.toString()};
                                ((TemplateTag.StaticTextTag)t).initializeForBranch(this.schema, this, branch, args, lineNumber, warnings);
                                tagList.add(t);
                                buffer = new StringBuilder();
                            }
                            phase = 2;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 1: {
                    TemplateTag t;
                    switch (c) {
                        case '\\': {
                            phase = 3;
                            previousPhase = 1;
                            break block0;
                        }
                        case '>': {
                            t = this.parseReplacementTag(buffer.toString(), branch, template, lineNumber, tags, warnings);
                            tagList.add(t);
                            buffer = new StringBuilder();
                            phase = 0;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    TemplateTag t;
                    switch (c) {
                        case '\\': {
                            phase = 3;
                            previousPhase = 2;
                            break block0;
                        }
                        case '}': {
                            t = this.parseAttributeTag(buffer.toString(), branch, template, lineNumber, warnings);
                            tagList.add(t);
                            buffer = new StringBuilder();
                            phase = 0;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                    phase = previousPhase;
                }
            }
            ++pos;
        }
        if (phase == 0) {
            if (buffer.length() > 0) {
                TemplateTag.StaticTextTag t = new TemplateTag.StaticTextTag();
                String[] args = new String[]{buffer.toString()};
                t.initializeForBranch(this.schema, this, branch, args, lineNumber, warnings);
                tagList.add(t);
            }
        } else {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_INCOMPLETE_TAG.get((Object)(lineNumber + 1)));
        }
        return new TemplateLine(attributeType, lineNumber, tagList, valueIsURL, valueIsBase64);
    }

    private TemplateTag parseReplacementTag(String tagString, Branch branch, Template template, int lineNumber, Map<String, TemplateTag> tags, List<LocalizableMessage> warnings) throws DecodeException {
        TemplateTag newTag;
        StringTokenizer tokenizer = new StringTokenizer(tagString, ":");
        String tagName = tokenizer.nextToken().trim();
        String lowerTagName = tagName.toLowerCase();
        TemplateTag tag = this.getTag(lowerTagName);
        if (tag == null && (tag = tags.get(lowerTagName)) == null) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_NO_SUCH_TAG.get((Object)tagName, (Object)(lineNumber + 1)));
        }
        ArrayList<String> args = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            args.add(tokenizer.nextToken().trim());
        }
        String[] arguments = args.toArray(new String[args.size()]);
        try {
            newTag = (TemplateTag)tag.getClass().newInstance();
        }
        catch (Exception e) {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_CANNOT_INSTANTIATE_NEW_TAG.get((Object)tagName, (Object)(lineNumber + 1), (Object)String.valueOf(e)), e);
        }
        if (branch == null) {
            newTag.initializeForTemplate(this.schema, this, template, arguments, lineNumber, warnings);
        } else if (newTag.allowedInBranch()) {
            newTag.initializeForBranch(this.schema, this, branch, arguments, lineNumber, warnings);
        } else {
            throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TAG_NOT_ALLOWED_IN_BRANCH.get((Object)newTag.getName(), (Object)(lineNumber + 1)));
        }
        return newTag;
    }

    private TemplateTag parseAttributeTag(String tagString, Branch branch, Template template, int lineNumber, List<LocalizableMessage> warnings) throws DecodeException {
        StringTokenizer tokenizer = new StringTokenizer(tagString, ":");
        ArrayList<String> args = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            args.add(tokenizer.nextToken());
        }
        String[] arguments = args.toArray(new String[args.size()]);
        TemplateTag.AttributeValueTag tag = new TemplateTag.AttributeValueTag();
        if (branch != null) {
            tag.initializeForBranch(this.schema, this, branch, arguments, lineNumber, warnings);
        } else {
            tag.initializeForTemplate(this.schema, this, template, arguments, lineNumber, warnings);
        }
        return tag;
    }

    private File getFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        if (this.resourcePath != null && (file = new File(this.resourcePath + File.separator + filePath)).exists()) {
            return file;
        }
        return null;
    }

    BufferedReader getReader(String filePath) {
        BufferedReader reader = null;
        File file = new File(filePath);
        try {
            InputStream stream;
            if (file.exists()) {
                reader = new BufferedReader(new FileReader(file));
            } else if (this.resourcePath != null && (file = new File(this.resourcePath + File.separator + filePath)).exists()) {
                reader = new BufferedReader(new FileReader(file));
            }
            if (reader == null && (stream = TemplateFile.class.getClassLoader().getResourceAsStream("org/forgerock/opendj/ldif/" + filePath)) != null) {
                reader = new BufferedReader(new InputStreamReader(stream));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return reader;
    }

    String[] getLines(String identifier, BufferedReader reader) throws IOException {
        String[] lines = this.fileLines.get(identifier);
        if (lines == null) {
            lines = this.readLines(reader).toArray(new String[0]);
            this.fileLines.put(identifier, lines);
        }
        return lines;
    }

    private List<String> readLines(BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        int lineNumber = 1;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(" ")) {
                int lastLineIndex = lines.size() - 1;
                String previousLine = (String)lines.get(lastLineIndex);
                if (lines.isEmpty() || previousLine.isEmpty()) {
                    throw DecodeException.fatalError(CoreMessages.ERR_TEMPLATE_FILE_INVALID_LEADING_SPACE.get((Object)lineNumber, (Object)line));
                }
                lines.set(lastLineIndex, previousLine + line.substring(1));
            } else {
                lines.add(line);
            }
            ++lineNumber;
        }
        return lines;
    }

    boolean hasNext() {
        if (this.nextEntry != null) {
            return true;
        }
        while (this.currentBranch != null) {
            if (this.currentBranch.hasNext()) {
                this.nextEntry = this.currentBranch.nextEntry();
                return true;
            }
            this.currentBranch = this.branchesIterator.hasNext() ? this.branchesIterator.next() : null;
        }
        return false;
    }

    Entry nextEntry() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Entry entry = this.nextEntry.toEntry();
        this.nextEntry = null;
        return entry;
    }

    static class TemplateValue {
        private final StringBuilder templateValue;
        private final TemplateLine templateLine;

        TemplateValue(TemplateLine templateLine) {
            this.templateLine = templateLine;
            this.templateValue = new StringBuilder();
        }

        AttributeType getAttributeType() {
            return this.templateLine.getAttributeType();
        }

        String getValueAsString() {
            return this.templateValue.toString();
        }

        void append(String s) {
            this.templateValue.append(s);
        }

        void append(Object o) {
            this.templateValue.append(o);
        }
    }

    static class TemplateLine {
        private final AttributeType attributeType;
        private final int lineNumber;
        private final List<TemplateTag> tags;
        private final boolean isURL;
        private final boolean isBase64;

        TemplateLine(AttributeType attributeType, int lineNumber, List<TemplateTag> tags) {
            this(attributeType, lineNumber, tags, false, false);
        }

        TemplateLine(AttributeType attributeType, int lineNumber, List<TemplateTag> tags, boolean isURL, boolean isBase64) {
            this.attributeType = attributeType;
            this.lineNumber = lineNumber;
            this.tags = tags;
            this.isURL = isURL;
            this.isBase64 = isBase64;
        }

        AttributeType getAttributeType() {
            return this.attributeType;
        }

        TemplateTag.TagResult generateLine(TemplateEntry templateEntry) {
            TemplateValue value = new TemplateValue(this);
            for (TemplateTag tag : this.tags) {
                TemplateTag.TagResult result = tag.generateValue(templateEntry, value);
                if (result == TemplateTag.TagResult.SUCCESS) continue;
                return result;
            }
            templateEntry.addValue(value);
            return TemplateTag.TagResult.SUCCESS;
        }
    }

    static class TemplateEntry {
        static final TemplateEntry NULL_TEMPLATE_ENTRY = new TemplateEntry(null, null);
        private DN dn;
        private final DN parentDN;
        private final LinkedHashMap<AttributeType, List<TemplateValue>> attributes = new LinkedHashMap();
        private final Template template;

        TemplateEntry(Branch branch) {
            this.dn = branch.getBranchDN();
            this.template = null;
            this.parentDN = null;
        }

        TemplateEntry(Template template, DN parentDN) {
            this.template = template;
            this.parentDN = parentDN;
        }

        DN getParentDN() {
            return this.parentDN;
        }

        DN getDN() {
            if (this.dn == null) {
                ArrayList<AVA> avas = new ArrayList<AVA>();
                for (AttributeType attrType : this.template.getRDNAttributes()) {
                    TemplateValue templateValue = this.getValue(attrType);
                    if (templateValue == null) {
                        return null;
                    }
                    avas.add(new AVA(attrType, (Object)templateValue.getValueAsString()));
                }
                this.dn = this.parentDN.child(new RDN(avas));
            }
            return this.dn;
        }

        TemplateValue getValue(AttributeType attributeType) {
            List<TemplateValue> values = this.attributes.get(attributeType);
            if (values != null) {
                return values.get(0);
            }
            return null;
        }

        List<TemplateValue> getValues(AttributeType attributeType) {
            return this.attributes.get(attributeType);
        }

        void addValue(TemplateValue value) {
            List<TemplateValue> values = this.attributes.get(value.getAttributeType());
            if (values == null) {
                values = new ArrayList<TemplateValue>();
                this.attributes.put(value.getAttributeType(), values);
            }
            values.add(value);
        }

        Entry toEntry() {
            LinkedHashMapEntry entry = new LinkedHashMapEntry(this.getDN());
            for (AttributeType attributeType : this.attributes.keySet()) {
                List<TemplateValue> valueList = this.attributes.get(attributeType);
                LinkedAttribute newAttribute = new LinkedAttribute(AttributeDescription.create(attributeType));
                for (TemplateValue value : valueList) {
                    newAttribute.add(new Object[]{value.getValueAsString()});
                }
                entry.addAttribute(newAttribute);
            }
            return entry;
        }
    }

    static class Template {
        private final List<AttributeType> rdnAttributes;
        private final List<Integer> numEntriesPerTemplate;
        private final String name;
        private final List<String> subTemplateNames;
        private List<Template> subTemplates;
        private final TemplateFile templateFile;
        private final List<TemplateLine> templateLines;
        private DN parentDN;
        private int numberOfEntries;
        private int entriesCount;
        private boolean currentEntryIsInitialized;
        private int subTemplateIndex;
        private TemplateEntry nextEntry;

        Template(TemplateFile templateFile, String name, List<AttributeType> rdnAttributes, List<String> subordinateTemplateNames, List<Integer> numEntriesPerTemplate, List<TemplateLine> templateLines) {
            this.templateFile = templateFile;
            this.name = name;
            this.rdnAttributes = rdnAttributes;
            this.subTemplateNames = subordinateTemplateNames;
            this.numEntriesPerTemplate = numEntriesPerTemplate;
            this.templateLines = templateLines;
        }

        void completeTemplateInitialization(Map<String, Template> templates) throws DecodeException {
            this.subTemplates = new ArrayList<Template>();
            for (String subordinateName : this.subTemplateNames) {
                Template template = templates.get(subordinateName.toLowerCase());
                if (template == null) {
                    throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_UNDEFINED_TEMPLATE_SUBORDINATE.get((Object)this.name, (Object)subordinateName));
                }
                this.subTemplates.add(template);
            }
            this.ensureAllRDNAttributesAreDefined();
        }

        private void ensureAllRDNAttributesAreDefined() throws DecodeException {
            HashSet<AttributeType> rdnAttrs = new HashSet<AttributeType>(this.rdnAttributes);
            ArrayList<AttributeType> templateAttrs = new ArrayList<AttributeType>();
            for (TemplateLine line : this.templateLines) {
                templateAttrs.add(line.getAttributeType());
            }
            rdnAttrs.removeAll(templateAttrs);
            if (!rdnAttrs.isEmpty()) {
                AttributeType t = (AttributeType)rdnAttrs.iterator().next();
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_TEMPLATE_MISSING_RDN_ATTR.get((Object)this.name, (Object)t.getNameOrOID()));
            }
        }

        String getName() {
            return this.name;
        }

        List<AttributeType> getRDNAttributes() {
            return this.rdnAttributes;
        }

        List<TemplateLine> getTemplateLines() {
            return this.templateLines;
        }

        void addTemplateLine(TemplateLine line) {
            this.templateLines.add(line);
        }

        boolean hasAttribute(AttributeType attributeType) {
            for (TemplateLine line : this.templateLines) {
                if (!line.getAttributeType().equals(attributeType)) continue;
                return true;
            }
            return false;
        }

        void reset(DN parentDN, int numberOfEntries) {
            this.parentDN = parentDN;
            this.numberOfEntries = numberOfEntries;
            this.entriesCount = 0;
            this.currentEntryIsInitialized = false;
            this.subTemplateIndex = 0;
            this.nextEntry = null;
        }

        private TemplateEntry buildTemplateEntry() {
            this.templateFile.nextFirstAndLastNames();
            TemplateEntry templateEntry = new TemplateEntry(this, this.parentDN);
            for (TemplateLine line : this.templateLines) {
                line.generateLine(templateEntry);
            }
            for (int i = 0; i < this.subTemplates.size(); ++i) {
                this.subTemplates.get(i).reset(templateEntry.getDN(), this.numEntriesPerTemplate.get(i));
            }
            return templateEntry;
        }

        boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            while (this.entriesCount < this.numberOfEntries || this.generateForever()) {
                if (!this.currentEntryIsInitialized) {
                    this.nextEntry = this.buildTemplateEntry();
                    this.currentEntryIsInitialized = true;
                    return true;
                }
                if (this.nextEntry == null) {
                    while (this.subTemplateIndex < this.subTemplates.size()) {
                        if (this.subTemplates.get(this.subTemplateIndex).hasNext()) {
                            this.nextEntry = this.subTemplates.get(this.subTemplateIndex).nextEntry();
                            if (this.nextEntry != null) {
                                return true;
                            }
                        }
                        ++this.subTemplateIndex;
                    }
                }
                ++this.entriesCount;
                this.currentEntryIsInitialized = false;
                this.subTemplateIndex = 0;
            }
            return false;
        }

        private boolean generateForever() {
            return this.numberOfEntries < 0;
        }

        TemplateEntry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TemplateEntry entry = this.nextEntry;
            this.nextEntry = null;
            return entry;
        }
    }

    static final class Branch {
        private final DN branchDN;
        private final List<Integer> numEntriesPerTemplate;
        private final List<String> subordinateTemplateNames;
        private List<Template> subordinateTemplates;
        private final List<TemplateLine> rdnLines;
        private final List<TemplateLine> extraLines;
        private TemplateEntry nextEntry;
        private int currentSubTemplateIndex;

        Branch(TemplateFile templateFile, DN branchDN, Schema schema) throws DecodeException {
            this(templateFile, branchDN, schema, new ArrayList<String>(), new ArrayList<Integer>(), new ArrayList<TemplateLine>());
        }

        Branch(TemplateFile templateFile, DN branchDN, Schema schema, List<String> subordinateTemplateNames, List<Integer> numEntriesPerTemplate, List<TemplateLine> extraLines) throws DecodeException {
            this.branchDN = branchDN;
            this.subordinateTemplateNames = subordinateTemplateNames;
            this.numEntriesPerTemplate = numEntriesPerTemplate;
            this.extraLines = extraLines;
            ArrayList<LocalizableMessage> warnings = new ArrayList<LocalizableMessage>();
            this.rdnLines = new ArrayList<TemplateLine>();
            for (AVA ava : branchDN.rdn()) {
                Attribute attribute = ava.toAttribute();
                for (ByteString value : attribute.toArray()) {
                    List<TemplateTag> tags = this.buildTagListForValue(value.toString(), templateFile, schema, warnings);
                    this.rdnLines.add(new TemplateLine(attribute.getAttributeDescription().getAttributeType(), 0, tags));
                }
            }
        }

        private List<TemplateTag> buildTagListForValue(String value, TemplateFile templateFile, Schema schema, List<LocalizableMessage> warnings) throws DecodeException {
            TemplateTag.StaticTextTag tag = new TemplateTag.StaticTextTag();
            tag.initializeForBranch(schema, templateFile, this, new String[]{value}, 0, warnings);
            ArrayList<TemplateTag> tags = new ArrayList<TemplateTag>();
            tags.add(tag);
            return tags;
        }

        private void completeBranchInitialization(Map<String, Template> templates, boolean generateBranches) throws DecodeException {
            this.subordinateTemplates = new ArrayList<Template>();
            for (int i = 0; i < this.subordinateTemplateNames.size(); ++i) {
                this.subordinateTemplates.add(templates.get(this.subordinateTemplateNames.get(i).toLowerCase()));
                if (this.subordinateTemplates.get(i) != null) continue;
                throw DecodeException.fatalError(CoreMessages.ERR_ENTRY_GENERATOR_UNDEFINED_BRANCH_SUBORDINATE.get((Object)this.branchDN.toString(), (Object)this.subordinateTemplateNames.get(i)));
            }
            this.nextEntry = this.buildBranchEntry(generateBranches);
        }

        DN getBranchDN() {
            return this.branchDN;
        }

        void addSubordinateTemplate(String name, int numEntries) {
            this.subordinateTemplateNames.add(name);
            this.numEntriesPerTemplate.add(numEntries);
        }

        void addExtraLine(TemplateLine line) {
            this.extraLines.add(line);
        }

        boolean hasAttribute(AttributeType attributeType) {
            if (this.branchDN.rdn().getAttributeValue(attributeType) != null) {
                return true;
            }
            for (TemplateLine line : this.extraLines) {
                if (!line.getAttributeType().equals(attributeType)) continue;
                return true;
            }
            return false;
        }

        private TemplateEntry buildBranchEntry(boolean generateBranches) {
            TemplateEntry entry = new TemplateEntry(this);
            ArrayList<TemplateLine> lines = new ArrayList<TemplateLine>(this.rdnLines);
            lines.addAll(this.extraLines);
            for (TemplateLine line : lines) {
                line.generateLine(entry);
            }
            for (int i = 0; i < this.subordinateTemplates.size(); ++i) {
                this.subordinateTemplates.get(i).reset(entry.getDN(), this.numEntriesPerTemplate.get(i));
            }
            if (!generateBranches) {
                return null;
            }
            return entry;
        }

        boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            if (this.nextEntry == null) {
                while (this.currentSubTemplateIndex < this.subordinateTemplates.size()) {
                    if (this.subordinateTemplates.get(this.currentSubTemplateIndex).hasNext()) {
                        this.nextEntry = this.subordinateTemplates.get(this.currentSubTemplateIndex).nextEntry();
                        if (this.nextEntry != null) {
                            return true;
                        }
                    }
                    ++this.currentSubTemplateIndex;
                }
            }
            return false;
        }

        TemplateEntry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TemplateEntry entry = this.nextEntry;
            this.nextEntry = null;
            return entry;
        }
    }

    private static enum Element {
        BRANCH,
        TEMPLATE;


        String getLabel() {
            return this.toString().toLowerCase();
        }
    }

    private static class TemplateData {
        final Map<String, TemplateTag> tags = new LinkedHashMap<String, TemplateTag>();
        final Map<DN, Branch> branches = new LinkedHashMap<DN, Branch>();
        final Map<String, Template> templates = new LinkedHashMap<String, Template>();

        private TemplateData() {
        }
    }
}

