/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.LDAP;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordReader;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.ChangeRecordWriter;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIFChangeRecordWriter;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.opendj.ldif.RejectedChangeRecordListener;

public final class LDIF {
    private static final Comparator<byte[][]> DN_ORDER2 = new Comparator<byte[][]>(){

        @Override
        public int compare(byte[][] b1, byte[][] b2) {
            return DN_ORDER.compare(b1[0], b2[0]);
        }
    };
    private static final Comparator<byte[]> DN_ORDER = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] b1, byte[] b2) {
            ByteString bs = ByteString.valueOfBytes(b1);
            ByteString bs2 = ByteString.valueOfBytes(b2);
            return bs.compareTo(bs2);
        }
    };

    public static ChangeRecordWriter copyTo(ChangeRecordReader input, ChangeRecordWriter output) throws IOException {
        while (input.hasNext()) {
            output.writeChangeRecord(input.readChangeRecord());
        }
        return output;
    }

    public static EntryWriter copyTo(EntryReader input, EntryWriter output) throws IOException {
        while (input.hasNext()) {
            output.writeEntry(input.readEntry());
        }
        return output;
    }

    public static ChangeRecordReader diff(final EntryReader source, final EntryReader target) throws IOException {
        List<byte[][]> source2 = LDIF.readEntriesAsList(source);
        List<byte[][]> target2 = LDIF.readEntriesAsList(target);
        final Iterator<byte[][]> sourceIterator = source2.iterator();
        final Iterator<byte[][]> targetIterator = target2.iterator();
        return new ChangeRecordReader(){
            private Entry sourceEntry;
            private Entry targetEntry;
            {
                this.sourceEntry = this.nextEntry(sourceIterator);
                this.targetEntry = this.nextEntry(targetIterator);
            }

            @Override
            public void close() throws IOException {
                try {
                    source.close();
                }
                finally {
                    target.close();
                }
            }

            @Override
            public boolean hasNext() {
                return this.sourceEntry != null || this.targetEntry != null;
            }

            @Override
            public ChangeRecord readChangeRecord() throws IOException {
                if (this.sourceEntry != null && this.targetEntry != null) {
                    DN targetDN;
                    DN sourceDN = this.sourceEntry.getName();
                    int cmp = sourceDN.compareTo(targetDN = this.targetEntry.getName());
                    if (cmp == 0) {
                        ModifyRequest request = Requests.newModifyRequest(this.sourceEntry, this.targetEntry);
                        this.sourceEntry = this.nextEntry(sourceIterator);
                        this.targetEntry = this.nextEntry(targetIterator);
                        return request;
                    }
                    if (cmp < 0) {
                        DeleteRequest request = Requests.newDeleteRequest(this.sourceEntry.getName());
                        this.sourceEntry = this.nextEntry(sourceIterator);
                        return request;
                    }
                    AddRequest request = Requests.newAddRequest(this.targetEntry);
                    this.targetEntry = this.nextEntry(targetIterator);
                    return request;
                }
                if (this.sourceEntry != null) {
                    DeleteRequest request = Requests.newDeleteRequest(this.sourceEntry.getName());
                    this.sourceEntry = this.nextEntry(sourceIterator);
                    return request;
                }
                if (this.targetEntry != null) {
                    AddRequest request = Requests.newAddRequest(this.targetEntry);
                    this.targetEntry = this.nextEntry(targetIterator);
                    return request;
                }
                throw new NoSuchElementException();
            }

            private Entry nextEntry(Iterator<byte[][]> i) {
                if (i.hasNext()) {
                    return LDIF.decodeEntry(i.next()[1]);
                }
                return null;
            }
        };
    }

    public static Entry makeEntry(String ... ldifLines) {
        List<Entry> entries = LDIF.makeEntries(ldifLines);
        if (entries.size() > 1) {
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_READ_LDIF_ENTRY_MULTIPLE_ENTRIES_FOUND.get((Object)entries.size()));
        }
        return entries.get(0);
    }

    public static Entry makeEntry(List<String> ldifLines) {
        return LDIF.makeEntry(ldifLines.toArray(new String[ldifLines.size()]));
    }

    public static List<Entry> makeEntries(String ... ldifLines) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try (LDIFEntryReader reader = new LDIFEntryReader(ldifLines);){
            while (reader.hasNext()) {
                entries.add(reader.readEntry());
            }
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(e.getMessageObject());
        }
        catch (IOException e) {
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_READ_LDIF_RECORD_UNEXPECTED_IO_ERROR.get((Object)e.getMessage()));
        }
        if (entries.isEmpty()) {
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_READ_LDIF_ENTRY_NO_ENTRY_FOUND.get());
        }
        return entries;
    }

    public static List<Entry> makeEntries(List<String> ldifLines) {
        return LDIF.makeEntries(ldifLines.toArray(new String[ldifLines.size()]));
    }

    public static EntryReader newEntryCollectionReader(Collection<Entry> entries) {
        return new EntryIteratorReader(entries.iterator());
    }

    public static EntryReader newEntryIteratorReader(Iterator<Entry> entries) {
        return new EntryIteratorReader(entries);
    }

    public static EntryReader patch(EntryReader input, ChangeRecordReader patch) throws IOException {
        return LDIF.patch(input, patch, RejectedChangeRecordListener.OVERWRITE);
    }

    public static EntryReader patch(final EntryReader input, final ChangeRecordReader patch, final RejectedChangeRecordListener listener) throws IOException {
        final TreeMap<byte[], byte[]> entries = LDIF.readEntriesAsMap(input);
        while (patch.hasNext()) {
            ChangeRecord change = patch.readChangeRecord();
            final DN changeDN = change.getName();
            final byte[] changeNormDN = LDIF.toNormalizedByteArray(change.getName());
            DecodeException de = change.accept(new ChangeRecordVisitor<DecodeException, Void>(){

                @Override
                public DecodeException visitChangeRecord(Void p, AddRequest change) {
                    if (entries.get(changeNormDN) != null) {
                        Entry existingEntry = LDIF.decodeEntry((byte[])entries.get(changeNormDN));
                        try {
                            Entry entry = listener.handleDuplicateEntry(change, existingEntry);
                            entries.put(LDIF.toNormalizedByteArray(entry.getName()), LDIF.encodeEntry(entry)[1]);
                        }
                        catch (DecodeException e) {
                            return e;
                        }
                    } else {
                        entries.put(changeNormDN, LDIF.encodeEntry(change)[1]);
                    }
                    return null;
                }

                @Override
                public DecodeException visitChangeRecord(Void p, DeleteRequest change) {
                    if (entries.get(changeNormDN) == null) {
                        try {
                            listener.handleRejectedChangeRecord(change, CoreMessages.REJECTED_CHANGE_FAIL_DELETE.get((Object)change.getName().toString()));
                        }
                        catch (DecodeException e) {
                            return e;
                        }
                    }
                    try {
                        if (change.getControl(SubtreeDeleteRequestControl.DECODER, new DecodeOptions()) != null) {
                            entries.subMap(LDIF.toNormalizedByteArray(change.getName()), LDIF.toNormalizedByteArray(change.getName().child(RDN.maxValue()))).clear();
                        } else {
                            entries.remove(changeNormDN);
                        }
                    }
                    catch (DecodeException e) {
                        return e;
                    }
                    return null;
                }

                @Override
                public DecodeException visitChangeRecord(Void p, ModifyDNRequest change) {
                    if (entries.get(changeNormDN) == null) {
                        try {
                            listener.handleRejectedChangeRecord(change, CoreMessages.REJECTED_CHANGE_FAIL_MODIFYDN.get((Object)change.getName().toString()));
                        }
                        catch (DecodeException e) {
                            return e;
                        }
                    } else {
                        DN oldDN = changeDN;
                        DN newSuperior = change.getNewSuperior();
                        if (newSuperior == null && (newSuperior = change.getName().parent()) == null) {
                            newSuperior = DN.rootDN();
                        }
                        DN newDN = newSuperior.child(change.getNewRDN());
                        TreeMap<byte[], byte[]> renamedEntries = new TreeMap<byte[], byte[]>(DN_ORDER);
                        Iterator i = entries.subMap(changeNormDN, LDIF.toNormalizedByteArray(changeDN.child(RDN.maxValue()))).entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry e = i.next();
                            Iterator<AVA> entry = LDIF.decodeEntry((byte[])e.getValue());
                            DN renamedDN = entry.getName().rename(oldDN, newDN);
                            entry.setName(renamedDN);
                            renamedEntries.put(LDIF.toNormalizedByteArray(renamedDN), LDIF.encodeEntry(entry)[1]);
                            i.remove();
                        }
                        Entry targetEntry = LDIF.decodeEntry((byte[])renamedEntries.values().iterator().next());
                        if (change.isDeleteOldRDN()) {
                            for (AVA ava : oldDN.rdn()) {
                                targetEntry.removeAttribute(ava.toAttribute(), null);
                            }
                        }
                        for (AVA ava : newDN.rdn()) {
                            targetEntry.addAttribute(ava.toAttribute());
                        }
                        renamedEntries.remove(LDIF.toNormalizedByteArray(targetEntry.getName()));
                        renamedEntries.put(LDIF.toNormalizedByteArray(targetEntry.getName()), LDIF.encodeEntry(targetEntry)[1]);
                        Iterator j = renamedEntries.values().iterator();
                        while (j.hasNext()) {
                            Entry renamedEntry = LDIF.decodeEntry((byte[])j.next());
                            byte[] existingEntryDn = (byte[])entries.get(LDIF.toNormalizedByteArray(renamedEntry.getName()));
                            if (existingEntryDn != null) {
                                Entry existingEntry = LDIF.decodeEntry(existingEntryDn);
                                try {
                                    Entry tmp = listener.handleDuplicateEntry(change, existingEntry, renamedEntry);
                                    entries.put(LDIF.toNormalizedByteArray(tmp.getName()), LDIF.encodeEntry(tmp)[1]);
                                    continue;
                                }
                                catch (DecodeException e) {
                                    return e;
                                }
                            }
                            entries.put(LDIF.toNormalizedByteArray(renamedEntry.getName()), LDIF.encodeEntry(renamedEntry)[1]);
                        }
                        renamedEntries.clear();
                    }
                    return null;
                }

                @Override
                public DecodeException visitChangeRecord(Void p, ModifyRequest change) {
                    if (entries.get(changeNormDN) == null) {
                        try {
                            listener.handleRejectedChangeRecord(change, CoreMessages.REJECTED_CHANGE_FAIL_MODIFY.get((Object)change.getName().toString()));
                        }
                        catch (DecodeException e) {
                            return e;
                        }
                    } else {
                        Entry entry = LDIF.decodeEntry((byte[])entries.get(changeNormDN));
                        for (Modification modification : change.getModifications()) {
                            ModificationType modType = modification.getModificationType();
                            if (modType.equals(ModificationType.ADD)) {
                                entry.addAttribute(modification.getAttribute(), null);
                                continue;
                            }
                            if (modType.equals(ModificationType.DELETE)) {
                                entry.removeAttribute(modification.getAttribute(), null);
                                continue;
                            }
                            if (modType.equals(ModificationType.REPLACE)) {
                                entry.replaceAttribute(modification.getAttribute());
                                continue;
                            }
                            System.err.println("Unable to apply \"" + modType + "\" modification to entry \"" + change.getName() + "\": modification type not supported");
                        }
                        entries.put(changeNormDN, LDIF.encodeEntry(entry)[1]);
                    }
                    return null;
                }
            }, null);
            if (de == null) continue;
            throw de;
        }
        return new EntryReader(){
            private final Iterator<byte[]> iterator;
            {
                this.iterator = entries.values().iterator();
            }

            @Override
            public void close() throws IOException {
                try {
                    input.close();
                }
                finally {
                    patch.close();
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.iterator.hasNext();
            }

            @Override
            public Entry readEntry() throws IOException {
                return LDIF.decodeEntry(this.iterator.next());
            }
        };
    }

    public static EntryReader search(EntryReader input, SearchRequest search) {
        return LDIF.search(input, search, Schema.getDefaultSchema());
    }

    public static EntryReader search(final EntryReader input, final SearchRequest search, final Schema schema) {
        final Matcher matcher = search.getFilter().matcher(schema);
        return new EntryReader(){
            private Entry nextEntry = null;
            private int entryCount = 0;

            @Override
            public void close() throws IOException {
                input.close();
            }

            @Override
            public boolean hasNext() throws IOException {
                int sizeLimit;
                if (this.nextEntry == null && ((sizeLimit = search.getSizeLimit()) == 0 || this.entryCount < sizeLimit)) {
                    DN baseDN = search.getName();
                    SearchScope scope = search.getScope();
                    while (input.hasNext()) {
                        Entry entry = input.readEntry();
                        if (!entry.getName().isInScopeOf(baseDN, scope) || !matcher.matches(entry).toBoolean()) continue;
                        this.nextEntry = this.filterEntry(entry);
                        break;
                    }
                }
                return this.nextEntry != null;
            }

            @Override
            public Entry readEntry() throws IOException {
                if (this.hasNext()) {
                    Entry entry = this.nextEntry;
                    this.nextEntry = null;
                    ++this.entryCount;
                    return entry;
                }
                throw new NoSuchElementException();
            }

            private Entry filterEntry(Entry entry) {
                if (search.getAttributes().isEmpty()) {
                    if (search.isTypesOnly()) {
                        LinkedHashMapEntry filteredEntry = new LinkedHashMapEntry(entry.getName());
                        for (Attribute attribute : entry.getAllAttributes()) {
                            filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                        }
                        return filteredEntry;
                    }
                    return entry;
                }
                LinkedHashMapEntry filteredEntry = new LinkedHashMapEntry(entry.getName());
                for (String atd : search.getAttributes()) {
                    if ("*".equals(atd)) {
                        for (Attribute attribute : entry.getAllAttributes()) {
                            if (attribute.getAttributeDescription().getAttributeType().getUsage() != AttributeUsage.USER_APPLICATIONS) continue;
                            if (search.isTypesOnly()) {
                                filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                                continue;
                            }
                            filteredEntry.addAttribute(attribute);
                        }
                        continue;
                    }
                    if ("+".equals(atd)) {
                        for (Attribute attribute : entry.getAllAttributes()) {
                            if (attribute.getAttributeDescription().getAttributeType().getUsage() == AttributeUsage.USER_APPLICATIONS) continue;
                            if (search.isTypesOnly()) {
                                filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                                continue;
                            }
                            filteredEntry.addAttribute(attribute);
                        }
                        continue;
                    }
                    AttributeDescription ad = AttributeDescription.valueOf(atd, schema);
                    for (Attribute attribute : entry.getAllAttributes(ad)) {
                        if (search.isTypesOnly()) {
                            filteredEntry.addAttribute(Attributes.emptyAttribute(attribute.getAttributeDescription()));
                            continue;
                        }
                        filteredEntry.addAttribute(attribute);
                    }
                }
                return filteredEntry;
            }
        };
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toLDIF(Entry entry) {
        try (StringWriter writer = new StringWriter();){
            String string;
            try (LDIFEntryWriter ldifWriter = new LDIFEntryWriter(writer);){
                ldifWriter.writeEntry(entry);
                ldifWriter.flush();
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String toLDIF(ChangeRecord change) {
        try (StringWriter writer = new StringWriter();){
            String string;
            try (LDIFChangeRecordWriter ldifWriter = new LDIFChangeRecordWriter(writer);){
                ldifWriter.writeChangeRecord(change).toString();
                ldifWriter.flush();
                string = writer.toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<byte[][]> readEntriesAsList(EntryReader reader) throws IOException {
        ArrayList<byte[][]> entries = new ArrayList<byte[][]>();
        while (reader.hasNext()) {
            Entry entry = reader.readEntry();
            entries.add(LDIF.encodeEntry(entry));
        }
        Collections.sort(entries, DN_ORDER2);
        return entries;
    }

    private static TreeMap<byte[], byte[]> readEntriesAsMap(EntryReader reader) throws IOException {
        TreeMap<byte[], byte[]> entries = new TreeMap<byte[], byte[]>(DN_ORDER);
        while (reader.hasNext()) {
            Entry entry = reader.readEntry();
            byte[][] bEntry = LDIF.encodeEntry(entry);
            entries.put(bEntry[0], bEntry[1]);
        }
        return entries;
    }

    private static Entry decodeEntry(byte[] asn1EntryFormat) {
        try {
            return LDAP.readEntry(ASN1.getReader(asn1EntryFormat), new DecodeOptions());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static byte[] toNormalizedByteArray(DN dn) {
        return dn.toNormalizedByteString().toByteArray();
    }

    private static byte[][] encodeEntry(Entry entry) {
        byte[][] bEntry = new byte[2][];
        bEntry[0] = LDIF.toNormalizedByteArray(entry.getName());
        try {
            ByteStringBuilder bsb = new ByteStringBuilder();
            LDAP.writeEntry(ASN1.getWriter(bsb), entry);
            bEntry[1] = bsb.toByteArray();
            return bEntry;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    private LDIF() {
    }

    private static final class EntryIteratorReader
    implements EntryReader {
        private final Iterator<Entry> iterator;

        private EntryIteratorReader(Iterator<Entry> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry readEntry() {
            return this.iterator.next();
        }
    }
}

