/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class EnumSyntaxImpl
extends AbstractSyntaxImpl {
    private final String oid;
    private final List<String> entries;

    EnumSyntaxImpl(String oid, List<String> entries) {
        this.oid = oid;
        ArrayList<String> entryStrings = new ArrayList<String>(entries.size());
        for (String entry : entries) {
            String normalized = this.normalize(ByteString.valueOfUtf8(entry));
            if (entryStrings.contains(normalized)) continue;
            entryStrings.add(normalized);
        }
        this.entries = Collections.unmodifiableList(entryStrings);
    }

    @Override
    public String getApproximateMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return this.oid;
    }

    @Override
    public String getOrderingMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.8." + this.oid;
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    public int indexOf(ByteSequence value) {
        return this.entries.indexOf(this.normalize(value));
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        boolean isAllowed = this.entries.contains(this.normalize(value));
        if (!isAllowed) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_INVALID_VALUE.get((Object)value.toString(), (Object)this.oid);
            invalidReason.append(message);
        }
        return isAllowed;
    }

    private String normalize(ByteSequence value) {
        return SchemaUtils.normalizeStringAttributeValue(value, true, true).toString();
    }
}

