/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.forgerock.opendj.ldap.KeyManagers;

public final class SSLContextBuilder {
    public static final String PROTOCOL_SSL = "SSL";
    public static final String PROTOCOL_SSL2 = "SSLv2";
    public static final String PROTOCOL_SSL3 = "SSLv3";
    public static final String PROTOCOL_TLS = "TLS";
    public static final String PROTOCOL_TLS1 = "TLSv1";
    public static final String PROTOCOL_TLS1_1 = "TLSv1.1";
    public static final String PROTOCOL_TLS1_2 = "TLSv1.2";
    private TrustManager trustManager;
    private KeyManager keyManager;
    private String protocol = "TLSv1";
    private SecureRandom random;
    private Provider provider;
    private String providerName;

    public SSLContextBuilder() {
        try {
            this.keyManager = KeyManagers.useJvmDefaultKeyStore();
        }
        catch (IOException | GeneralSecurityException ex) {
            this.keyManager = null;
        }
    }

    public SSLContext getSSLContext() throws GeneralSecurityException {
        TrustManager[] tm = null;
        if (this.trustManager != null) {
            tm = new TrustManager[]{this.trustManager};
        }
        KeyManager[] km = null;
        if (this.keyManager != null) {
            km = new KeyManager[]{this.keyManager};
        }
        SSLContext sslContext = this.provider != null ? SSLContext.getInstance(this.protocol, this.provider) : (this.providerName != null ? SSLContext.getInstance(this.protocol, this.providerName) : SSLContext.getInstance(this.protocol));
        sslContext.init(km, tm, this.random);
        return sslContext;
    }

    public SSLContextBuilder setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
        return this;
    }

    public SSLContextBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SSLContextBuilder setProvider(Provider provider) {
        this.provider = provider;
        this.providerName = null;
        return this;
    }

    public SSLContextBuilder setProvider(String providerName) {
        this.provider = null;
        this.providerName = providerName;
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public SSLContextBuilder setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }
}

