/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LoadBalancer;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

final class RequestLoadBalancer
extends LoadBalancer {
    private final Function<Request, RequestWithIndex, NeverThrowsException> nextFactoryFunction;
    private final Function<Integer, Void, NeverThrowsException> endOfRequestFunction;

    RequestLoadBalancer(String loadBalancerName, Collection<? extends ConnectionFactory> factories, Options options, Function<Request, RequestWithIndex, NeverThrowsException> nextFactoryFunction, Function<Integer, Void, NeverThrowsException> endOfRequestFunction) {
        super(loadBalancerName, factories, options);
        this.nextFactoryFunction = nextFactoryFunction;
        this.endOfRequestFunction = endOfRequestFunction;
    }

    @Override
    public final Connection getConnection() throws LdapException {
        return new ConnectionImpl();
    }

    @Override
    public final Promise<Connection, LdapException> getConnectionAsync() {
        return Promises.newResultPromise((Object)new ConnectionImpl());
    }

    private static class ConnectionContext {
        private final AtomicReference<Connection> connectionHolder = new AtomicReference();
        private final LdapPromise<Connection> connectionPromise;
        private final RequestWithIndex requestWithIndex;

        ConnectionContext(LdapPromise<Connection> connectionPromise, RequestWithIndex requestWithIndex) {
            this.requestWithIndex = requestWithIndex;
            this.connectionPromise = connectionPromise;
        }

        Connection getConnection() {
            return this.connectionHolder.get();
        }

        void setConnection(Connection connection) {
            this.connectionHolder.set(connection);
        }

        LdapPromise<Connection> getConnectionPromise() {
            return this.connectionPromise;
        }

        int getServerIndex() {
            return this.requestWithIndex.getServerIndex();
        }

        Request getRequest() {
            return this.requestWithIndex.getRequest();
        }
    }

    static class RequestWithIndex {
        private final Request request;
        private final int serverIndex;

        RequestWithIndex(Request request, int serverIndex) {
            this.serverIndex = serverIndex;
            this.request = request;
        }

        Request getRequest() {
            return this.request;
        }

        int getServerIndex() {
            return this.serverIndex;
        }
    }

    private class ConnectionImpl
    extends AbstractAsynchronousConnection {
        private final ConnectionState state = new ConnectionState();

        private ConnectionImpl() {
        }

        @Override
        public String toString() {
            return RequestLoadBalancer.this.getLoadBalancerName() + "Connection";
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return LdapPromises.newSuccessfulLdapPromise(null);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.addAsync((AddRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, BindResult, LdapException>(){

                public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.bindAsync((BindRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.state.notifyConnectionClosed();
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, CompareResult, LdapException>(){

                public Promise<CompareResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.compareAsync((CompareRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.deleteAsync((DeleteRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, R, LdapException>(){

                public Promise<R, LdapException> apply(Connection connection) throws LdapException {
                    return connection.extendedRequestAsync((ExtendedRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyAsync((ModifyRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyDNAsync((ModifyDNRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, final IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler entryHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.searchAsync((SearchRequest)connectionContext.getRequest(), intermediateResponseHandler, entryHandler);
                }
            });
        }

        private ConnectionContext getConnection(Request request) {
            if (this.state.isClosed()) {
                throw new IllegalStateException();
            }
            try {
                RequestWithIndex requestWithIndex = (RequestWithIndex)RequestLoadBalancer.this.nextFactoryFunction.apply((Object)request);
                ConnectionFactory factory = RequestLoadBalancer.this.getMonitoredConnectionFactory(requestWithIndex.getServerIndex());
                return new ConnectionContext(LdapPromises.asPromise(factory.getConnectionAsync().thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    public void handleException(LdapException e) {
                        ConnectionImpl.this.state.notifyConnectionError(false, e);
                    }
                })), requestWithIndex);
            }
            catch (LdapException e) {
                this.state.notifyConnectionError(false, e);
                LdapPromise<Connection> failedLdapPromise = LdapPromises.newFailedLdapPromise(e);
                return new ConnectionContext(failedLdapPromise, new RequestWithIndex(request, -1));
            }
        }

        private <R> LdapPromise<R> executeRequest(final ConnectionContext connectionContext, AsyncFunction<Connection, R, LdapException> requestSender) {
            return connectionContext.getConnectionPromise().thenOnResult(new ResultHandler<Connection>(){

                public void handleResult(Connection connection) {
                    connectionContext.setConnection(connection);
                }
            }).thenAsync(requestSender).thenFinally(new Runnable(){

                @Override
                public void run() {
                    Utils.closeSilently((Closeable[])new Closeable[]{connectionContext.getConnection()});
                    RequestLoadBalancer.this.endOfRequestFunction.apply((Object)connectionContext.getServerIndex());
                }
            });
        }
    }
}

