/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

public final class Functions {
    private static final Function<ByteString, String, NeverThrowsException> BYTESTRING_TO_STRING = new Function<ByteString, String, NeverThrowsException>(){

        public String apply(ByteString value) {
            return value.toString();
        }
    };
    private static final Function<Object, Object, NeverThrowsException> IDENTITY = new Function<Object, Object, NeverThrowsException>(){

        public Object apply(Object value) {
            return value;
        }
    };
    private static final Function<String, String, NeverThrowsException> NORMALIZE_STRING = new Function<String, String, NeverThrowsException>(){

        public String apply(String value) {
            return StaticUtils.toLowerCase(value).trim();
        }
    };
    private static final Function<Object, ByteString, NeverThrowsException> OBJECT_TO_BYTESTRING = new Function<Object, ByteString, NeverThrowsException>(){

        public ByteString apply(Object value) {
            return ByteString.valueOfObject(value);
        }
    };
    private static final Function<String, Boolean, LocalizedIllegalArgumentException> STRING_TO_BOOLEAN = new Function<String, Boolean, LocalizedIllegalArgumentException>(){

        public Boolean apply(String value) {
            String valueString = StaticUtils.toLowerCase(value);
            if ("true".equals(valueString) || "yes".equals(valueString) || "on".equals(valueString) || "1".equals(valueString)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueString) || "no".equals(valueString) || "off".equals(valueString) || "0".equals(valueString)) {
                return Boolean.FALSE;
            }
            throw new LocalizedIllegalArgumentException(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get((Object)valueString));
        }
    };
    private static final Function<String, GeneralizedTime, LocalizedIllegalArgumentException> STRING_TO_GTIME = new Function<String, GeneralizedTime, LocalizedIllegalArgumentException>(){

        public GeneralizedTime apply(String value) {
            return GeneralizedTime.valueOf(value);
        }
    };
    private static final Function<String, Integer, LocalizedIllegalArgumentException> STRING_TO_INTEGER = new Function<String, Integer, LocalizedIllegalArgumentException>(){

        public Integer apply(String value) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.FUNCTIONS_TO_INTEGER_FAIL.get((Object)value);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
    };
    private static final Function<String, Long, LocalizedIllegalArgumentException> STRING_TO_LONG = new Function<String, Long, LocalizedIllegalArgumentException>(){

        public Long apply(String value) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.FUNCTIONS_TO_LONG_FAIL.get((Object)value);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
    };
    private static final Function<ByteString, Boolean, LocalizedIllegalArgumentException> BYTESTRING_TO_BOOLEAN = Functions.compose(Functions.byteStringToString(), STRING_TO_BOOLEAN);
    private static final Function<ByteString, X509Certificate, LocalizedIllegalArgumentException> BYTESTRING_TO_CERT = new Function<ByteString, X509Certificate, LocalizedIllegalArgumentException>(){

        public X509Certificate apply(ByteString value) {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                return (X509Certificate)factory.generateCertificate(value.asReader().asInputStream());
            }
            catch (CertificateException e) {
                String head = value.subSequence(0, Math.min(value.length(), 8)).toHexString();
                throw new LocalizedIllegalArgumentException(CoreMessages.FUNCTIONS_TO_CERT_FAIL.get((Object)head), (Throwable)e);
            }
        }
    };
    private static final Function<ByteString, GeneralizedTime, LocalizedIllegalArgumentException> BYTESTRING_TO_GTIME = Functions.compose(Functions.byteStringToString(), STRING_TO_GTIME);
    private static final Function<ByteString, Integer, LocalizedIllegalArgumentException> BYTESTRING_TO_INTEGER = Functions.compose(Functions.byteStringToString(), STRING_TO_INTEGER);
    private static final Function<ByteString, Long, LocalizedIllegalArgumentException> BYTESTRING_TO_LONG = Functions.compose(Functions.byteStringToString(), STRING_TO_LONG);

    public static <M, N> Function<M, N, NeverThrowsException> returns(final N constant) {
        return new Function<M, N, NeverThrowsException>(){

            public N apply(M value) {
                return constant;
            }
        };
    }

    public static <M, X, N, E extends Exception> Function<M, N, E> compose(final Function<M, X, NeverThrowsException> first, final Function<X, N, E> second) {
        return new Function<M, N, E>(){

            public N apply(M value) throws Exception {
                return second.apply(first.apply(value));
            }
        };
    }

    public static <M> Function<M, M, NeverThrowsException> identityFunction() {
        return IDENTITY;
    }

    public static Function<String, String, NeverThrowsException> normalizeString() {
        return NORMALIZE_STRING;
    }

    public static Function<Object, ByteString, NeverThrowsException> objectToByteString() {
        return OBJECT_TO_BYTESTRING;
    }

    public static Function<String, AttributeDescription, LocalizedIllegalArgumentException> stringToAttributeDescription() {
        return Functions.stringToAttributeDescription(Schema.getDefaultSchema());
    }

    public static Function<String, AttributeDescription, LocalizedIllegalArgumentException> stringToAttributeDescription(final Schema schema) {
        return new Function<String, AttributeDescription, LocalizedIllegalArgumentException>(){

            public AttributeDescription apply(String value) {
                return AttributeDescription.valueOf(value, schema);
            }
        };
    }

    public static Function<String, Boolean, LocalizedIllegalArgumentException> stringToBoolean() {
        return STRING_TO_BOOLEAN;
    }

    public static Function<String, DN, LocalizedIllegalArgumentException> stringToDN() {
        return Functions.stringToDN(Schema.getDefaultSchema());
    }

    public static Function<String, DN, LocalizedIllegalArgumentException> stringToDN(final Schema schema) {
        return new Function<String, DN, LocalizedIllegalArgumentException>(){

            public DN apply(String value) {
                return DN.valueOf(value, schema);
            }
        };
    }

    public static Function<String, GeneralizedTime, LocalizedIllegalArgumentException> stringToGeneralizedTime() {
        return STRING_TO_GTIME;
    }

    public static Function<String, Integer, LocalizedIllegalArgumentException> stringToInteger() {
        return STRING_TO_INTEGER;
    }

    public static Function<String, Long, LocalizedIllegalArgumentException> stringToLong() {
        return STRING_TO_LONG;
    }

    public static Function<ByteString, AttributeDescription, LocalizedIllegalArgumentException> byteStringToAttributeDescription() {
        return Functions.byteStringToAttributeDescription(Schema.getDefaultSchema());
    }

    public static Function<ByteString, AttributeDescription, LocalizedIllegalArgumentException> byteStringToAttributeDescription(Schema schema) {
        return Functions.compose(Functions.byteStringToString(), Functions.stringToAttributeDescription(schema));
    }

    public static Function<ByteString, Boolean, LocalizedIllegalArgumentException> byteStringToBoolean() {
        return BYTESTRING_TO_BOOLEAN;
    }

    public static Function<ByteString, DN, LocalizedIllegalArgumentException> byteStringToDN() {
        return Functions.byteStringToDN(Schema.getDefaultSchema());
    }

    public static Function<ByteString, DN, LocalizedIllegalArgumentException> byteStringToDN(Schema schema) {
        return Functions.compose(Functions.byteStringToString(), Functions.stringToDN(schema));
    }

    public static Function<ByteString, X509Certificate, LocalizedIllegalArgumentException> byteStringToCertificate() {
        return BYTESTRING_TO_CERT;
    }

    public static Function<ByteString, GeneralizedTime, LocalizedIllegalArgumentException> byteStringToGeneralizedTime() {
        return BYTESTRING_TO_GTIME;
    }

    public static Function<ByteString, Integer, LocalizedIllegalArgumentException> byteStringToInteger() {
        return BYTESTRING_TO_INTEGER;
    }

    public static Function<ByteString, Long, LocalizedIllegalArgumentException> byteStringToLong() {
        return BYTESTRING_TO_LONG;
    }

    public static Function<ByteString, String, NeverThrowsException> byteStringToString() {
        return BYTESTRING_TO_STRING;
    }

    private Functions() {
    }
}

