/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.util.Reject;

final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    static ByteString decode(String base64) {
        Reject.ifNull((Object)base64);
        int length = base64.length();
        if (length % 4 != 0) {
            LocalizableMessage message = CoreMessages.ERR_BASE64_DECODE_INVALID_LENGTH.get((Object)base64);
            throw new LocalizedIllegalArgumentException(message);
        }
        ByteStringBuilder builder = new ByteStringBuilder(length);
        for (int i = 0; i < length; i += 4) {
            boolean append = true;
            int value = 0;
            for (int j = 0; j < 4; ++j) {
                switch (base64.charAt(i + j)) {
                    case 'A': {
                        value <<= 6;
                        break;
                    }
                    case 'B': {
                        value = value << 6 | 1;
                        break;
                    }
                    case 'C': {
                        value = value << 6 | 2;
                        break;
                    }
                    case 'D': {
                        value = value << 6 | 3;
                        break;
                    }
                    case 'E': {
                        value = value << 6 | 4;
                        break;
                    }
                    case 'F': {
                        value = value << 6 | 5;
                        break;
                    }
                    case 'G': {
                        value = value << 6 | 6;
                        break;
                    }
                    case 'H': {
                        value = value << 6 | 7;
                        break;
                    }
                    case 'I': {
                        value = value << 6 | 8;
                        break;
                    }
                    case 'J': {
                        value = value << 6 | 9;
                        break;
                    }
                    case 'K': {
                        value = value << 6 | 0xA;
                        break;
                    }
                    case 'L': {
                        value = value << 6 | 0xB;
                        break;
                    }
                    case 'M': {
                        value = value << 6 | 0xC;
                        break;
                    }
                    case 'N': {
                        value = value << 6 | 0xD;
                        break;
                    }
                    case 'O': {
                        value = value << 6 | 0xE;
                        break;
                    }
                    case 'P': {
                        value = value << 6 | 0xF;
                        break;
                    }
                    case 'Q': {
                        value = value << 6 | 0x10;
                        break;
                    }
                    case 'R': {
                        value = value << 6 | 0x11;
                        break;
                    }
                    case 'S': {
                        value = value << 6 | 0x12;
                        break;
                    }
                    case 'T': {
                        value = value << 6 | 0x13;
                        break;
                    }
                    case 'U': {
                        value = value << 6 | 0x14;
                        break;
                    }
                    case 'V': {
                        value = value << 6 | 0x15;
                        break;
                    }
                    case 'W': {
                        value = value << 6 | 0x16;
                        break;
                    }
                    case 'X': {
                        value = value << 6 | 0x17;
                        break;
                    }
                    case 'Y': {
                        value = value << 6 | 0x18;
                        break;
                    }
                    case 'Z': {
                        value = value << 6 | 0x19;
                        break;
                    }
                    case 'a': {
                        value = value << 6 | 0x1A;
                        break;
                    }
                    case 'b': {
                        value = value << 6 | 0x1B;
                        break;
                    }
                    case 'c': {
                        value = value << 6 | 0x1C;
                        break;
                    }
                    case 'd': {
                        value = value << 6 | 0x1D;
                        break;
                    }
                    case 'e': {
                        value = value << 6 | 0x1E;
                        break;
                    }
                    case 'f': {
                        value = value << 6 | 0x1F;
                        break;
                    }
                    case 'g': {
                        value = value << 6 | 0x20;
                        break;
                    }
                    case 'h': {
                        value = value << 6 | 0x21;
                        break;
                    }
                    case 'i': {
                        value = value << 6 | 0x22;
                        break;
                    }
                    case 'j': {
                        value = value << 6 | 0x23;
                        break;
                    }
                    case 'k': {
                        value = value << 6 | 0x24;
                        break;
                    }
                    case 'l': {
                        value = value << 6 | 0x25;
                        break;
                    }
                    case 'm': {
                        value = value << 6 | 0x26;
                        break;
                    }
                    case 'n': {
                        value = value << 6 | 0x27;
                        break;
                    }
                    case 'o': {
                        value = value << 6 | 0x28;
                        break;
                    }
                    case 'p': {
                        value = value << 6 | 0x29;
                        break;
                    }
                    case 'q': {
                        value = value << 6 | 0x2A;
                        break;
                    }
                    case 'r': {
                        value = value << 6 | 0x2B;
                        break;
                    }
                    case 's': {
                        value = value << 6 | 0x2C;
                        break;
                    }
                    case 't': {
                        value = value << 6 | 0x2D;
                        break;
                    }
                    case 'u': {
                        value = value << 6 | 0x2E;
                        break;
                    }
                    case 'v': {
                        value = value << 6 | 0x2F;
                        break;
                    }
                    case 'w': {
                        value = value << 6 | 0x30;
                        break;
                    }
                    case 'x': {
                        value = value << 6 | 0x31;
                        break;
                    }
                    case 'y': {
                        value = value << 6 | 0x32;
                        break;
                    }
                    case 'z': {
                        value = value << 6 | 0x33;
                        break;
                    }
                    case '0': {
                        value = value << 6 | 0x34;
                        break;
                    }
                    case '1': {
                        value = value << 6 | 0x35;
                        break;
                    }
                    case '2': {
                        value = value << 6 | 0x36;
                        break;
                    }
                    case '3': {
                        value = value << 6 | 0x37;
                        break;
                    }
                    case '4': {
                        value = value << 6 | 0x38;
                        break;
                    }
                    case '5': {
                        value = value << 6 | 0x39;
                        break;
                    }
                    case '6': {
                        value = value << 6 | 0x3A;
                        break;
                    }
                    case '7': {
                        value = value << 6 | 0x3B;
                        break;
                    }
                    case '8': {
                        value = value << 6 | 0x3C;
                        break;
                    }
                    case '9': {
                        value = value << 6 | 0x3D;
                        break;
                    }
                    case '+': {
                        value = value << 6 | 0x3E;
                        break;
                    }
                    case '/': {
                        value = value << 6 | 0x3F;
                        break;
                    }
                    case '=': {
                        append = false;
                        switch (j) {
                            case 2: {
                                builder.appendByte(value >>> 4);
                                break;
                            }
                            case 3: {
                                builder.appendByte(value >>> 10);
                                builder.appendByte(value >>> 2);
                            }
                        }
                        break;
                    }
                    default: {
                        LocalizableMessage message = CoreMessages.ERR_BASE64_DECODE_INVALID_CHARACTER.get((Object)base64, (Object)Character.valueOf(base64.charAt(i + j)));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                }
                if (!append) break;
            }
            if (!append) break;
            builder.appendByte(value >>> 16);
            builder.appendByte(value >>> 8);
            builder.appendByte(value);
        }
        return builder.toByteString();
    }

    static String encode(ByteSequence bytes) {
        Reject.ifNull((Object)bytes);
        if (bytes.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(4 * bytes.length() / 3);
        int pos = 0;
        int iterations = bytes.length() / 3;
        for (int i = 0; i < iterations; ++i) {
            int value = (bytes.byteAt(pos++) & 0xFF) << 16 | (bytes.byteAt(pos++) & 0xFF) << 8 | bytes.byteAt(pos++) & 0xFF;
            buffer.append(BASE64_ALPHABET[value >>> 18 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 12 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value >>> 6 & 0x3F]);
            buffer.append(BASE64_ALPHABET[value & 0x3F]);
        }
        switch (bytes.length() % 3) {
            case 1: {
                buffer.append(BASE64_ALPHABET[bytes.byteAt(pos) >>> 2 & 0x3F]);
                buffer.append(BASE64_ALPHABET[bytes.byteAt(pos) << 4 & 0x3F]);
                buffer.append("==");
                break;
            }
            case 2: {
                int value = (bytes.byteAt(pos++) & 0xFF) << 8 | bytes.byteAt(pos) & 0xFF;
                buffer.append(BASE64_ALPHABET[value >>> 10 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value >>> 4 & 0x3F]);
                buffer.append(BASE64_ALPHABET[value << 2 & 0x3F]);
                buffer.append("=");
            }
        }
        return buffer.toString();
    }

    private Base64() {
    }
}

