/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import com.forgerock.opendj.ldap.extensions.GetConnectionIDExtendedResult;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.ASN1;
import org.forgerock.opendj.io.ASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;

public final class GetConnectionIDExtendedRequest
extends AbstractExtendedRequest<GetConnectionIDExtendedRequest, GetConnectionIDExtendedResult> {
    public static final String OID = "1.3.6.1.4.1.26027.1.6.2";
    private static final GetConnectionIDExtendedRequest INSTANCE = new GetConnectionIDExtendedRequest();
    public static final RequestDecoder REQUEST_DECODER = new RequestDecoder();
    private static final ResultDecoder RESULT_DECODER = new ResultDecoder();

    public static GetConnectionIDExtendedRequest newRequest() {
        return INSTANCE;
    }

    private GetConnectionIDExtendedRequest() {
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ExtendedResultDecoder<GetConnectionIDExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetConnectionIDExtendedRequest(requestName=");
        builder.append(this.getOID());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<GetConnectionIDExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public GetConnectionIDExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            if (!resultCode.isExceptional()) {
                throw new IllegalArgumentException("No response name and value for result code " + resultCode.intValue());
            }
            return (GetConnectionIDExtendedResult)((GetConnectionIDExtendedResult)GetConnectionIDExtendedResult.newResult(resultCode).setMatchedDN(matchedDN)).setDiagnosticMessage(diagnosticMessage);
        }

        @Override
        public GetConnectionIDExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            if (result instanceof GetConnectionIDExtendedResult) {
                return (GetConnectionIDExtendedResult)result;
            }
            ResultCode resultCode = result.getResultCode();
            GetConnectionIDExtendedResult newResult = (GetConnectionIDExtendedResult)((GetConnectionIDExtendedResult)GetConnectionIDExtendedResult.newResult(resultCode).setMatchedDN(result.getMatchedDN())).setDiagnosticMessage(result.getDiagnosticMessage());
            ByteString responseValue = result.getValue();
            if (!resultCode.isExceptional() && responseValue == null) {
                throw DecodeException.error(LocalizableMessage.raw((CharSequence)"Empty response value", (Object[])new Object[0]));
            }
            if (responseValue != null) {
                try {
                    ASN1Reader reader = ASN1.getReader(responseValue);
                    newResult.setConnectionID((int)reader.readInteger());
                }
                catch (IOException e) {
                    throw DecodeException.error(LocalizableMessage.raw((CharSequence)"Error decoding response value", (Object[])new Object[0]), e);
                }
            }
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }
    }

    private static final class RequestDecoder
    implements ExtendedRequestDecoder<GetConnectionIDExtendedRequest, GetConnectionIDExtendedResult> {
        private RequestDecoder() {
        }

        @Override
        public GetConnectionIDExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            GetConnectionIDExtendedRequest newRequest = new GetConnectionIDExtendedRequest();
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

