/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ArgumentConstants;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.SearchScope;

public final class CommonArguments {
    private CommonArguments() {
    }

    public static BooleanArgument showUsageArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("help").shortIdentifier(Character.valueOf('H'))).description(CliMessages.INFO_DESCRIPTION_SHOWUSAGE.get())).buildArgument();
    }

    public static BooleanArgument verboseArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("verbose").shortIdentifier(ArgumentConstants.OPTION_SHORT_VERBOSE)).description(CliMessages.INFO_DESCRIPTION_VERBOSE.get())).buildArgument();
    }

    public static IntegerArgument portArgument(int defaultPort, LocalizableMessage description) throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("port").shortIdentifier(Character.valueOf('p'))).description(description != null ? description : CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get())).range(1, 65535).defaultValue((Object)defaultPort)).valuePlaceholder(CliMessages.INFO_PORT_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument propertiesFileArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("propertiesFilePath").description(CliMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get())).valuePlaceholder(CliMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument proxyAuthIdArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("proxyAs").shortIdentifier(Character.valueOf('Y'))).description(CliMessages.INFO_DESCRIPTION_PROXYAUTHZID.get())).valuePlaceholder(CliMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument noPropertiesFileArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)BooleanArgument.builder("noPropertiesFile").description(CliMessages.INFO_DESCRIPTION_NO_PROP_FILE.get())).buildArgument();
    }

    public static BooleanArgument continueOnErrorArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("continueOnError").shortIdentifier(Character.valueOf('c'))).description(CliMessages.INFO_DESCRIPTION_CONTINUE_ON_ERROR.get())).buildArgument();
    }

    public static StringArgument controlArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("control").shortIdentifier(ArgumentConstants.OPTION_SHORT_CONTROL)).description(CliMessages.INFO_DESCRIPTION_CONTROLS.get())).docDescriptionSupplement(CliMessages.SUPPLEMENT_DESCRIPTION_CONTROLS.get())).multiValued()).valuePlaceholder(CliMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get())).buildArgument();
    }

    public static IntegerArgument ldapVersionArgument() throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("ldapVersion").shortIdentifier(Character.valueOf('V'))).description(CliMessages.INFO_DESCRIPTION_VERSION.get())).defaultValue((Object)3)).valuePlaceholder(CliMessages.INFO_PROTOCOL_VERSION_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument quietArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("quiet").shortIdentifier(ArgumentConstants.OPTION_SHORT_QUIET)).description(CliMessages.INFO_DESCRIPTION_QUIET.get())).buildArgument();
    }

    public static BooleanArgument noOpArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("dry-run").shortIdentifier(Character.valueOf('n'))).description(CliMessages.INFO_DESCRIPTION_NOOP.get())).buildArgument();
    }

    public static BooleanArgument noPromptArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("no-prompt").shortIdentifier(ArgumentConstants.OPTION_SHORT_NO_PROMPT)).description(CliMessages.INFO_DESCRIPTION_NO_PROMPT.get())).buildArgument();
    }

    public static BooleanArgument acceptLicenseArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)BooleanArgument.builder("acceptLicense").description(CliMessages.INFO_OPTION_ACCEPT_LICENSE.get())).buildArgument();
    }

    public static BooleanArgument trustAllArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("trustAll").shortIdentifier(Character.valueOf('X'))).description(CliMessages.INFO_DESCRIPTION_TRUSTALL.get())).buildArgument();
    }

    public static StringArgument trustStorePathArgument() throws ArgumentException {
        return CommonArguments.trustStorePathArgument(null);
    }

    public static StringArgument trustStorePathArgument(String defaultValue) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("trustStorePath").shortIdentifier(Character.valueOf('P'))).description(CliMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get())).defaultValue(defaultValue)).valuePlaceholder(CliMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument trustStorePasswordArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("trustStorePassword").shortIdentifier(Character.valueOf('T'))).description(CliMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get())).valuePlaceholder(CliMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument trustStorePasswordFileArgument() throws ArgumentException {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("trustStorePasswordFile").shortIdentifier(Character.valueOf('U'))).description(CliMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get())).valuePlaceholder(CliMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static IntegerArgument connectTimeOutHiddenArgument() throws ArgumentException {
        return CommonArguments.connectTimeOutArgument(true);
    }

    public static IntegerArgument connectTimeOutArgument() throws ArgumentException {
        return CommonArguments.connectTimeOutArgument(false);
    }

    private static IntegerArgument connectTimeOutArgument(boolean hidden) throws ArgumentException {
        IntegerArgument.Builder builder = (IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("connectTimeout").description(CliMessages.INFO_DESCRIPTION_CONNECTION_TIMEOUT.get())).lowerBound(0).defaultValue((Object)30000)).valuePlaceholder(CliMessages.INFO_TIMEOUT_PLACEHOLDER.get());
        if (hidden) {
            builder.hidden();
        }
        return builder.buildArgument();
    }

    public static BooleanArgument cliArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("cli").shortIdentifier(Character.valueOf('i'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_CLI.get())).buildArgument();
    }

    public static StringArgument configFileArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("configFile").shortIdentifier(Character.valueOf('f'))).description(CliMessages.INFO_DESCRIPTION_CONFIG_FILE.get())).hidden()).required()).valuePlaceholder(CliMessages.INFO_CONFIGFILE_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument configClassArgument(String configFileHandlerName) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("configClass").shortIdentifier(Character.valueOf('C'))).description(CliMessages.INFO_DESCRIPTION_CONFIG_CLASS.get())).hidden()).required()).defaultValue(configFileHandlerName)).valuePlaceholder(CliMessages.INFO_CONFIGCLASS_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument baseDNArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("baseDN").shortIdentifier(Character.valueOf('b'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_BASEDN.get())).multiValued()).valuePlaceholder(CliMessages.INFO_BASEDN_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument bindDNArgument(String defaultBindDN) throws ArgumentException {
        return CommonArguments.bindDNArgument(defaultBindDN, CliMessages.INFO_DESCRIPTION_BINDDN.get());
    }

    public static StringArgument bindDNArgument(String defaultBindDN, LocalizableMessage description) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("bindDN").shortIdentifier(Character.valueOf('D'))).description(description)).defaultValue(defaultBindDN)).valuePlaceholder(CliMessages.INFO_BINDDN_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument bindPasswordArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("bindPassword").shortIdentifier(Character.valueOf('w'))).description(CliMessages.INFO_DESCRIPTION_BINDPASSWORD.get())).valuePlaceholder(CliMessages.INFO_BINDPWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument bindPasswordFileArgument() throws ArgumentException {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("bindPasswordFile").shortIdentifier(Character.valueOf('j'))).description(CliMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get())).valuePlaceholder(CliMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument addBaseEntryArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("addBaseEntry").shortIdentifier(Character.valueOf('a'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_ADDBASE.get())).buildArgument();
    }

    public static StringArgument rejectedImportLdifArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("rejectFile").shortIdentifier(Character.valueOf('R'))).description(CliMessages.INFO_GENERAL_DESCRIPTION_REJECTED_FILE.get())).valuePlaceholder(CliMessages.INFO_REJECT_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument remoteArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("remote").shortIdentifier(Character.valueOf('r'))).description(CliMessages.INFO_DESCRIPTION_REMOTE.get())).buildArgument();
    }

    public static BooleanArgument reportAuthzIdArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("reportAuthzID").shortIdentifier(Character.valueOf('E'))).description(CliMessages.INFO_DESCRIPTION_REPORT_AUTHZID.get())).buildArgument();
    }

    public static BooleanArgument restartArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("restart").shortIdentifier(Character.valueOf('R'))).description(CliMessages.INFO_DESCRIPTION_RESTART.get())).buildArgument();
    }

    public static StringArgument skippedImportFileArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("skipFile").description(CliMessages.INFO_GENERAL_DESCRIPTION_SKIPPED_FILE.get())).valuePlaceholder(CliMessages.INFO_SKIP_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static IntegerArgument sampleDataArgument() throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("sampleData").shortIdentifier(Character.valueOf('d'))).description(CliMessages.INFO_SETUP_DESCRIPTION_SAMPLE_DATA.get())).lowerBound(0).defaultValue((Object)0)).valuePlaceholder(CliMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument saslArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("saslOption").shortIdentifier(Character.valueOf('o'))).description(CliMessages.INFO_LDAP_CONN_DESCRIPTION_SASLOPTIONS.get())).multiValued()).valuePlaceholder(CliMessages.INFO_SASL_OPTION_PLACEHOLDER.get())).buildArgument();
    }

    public static MultiChoiceArgument<SearchScope> searchScopeArgument() throws ArgumentException {
        return ((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder("searchScope").shortIdentifier(Character.valueOf('s'))).description(CliMessages.INFO_SEARCH_DESCRIPTION_SEARCH_SCOPE.get())).allowedValues(SearchScope.values()).defaultValue(SearchScope.WHOLE_SUBTREE)).valuePlaceholder(CliMessages.INFO_SEARCH_SCOPE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument scriptFriendlyArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("script-friendly").shortIdentifier(ArgumentConstants.OPTION_SHORT_SCRIPT_FRIENDLY)).description(CliMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get())).buildArgument();
    }

    public static IntegerArgument ldapPortArgument(int defaultLdapPort) throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("ldapPort").shortIdentifier(Character.valueOf('p'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_LDAPPORT.get())).range(1, 65535).defaultValue((Object)defaultLdapPort)).valuePlaceholder(CliMessages.INFO_PORT_PLACEHOLDER.get())).buildArgument();
    }

    public static IntegerArgument adminLdapPortArgument(int defaultAdminPort) throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("adminConnectorPort").description(CliMessages.INFO_ARGUMENT_DESCRIPTION_ADMINCONNECTORPORT.get())).range(1, 65535).defaultValue((Object)defaultAdminPort)).valuePlaceholder(CliMessages.INFO_PORT_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument advancedModeArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)BooleanArgument.builder("advanced").description(CliMessages.INFO_DESCRIPTION_ADVANCED.get())).buildArgument();
    }

    public static IntegerArgument jmxPortArgument(int defaultJMXPort) throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("jmxPort").shortIdentifier(Character.valueOf('x'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_SKIPPORT.get())).range(1, 65535).defaultValue((Object)defaultJMXPort)).valuePlaceholder(CliMessages.INFO_JMXPORT_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument skipPortCheckArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("skipPortCheck").shortIdentifier(Character.valueOf('S'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_SKIPPORT.get())).buildArgument();
    }

    public static BooleanArgument startTLSArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("useStartTLS").shortIdentifier(Character.valueOf('q'))).description(CliMessages.INFO_DESCRIPTION_START_TLS.get())).buildArgument();
    }

    public static StringArgument rootDNArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("rootUserDN").shortIdentifier(Character.valueOf('D'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_ROOTDN.get())).defaultValue("cn=Directory Manager")).valuePlaceholder(CliMessages.INFO_ROOT_USER_DN_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument rootDNPwdArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("rootUserPassword").shortIdentifier(Character.valueOf('w'))).description(CliMessages.INFO_ROOT_USER_PWD_PLACEHOLDER.get())).valuePlaceholder(CliMessages.INFO_ROOT_USER_PWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument rootDNPwdFileArgument() throws ArgumentException {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("rootUserPasswordFile").shortIdentifier(Character.valueOf('j'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_ROOTPWFILE.get())).valuePlaceholder(CliMessages.INFO_ROOT_USER_PWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument enableWindowsServiceArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("enableWindowsService").shortIdentifier(Character.valueOf('e'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_ENABLE_WINDOWS_SERVICE.get())).buildArgument();
    }

    public static StringArgument encodingArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("encoding").shortIdentifier(Character.valueOf('i'))).description(CliMessages.INFO_DESCRIPTION_ENCODING.get())).valuePlaceholder(CliMessages.INFO_ENCODING_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument doNotStartArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("doNotStart").shortIdentifier(Character.valueOf('O'))).description(CliMessages.INFO_SETUP_DESCRIPTION_DO_NOT_START.get())).buildArgument();
    }

    public static BooleanArgument displayEquivalentCommandArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)BooleanArgument.builder("displayCommand").description(CliMessages.INFO_DESCRIPTION_DISPLAY_EQUIVALENT.get())).buildArgument();
    }

    public static StringArgument equivalentCommandFileArgument(LocalizableMessage description) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("commandFilePath").description(description)).valuePlaceholder(CliMessages.INFO_PATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument filenameArgument(LocalizableMessage description) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("filename").shortIdentifier(Character.valueOf('f'))).description(description)).valuePlaceholder(CliMessages.INFO_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument enableTLSArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("enableStartTLS").shortIdentifier(Character.valueOf('q'))).description(CliMessages.INFO_SETUP_DESCRIPTION_ENABLE_STARTTLS.get())).buildArgument();
    }

    public static IntegerArgument ldapsPortArgument(int defaultSecurePort) throws ArgumentException {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("ldapsPort").shortIdentifier(Character.valueOf('Z'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_LDAPSPORT.get())).range(1, 65535).defaultValue((Object)defaultSecurePort)).valuePlaceholder(CliMessages.INFO_PORT_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument ldifFileArgument(LocalizableMessage description) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("ldifFile").shortIdentifier(Character.valueOf('l'))).description(description)).multiValued()).valuePlaceholder(CliMessages.INFO_LDIFFILE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument generateSelfSignedArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)BooleanArgument.builder("generateSelfSignedCertificate").description(CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_SELF_SIGNED_CERTIFICATE.get())).buildArgument();
    }

    public static StringArgument hostNameArgument(String defaultHostName) throws ArgumentException {
        return CommonArguments.hostNameArgument(defaultHostName, null);
    }

    public static StringArgument hostNameArgument(String defaultHostName, LocalizableMessage description) throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("hostname").shortIdentifier(Character.valueOf('h'))).description(description != null ? description : CliMessages.INFO_ARGUMENT_DESCRIPTION_HOST_NAME.get())).defaultValue(defaultHostName)).valuePlaceholder(CliMessages.INFO_HOST_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument usePKCS11KeystoreArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)BooleanArgument.builder("usePkcs11Keystore").description(CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_PKCS11.get())).buildArgument();
    }

    public static StringArgument useJavaKeyStoreArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("useJavaKeystore").description(CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_JAVAKEYSTORE.get())).valuePlaceholder(CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument useJCEKSArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("useJCEKS").description(CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_JCEKS.get())).valuePlaceholder(CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument usePKCS12KeyStoreArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("usePkcs12keyStore").description(CliMessages.INFO_ARGUMENT_DESCRIPTION_USE_PKCS12.get())).valuePlaceholder(CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument useSSLArgument() throws ArgumentException {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("useSSL").shortIdentifier(Character.valueOf('Z'))).description(CliMessages.INFO_DESCRIPTION_USE_SSL.get())).buildArgument();
    }

    public static StringArgument keyStorePasswordArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("keyStorePassword").shortIdentifier(Character.valueOf('W'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_KEYSTOREPASSWORD.get())).valuePlaceholder(CliMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument keyStorePasswordFileArgument() throws ArgumentException {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("keyStorePasswordFile").shortIdentifier(Character.valueOf('u'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_KEYSTOREPASSWORD_FILE.get())).valuePlaceholder(CliMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument keyStorePathArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("keyStorePath").shortIdentifier(Character.valueOf('K'))).description(CliMessages.INFO_DESCRIPTION_KEYSTOREPATH.get())).valuePlaceholder(CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument certNickNameArgument() throws ArgumentException {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("certNickname").shortIdentifier(Character.valueOf('N'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_CERT_NICKNAME.get())).multiValued()).valuePlaceholder(CliMessages.INFO_NICKNAME_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument adminUid(LocalizableMessage description) throws ArgumentException {
        return CommonArguments.adminUidArgument(false, description);
    }

    public static StringArgument adminUidHiddenArgument(LocalizableMessage description) throws ArgumentException {
        return CommonArguments.adminUidArgument(true, description);
    }

    private static StringArgument adminUidArgument(boolean hidden, LocalizableMessage description) throws ArgumentException {
        StringArgument.Builder builder = (StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("adminUID").shortIdentifier(Character.valueOf('I'))).description(description)).defaultValue("admin")).valuePlaceholder(CliMessages.INFO_ADMINUID_PLACEHOLDER.get());
        if (hidden) {
            builder.hidden();
        }
        return builder.buildArgument();
    }
}

