/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.grizzly;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.DescribedHttpApplication;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.filter.TransactionIdInboundFilter;
import org.forgerock.http.grizzly.SessionAdapter;
import org.forgerock.http.handler.DescribableHandler;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.session.Session;
import org.forgerock.http.session.SessionContext;
import org.forgerock.http.util.CaseInsensitiveSet;
import org.forgerock.http.util.Uris;
import org.forgerock.services.context.AttributesContext;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.RequestAuditContext;
import org.forgerock.services.context.RootContext;
import org.forgerock.util.Factory;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HandlerAdapter
extends HttpHandler {
    private static final CaseInsensitiveSet NON_ENTITY_METHODS = new CaseInsensitiveSet(Arrays.asList("GET", "HEAD", "TRACE"));
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerAdapter.class);
    private final HttpApplication httpApplication;
    private final Factory<Buffer> storage;
    private DescribableHandler describedHandler;

    HandlerAdapter(HttpApplication httpApplication) {
        this.httpApplication = httpApplication;
        Factory applicationStorage = httpApplication.getBufferFactory();
        this.storage = applicationStorage != null ? applicationStorage : IO.newTemporaryStorage((File)new File(System.getProperty("java.io.tmpdir")));
    }

    public void start() {
        super.start();
        try {
            this.describedHandler = Handlers.chainOf((Handler)this.httpApplication.start(), (Filter[])new Filter[]{new TransactionIdInboundFilter()});
            if (this.httpApplication instanceof DescribedHttpApplication) {
                ApiProducer apiProducer = ((DescribedHttpApplication)this.httpApplication).getApiProducer();
                this.describedHandler.api(apiProducer);
            }
        }
        catch (HttpApplicationException e) {
            LOGGER.error("Error while starting the application.", (Throwable)e);
            this.describedHandler = Handlers.asDescribableHandler((Handler)Handlers.internalServerErrorHandler((Exception)((Object)e)));
        }
    }

    public void destroy() {
        this.httpApplication.stop();
        this.describedHandler = null;
        super.destroy();
    }

    public void service(org.glassfish.grizzly.http.server.Request request, final org.glassfish.grizzly.http.server.Response response) throws Exception {
        Request chfRequest = this.toChfRequest(request);
        RootContext rootContext = new RootContext();
        final SessionContext sessionContext = new SessionContext((Context)rootContext, (Session)new SessionAdapter(request.getSession()));
        UriRouterContext uriRouterContext = this.createRouterContext((Context)sessionContext, request, chfRequest);
        AttributesContext attributesContext = new AttributesContext((Context)new RequestAuditContext((Context)uriRouterContext));
        ClientContext context = this.createClientContext((Context)attributesContext, request);
        response.suspend();
        this.describedHandler.handle((Context)context, chfRequest).thenOnResult((ResultHandler)new ResultHandler<Response>(){

            public void handleResult(Response chfResponse) {
                HandlerAdapter.this.writeResponse(chfResponse, response, sessionContext);
            }
        }).thenOnRuntimeException(new RuntimeExceptionHandler(){

            public void handleRuntimeException(RuntimeException e) {
                LOGGER.error("RuntimeException caught", (Throwable)e);
                HandlerAdapter.this.writeResponse(Responses.newInternalServerError((Exception)e), response, sessionContext);
            }
        }).thenAlways(new Runnable(){

            @Override
            public void run() {
                response.resume();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(Response chfResponse, org.glassfish.grizzly.http.server.Response grizzlyResponse, SessionContext sessionContext) {
        try {
            grizzlyResponse.setStatus(chfResponse.getStatus().getCode());
            sessionContext.getSession().save(chfResponse);
            for (String name : chfResponse.getHeaders().keySet()) {
                for (String value : chfResponse.getHeaders().get((Object)name).getValues()) {
                    if (value == null || value.isEmpty()) continue;
                    grizzlyResponse.addHeader(name, value);
                }
            }
            IO.stream((InputStream)chfResponse.getEntity().getRawContentInputStream(), (OutputStream)grizzlyResponse.getOutputStream());
        }
        catch (IOException e) {
            try {
                LOGGER.trace("Failed to write response", (Throwable)e);
            }
            catch (Throwable throwable) {
                Utils.closeSilently((Closeable[])new Closeable[]{chfResponse});
                throw throwable;
            }
            Utils.closeSilently((Closeable[])new Closeable[]{chfResponse});
        }
        Utils.closeSilently((Closeable[])new Closeable[]{chfResponse});
    }

    private Request toChfRequest(org.glassfish.grizzly.http.server.Request req) throws URISyntaxException {
        Request request = new Request();
        request.setMethod(req.getMethod().toString());
        request.setUri(Uris.createNonStrict((String)req.getScheme(), null, (String)req.getServerName(), (int)req.getServerPort(), (String)req.getRequestURI(), (String)req.getQueryString(), null));
        for (String e : req.getHeaderNames()) {
            ArrayList<String> values = new ArrayList<String>(1);
            for (String value : req.getHeaders(e)) {
                values.add(value);
            }
            request.getHeaders().add(e, values);
        }
        if (!(req.getContentLength() <= 0 && req.getHeader("Transfer-Encoding") == null || NON_ENTITY_METHODS.contains((Object)request.getMethod()))) {
            request.setEntity((Object)IO.newBranchingInputStream((InputStream)req.getInputStream(), this.storage));
        }
        return request;
    }

    private UriRouterContext createRouterContext(Context parent, org.glassfish.grizzly.http.server.Request req, Request request) {
        return new UriRouterContext(parent, "", req.getRequestURI(), Collections.emptyMap(), request.getUri().asURI());
    }

    private ClientContext createClientContext(Context parent, org.glassfish.grizzly.http.server.Request req) {
        return ClientContext.buildExternalClientContext((Context)parent).remoteUser(req.getRemoteUser()).remoteAddress(req.getRemoteAddr()).remotePort(req.getRemotePort()).secure("https".equalsIgnoreCase(req.getScheme())).certificates((Certificate[])((X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate"))).userAgent(req.getHeader("User-Agent")).localAddress(req.getLocalAddr()).localPort(req.getLocalPort()).build();
    }
}

