/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.schema;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.SyntaxImpl;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.schema.JsonQueryEqualityMatchingRuleImpl;
import org.forgerock.opendj.rest2ldap.schema.JsonQuerySyntaxImpl;
import org.forgerock.opendj.rest2ldap.schema.JsonSyntaxImpl;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;

public final class JsonSchema {
    public static final Option<ValidationPolicy> VALIDATION_POLICY = Option.withDefault((Object)((Object)ValidationPolicy.STRICT));
    public static final Option<Boolean> CASE_SENSITIVE_STRINGS = Option.withDefault((Object)false);
    public static final Option<Boolean> IGNORE_WHITE_SPACE = Option.withDefault((Object)true);
    public static final Option<Collection<String>> INDEXED_FIELD_PATTERNS = Option.of(Collection.class, Collections.emptyList());
    static final String SYNTAX_JSON_OID = "1.3.6.1.4.1.36733.2.1.3.1";
    static final String SYNTAX_JSON_DESCRIPTION = "Json";
    static final String SYNTAX_JSON_QUERY_OID = "1.3.6.1.4.1.36733.2.1.3.2";
    static final String SYNTAX_JSON_QUERY_DESCRIPTION = "Json Query";
    static final String EMR_CASE_IGNORE_JSON_QUERY_OID = "1.3.6.1.4.1.36733.2.1.4.1";
    static final String EMR_CASE_IGNORE_JSON_QUERY_NAME = "caseIgnoreJsonQueryMatch";
    static final String EMR_CASE_EXACT_JSON_QUERY_OID = "1.3.6.1.4.1.36733.2.1.4.2";
    static final String EMR_CASE_EXACT_JSON_QUERY_NAME = "caseExactJsonQueryMatch";
    private static final Syntax JSON_SYNTAX;
    private static final Syntax JSON_QUERY_SYNTAX;
    private static final MatchingRule CASE_IGNORE_JSON_QUERY_MATCHING_RULE;
    private static final MatchingRule CASE_EXACT_JSON_QUERY_MATCHING_RULE;
    private static final Function<ByteString, Object, LocalizedIllegalArgumentException> BYTESTRING_TO_JSON;
    private static final Function<Object, ByteString, JsonProcessingException> JSON_TO_BYTESTRING;

    static LocalizableMessage jsonParsingException(IOException e) {
        JsonProcessingException jpe;
        if (e instanceof JsonProcessingException && (jpe = (JsonProcessingException)e).getLocation() != null) {
            return Rest2ldapMessages.ERR_JSON_PARSE_ERROR.get((Object)jpe.getLocation().getLineNr(), (Object)jpe.getLocation().getColumnNr(), (Object)jpe.getOriginalMessage());
        }
        return Rest2ldapMessages.ERR_JSON_IO_ERROR.get((Object)e.getMessage());
    }

    public static Syntax getJsonSyntax() {
        return JSON_SYNTAX;
    }

    public static Syntax getJsonQuerySyntax() {
        return JSON_QUERY_SYNTAX;
    }

    public static MatchingRule getCaseIgnoreJsonQueryMatchingRule() {
        return CASE_IGNORE_JSON_QUERY_MATCHING_RULE;
    }

    public static MatchingRule getCaseExactJsonQueryMatchingRule() {
        return CASE_EXACT_JSON_QUERY_MATCHING_RULE;
    }

    public static MatchingRuleImpl newJsonQueryEqualityMatchingRuleImpl(String matchingRuleName, Options options) {
        return new JsonQueryEqualityMatchingRuleImpl(matchingRuleName, options);
    }

    public static SchemaBuilder addJsonSyntaxesAndMatchingRulesToSchema(SchemaBuilder builder) {
        builder.buildSyntax(SYNTAX_JSON_OID).description(SYNTAX_JSON_DESCRIPTION).implementation((SyntaxImpl)new JsonSyntaxImpl()).extraProperties("X-ORIGIN", new String[]{"OpenDJ Directory Server"}).addToSchema();
        builder.buildSyntax(SYNTAX_JSON_QUERY_OID).description(SYNTAX_JSON_QUERY_DESCRIPTION).implementation((SyntaxImpl)new JsonQuerySyntaxImpl()).extraProperties("X-ORIGIN", new String[]{"OpenDJ Directory Server"}).addToSchema();
        JsonQueryEqualityMatchingRuleImpl caseIgnoreImpl = new JsonQueryEqualityMatchingRuleImpl(EMR_CASE_IGNORE_JSON_QUERY_NAME, Options.defaultOptions().set(CASE_SENSITIVE_STRINGS, (Object)false).set(IGNORE_WHITE_SPACE, (Object)true));
        builder.buildMatchingRule(EMR_CASE_IGNORE_JSON_QUERY_OID).names(new String[]{EMR_CASE_IGNORE_JSON_QUERY_NAME}).syntaxOID(SYNTAX_JSON_QUERY_OID).extraProperties("X-ORIGIN", new String[]{"OpenDJ Directory Server"}).implementation((MatchingRuleImpl)caseIgnoreImpl).addToSchema();
        JsonQueryEqualityMatchingRuleImpl caseExactImpl = new JsonQueryEqualityMatchingRuleImpl(EMR_CASE_EXACT_JSON_QUERY_NAME, Options.defaultOptions().set(CASE_SENSITIVE_STRINGS, (Object)true).set(IGNORE_WHITE_SPACE, (Object)true));
        builder.buildMatchingRule(EMR_CASE_EXACT_JSON_QUERY_OID).names(new String[]{EMR_CASE_EXACT_JSON_QUERY_NAME}).syntaxOID(SYNTAX_JSON_QUERY_OID).extraProperties("X-ORIGIN", new String[]{"OpenDJ Directory Server"}).implementation((MatchingRuleImpl)caseExactImpl).addToSchema();
        return builder;
    }

    public static Function<ByteString, Object, LocalizedIllegalArgumentException> byteStringToJson() {
        return BYTESTRING_TO_JSON;
    }

    public static Function<Object, ByteString, JsonProcessingException> jsonToByteString() {
        return JSON_TO_BYTESTRING;
    }

    private JsonSchema() {
    }

    static {
        BYTESTRING_TO_JSON = new Function<ByteString, Object, LocalizedIllegalArgumentException>(){

            public Object apply(ByteString value) {
                Object object;
                block8: {
                    InputStream inputStream = value.asReader().asInputStream();
                    try {
                        object = ValidationPolicy.LENIENT.getObjectMapper().readValue(inputStream, Object.class);
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new LocalizedIllegalArgumentException(JsonSchema.jsonParsingException(e));
                        }
                    }
                    inputStream.close();
                }
                return object;
            }
        };
        JSON_TO_BYTESTRING = new Function<Object, ByteString, JsonProcessingException>(){

            public ByteString apply(Object value) throws JsonProcessingException {
                return ByteString.wrap((byte[])ValidationPolicy.LENIENT.getObjectMapper().writeValueAsBytes(value));
            }
        };
        Schema schema = JsonSchema.addJsonSyntaxesAndMatchingRulesToSchema(new SchemaBuilder(Schema.getCoreSchema())).toSchema();
        JSON_SYNTAX = schema.getSyntax(SYNTAX_JSON_OID);
        JSON_QUERY_SYNTAX = schema.getSyntax(SYNTAX_JSON_QUERY_OID);
        CASE_IGNORE_JSON_QUERY_MATCHING_RULE = schema.getMatchingRule(EMR_CASE_IGNORE_JSON_QUERY_OID);
        CASE_EXACT_JSON_QUERY_MATCHING_RULE = schema.getMatchingRule(EMR_CASE_EXACT_JSON_QUERY_OID);
    }

    public static enum ValidationPolicy {
        STRICT(new ObjectMapper()),
        LENIENT(new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES}).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS})),
        DISABLED(null);

        private final ObjectMapper objectMapper;

        private ValidationPolicy(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        final JsonFactory getJsonFactory() {
            return this.objectMapper.getFactory();
        }

        final ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }
    }
}

