/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.forgerock.opendj.util.StringPrepProfile;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.QueryFilters;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;
import org.forgerock.opendj.ldap.spi.IndexingOptions;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.schema.JsonSchema;
import org.forgerock.util.Options;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

final class JsonQueryEqualityMatchingRuleImpl
implements MatchingRuleImpl {
    private static final int KEY_FIELD_START = 0;
    private static final int KEY_FIELD_END = 1;
    private static final int KEY_TYPE_NULL = 0;
    private static final int KEY_TYPE_FALSE = 1;
    private static final int KEY_TYPE_TRUE = 2;
    private static final int KEY_TYPE_NUMBER = 3;
    private static final int KEY_TYPE_STRING = 4;
    private final String indexID;
    private final boolean ignoreWhiteSpaceInStrings;
    private final boolean caseSensitiveStrings;
    private final List<Pattern> indexedFieldPatterns;
    private final QueryFilterVisitor<ConditionResult, JsonValue, JsonPointer> matcher = new Matcher();
    private final List<? extends Indexer> indexers = Collections.singletonList(new IndexerImpl());

    JsonQueryEqualityMatchingRuleImpl(String indexID, Options options) {
        this.indexID = indexID;
        this.ignoreWhiteSpaceInStrings = (Boolean)options.get(JsonSchema.IGNORE_WHITE_SPACE);
        this.caseSensitiveStrings = (Boolean)options.get(JsonSchema.CASE_SENSITIVE_STRINGS);
        this.indexedFieldPatterns = JsonQueryEqualityMatchingRuleImpl.compileWildCardPatterns((Collection)options.get(JsonSchema.INDEXED_FIELD_PATTERNS));
    }

    private static List<Pattern> compileWildCardPatterns(Collection<String> wildCardPatterns) {
        ArrayList<Pattern> regexes = new ArrayList<Pattern>();
        for (String wildCardPattern : wildCardPatterns) {
            regexes.add(JsonQueryEqualityMatchingRuleImpl.compileWildCardPattern(wildCardPattern));
        }
        return regexes;
    }

    static Pattern compileWildCardPattern(String wildCardPattern) {
        boolean slashStarStar = false;
        boolean starStar = true;
        int star = 2;
        String normalizedPattern = new JsonPointer(wildCardPattern).toString().replaceAll("/\\*\\*", "\u0000").replaceAll("\\*\\*", "\u0001").replaceAll("\\*", "\u0002");
        StringBuilder builder = new StringBuilder();
        int elementStart = 0;
        for (int i = 0; i < normalizedPattern.length(); ++i) {
            char c = normalizedPattern.charAt(i);
            if (c > '\u0002') continue;
            if (elementStart < i) {
                builder.append(Pattern.quote(normalizedPattern.substring(elementStart, i)));
            }
            switch (c) {
                case '\u0000': {
                    builder.append("(/.*)?");
                    break;
                }
                case '\u0001': {
                    builder.append(".*");
                    break;
                }
                case '\u0002': {
                    builder.append("[^/]*");
                }
            }
            elementStart = i + 1;
        }
        if (elementStart < normalizedPattern.length()) {
            builder.append(Pattern.quote(normalizedPattern.substring(elementStart)));
        }
        return Pattern.compile(builder.toString());
    }

    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        QueryFilter queryFilter;
        try {
            queryFilter = QueryFilters.parse((String)assertionValue.toString());
        }
        catch (Exception e) {
            throw DecodeException.error((LocalizableMessage)Rest2ldapMessages.ERR_JSON_QUERY_PARSE_ERROR.get((Object)assertionValue));
        }
        return new Assertion(){

            public ConditionResult matches(ByteSequence normalizedAttributeValue) {
                ConditionResult conditionResult;
                block8: {
                    InputStream inputStream = normalizedAttributeValue.asReader().asInputStream();
                    try {
                        Object object = JsonSchema.ValidationPolicy.LENIENT.getObjectMapper().readValue(inputStream, Object.class);
                        JsonValue jsonValue = new JsonValue(object);
                        conditionResult = (ConditionResult)queryFilter.accept(JsonQueryEqualityMatchingRuleImpl.this.matcher, (Object)jsonValue);
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            return ConditionResult.FALSE;
                        }
                    }
                    inputStream.close();
                }
                return conditionResult;
            }

            public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
                return (T)queryFilter.accept(new IndexQueryBuilder(), factory);
            }
        };
    }

    public Assertion getSubstringAssertion(Schema schema, ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    public Assertion getGreaterOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    public Assertion getLessOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        try (InputStream inputStream = value.asReader().asInputStream();){
            ByteString byteString;
            block17: {
                JsonParser parser = JsonSchema.ValidationPolicy.LENIENT.getJsonFactory().createParser(inputStream);
                try {
                    JsonToken jsonToken = parser.nextToken();
                    if (jsonToken == null) {
                        throw DecodeException.error((LocalizableMessage)Rest2ldapMessages.ERR_JSON_EMPTY_CONTENT.get());
                    }
                    ByteStringBuilder normalizedValue = new ByteStringBuilder(value.length());
                    this.normalizeJsonValue(parser, jsonToken, normalizedValue);
                    if (parser.nextToken() != null) {
                        throw DecodeException.error((LocalizableMessage)Rest2ldapMessages.ERR_JSON_TRAILING_CONTENT.get());
                    }
                    byteString = normalizedValue.toByteString();
                    if (parser == null) break block17;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return byteString;
        }
        catch (DecodeException e) {
            throw e;
        }
        catch (IOException e) {
            throw DecodeException.error((LocalizableMessage)JsonSchema.jsonParsingException(e));
        }
    }

    private void normalizeJsonValue(JsonParser parser, JsonToken jsonToken, ByteStringBuilder builder) throws IOException {
        switch (jsonToken) {
            case START_OBJECT: {
                TreeMap<String, Object> normalizedObject = new TreeMap<String, Object>();
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    String key = parser.getCurrentName();
                    ByteStringBuilder value = new ByteStringBuilder();
                    this.normalizeJsonValue(parser, parser.nextToken(), value);
                    normalizedObject.put(key, value);
                }
                builder.appendByte(123);
                boolean isFirstField = true;
                for (Map.Entry entry : normalizedObject.entrySet()) {
                    if (!isFirstField) {
                        builder.appendByte(44);
                    }
                    builder.appendByte(34);
                    builder.appendUtf8((String)entry.getKey());
                    builder.appendByte(34);
                    builder.appendByte(58);
                    builder.appendBytes((ByteSequence)entry.getValue());
                    isFirstField = false;
                }
                builder.appendByte(125);
                break;
            }
            case START_ARRAY: {
                builder.appendByte(91);
                boolean isFirstElement = true;
                while ((jsonToken = parser.nextToken()) != JsonToken.END_ARRAY) {
                    if (!isFirstElement) {
                        builder.appendByte(44);
                    }
                    this.normalizeJsonValue(parser, jsonToken, builder);
                    isFirstElement = false;
                }
                builder.appendByte(93);
                break;
            }
            case VALUE_STRING: {
                builder.appendByte(34);
                builder.appendUtf8(this.normalizeString(parser.getText()));
                builder.appendByte(34);
                break;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                builder.appendUtf8(parser.getNumberValue().toString());
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: {
                builder.appendUtf8(parser.getText());
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: 
            case NOT_AVAILABLE: 
            case VALUE_EMBEDDED_OBJECT: {
                throw new IllegalStateException();
            }
        }
    }

    private String normalizeString(String string) {
        StringBuilder builder = new StringBuilder(string.length());
        StringPrepProfile.prepareUnicode((StringBuilder)builder, (ByteSequence)ByteString.valueOfUtf8((CharSequence)string), (boolean)this.ignoreWhiteSpaceInStrings, (!this.caseSensitiveStrings ? 1 : 0) != 0);
        if (builder.length() == 0 && string.length() > 0) {
            return " ";
        }
        return builder.toString();
    }

    public Collection<? extends Indexer> createIndexers(IndexingOptions options) {
        return this.indexers;
    }

    private boolean isFieldIndexed(String normalizedJsonPointer) {
        if (this.indexedFieldPatterns.isEmpty()) {
            return true;
        }
        for (Pattern indexedFieldPattern : this.indexedFieldPatterns) {
            if (!indexedFieldPattern.matcher(normalizedJsonPointer).matches()) continue;
            return true;
        }
        return false;
    }

    private ByteString createFieldStartIndexKey(String normalizedJsonPointer) {
        ByteStringBuilder builder = new ByteStringBuilder(normalizedJsonPointer.length() + 1);
        this.createFieldStartIndexKey(normalizedJsonPointer, builder);
        return builder.toByteString();
    }

    private void createFieldStartIndexKey(String normalizedJsonPointer, ByteStringBuilder builder) {
        builder.appendUtf8(normalizedJsonPointer);
        builder.appendByte(0);
    }

    private ByteString createFieldEndIndexKey(String normalizedJsonPointer) {
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.appendUtf8(normalizedJsonPointer);
        builder.appendByte(1);
        return builder.toByteString();
    }

    ByteString createIndexKey(String normalizedJsonPointer, Object value) {
        ByteString fieldKey = this.createFieldStartIndexKey(normalizedJsonPointer);
        return this.createIndexKey(fieldKey, value).toByteString();
    }

    private ByteSequence createIndexKey(ByteString fieldKey, Object value) {
        ByteStringBuilder builder = new ByteStringBuilder((ByteSequence)fieldKey);
        if (value == null) {
            return this.createNullIndexKey(builder);
        }
        if (value instanceof Number) {
            Double doubleValue = ((Number)value).doubleValue();
            return this.createNumberIndexKey(builder, BigDecimal.valueOf(doubleValue));
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return this.createBooleanIndexKey(builder, booleanValue);
        }
        String stringValue = this.normalizeString(value.toString());
        return this.createStringIndexKey(builder, stringValue);
    }

    private ByteString createStringIndexKey(ByteStringBuilder builder, String string) {
        builder.appendByte(4);
        builder.appendUtf8(this.normalizeString(string));
        return builder.toByteString();
    }

    private ByteString createNumberIndexKey(ByteStringBuilder builder, BigDecimal number) {
        builder.appendByte(3);
        ByteString micros = ByteString.valueOfObject((Object)number.movePointRight(6).toBigInteger());
        try {
            builder.appendBytes((ByteSequence)CoreSchema.getIntegerMatchingRule().normalizeAttributeValue((ByteSequence)micros));
        }
        catch (DecodeException e) {
            throw new RuntimeException(e);
        }
        return builder.toByteString();
    }

    private ByteString createBooleanIndexKey(ByteStringBuilder builder, boolean b) {
        builder.appendByte(b ? 2 : 1);
        return builder.toByteString();
    }

    private ByteString createNullIndexKey(ByteStringBuilder builder) {
        builder.appendByte(0);
        return builder.toByteString();
    }

    private String normalizeJsonPointer(JsonPointer jsonPointer) {
        for (int i = 0; i < jsonPointer.size(); ++i) {
            String token = jsonPointer.get(i);
            if (!this.isArrayIndex(token)) continue;
            ArrayList<String> tokens = new ArrayList<String>(jsonPointer.size());
            for (int j = 0; j < jsonPointer.size(); ++j) {
                String tokenj = jsonPointer.get(j);
                if (j == i || j > i && this.isArrayIndex(tokenj)) continue;
                tokens.add(tokenj);
            }
            return new JsonPointer(tokens.toArray(new String[0])).toString();
        }
        return jsonPointer.toString();
    }

    private boolean isArrayIndex(String token) {
        int length = token.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = token.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static enum FilterType {
        EQUALS,
        CONTAINS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL_TO,
        LESS_THAN,
        LESS_THAN_OR_EQUAL_TO,
        STARTS_WITH;

    }

    private final class Matcher
    implements QueryFilterVisitor<ConditionResult, JsonValue, JsonPointer> {
        private Matcher() {
        }

        public ConditionResult visitAndFilter(JsonValue jsonValue, List<QueryFilter<JsonPointer>> subFilters) {
            ConditionResult r = ConditionResult.TRUE;
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                ConditionResult p = (ConditionResult)subFilter.accept((QueryFilterVisitor)this, (Object)jsonValue);
                if (p == ConditionResult.FALSE) {
                    return p;
                }
                r = ConditionResult.and((ConditionResult)r, (ConditionResult)p);
            }
            return r;
        }

        public ConditionResult visitBooleanLiteralFilter(JsonValue jsonValue, boolean value) {
            return ConditionResult.valueOf((boolean)value);
        }

        public ConditionResult visitContainsFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.CONTAINS);
        }

        public ConditionResult visitEqualsFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.EQUALS);
        }

        public ConditionResult visitExtendedMatchFilter(JsonValue jsonValue, JsonPointer field, String operator, Object valueAssertion) {
            return ConditionResult.UNDEFINED;
        }

        public ConditionResult visitGreaterThanFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.GREATER_THAN);
        }

        public ConditionResult visitGreaterThanOrEqualToFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.GREATER_THAN_OR_EQUAL_TO);
        }

        public ConditionResult visitLessThanFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.LESS_THAN);
        }

        public ConditionResult visitLessThanOrEqualToFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.LESS_THAN_OR_EQUAL_TO);
        }

        public ConditionResult visitNotFilter(JsonValue jsonValue, QueryFilter<JsonPointer> subFilter) {
            return ConditionResult.not((ConditionResult)((ConditionResult)subFilter.accept((QueryFilterVisitor)this, (Object)jsonValue)));
        }

        public ConditionResult visitOrFilter(JsonValue jsonValue, List<QueryFilter<JsonPointer>> subFilters) {
            ConditionResult r = ConditionResult.FALSE;
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                ConditionResult p = (ConditionResult)subFilter.accept((QueryFilterVisitor)this, (Object)jsonValue);
                if (p == ConditionResult.TRUE) {
                    return p;
                }
                r = ConditionResult.or((ConditionResult)r, (ConditionResult)p);
            }
            return r;
        }

        public ConditionResult visitPresentFilter(JsonValue jsonValue, JsonPointer field) {
            return ConditionResult.valueOf((jsonValue.get(field) != null ? 1 : 0) != 0);
        }

        public ConditionResult visitStartsWithFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion) {
            return this.visitComparisonFilter(jsonValue, field, valueAssertion, FilterType.STARTS_WITH);
        }

        private ConditionResult visitComparisonFilter(JsonValue jsonValue, JsonPointer field, Object valueAssertion, FilterType equals) {
            JsonValue jsonValueField = jsonValue.get(field);
            if (jsonValueField == null || jsonValueField.isMap()) {
                return ConditionResult.FALSE;
            }
            if (jsonValueField.isList()) {
                for (Object listElement : jsonValueField.asList()) {
                    if (!this.compare(equals, valueAssertion, listElement)) continue;
                    return ConditionResult.TRUE;
                }
                return ConditionResult.FALSE;
            }
            return ConditionResult.valueOf((boolean)this.compare(equals, valueAssertion, jsonValueField.getObject()));
        }

        private boolean compare(FilterType type, Object assertion, Object value) {
            if (assertion instanceof String && value instanceof String) {
                String stringAssertion = JsonQueryEqualityMatchingRuleImpl.this.normalizeString((String)assertion);
                String stringValue = JsonQueryEqualityMatchingRuleImpl.this.normalizeString((String)value);
                switch (type) {
                    case CONTAINS: {
                        return stringValue.contains(stringAssertion);
                    }
                    case STARTS_WITH: {
                        return stringValue.startsWith(stringAssertion);
                    }
                }
                return this.compare0(type, stringAssertion, stringValue);
            }
            if (assertion instanceof Number && value instanceof Number) {
                Double doubleAssertion = ((Number)assertion).doubleValue();
                Double doubleValue = ((Number)value).doubleValue();
                return this.compare0(type, doubleAssertion, doubleValue);
            }
            if (assertion instanceof Boolean && value instanceof Boolean) {
                Boolean booleanAssertion = (Boolean)assertion;
                Boolean booleanValue = (Boolean)value;
                return this.compare0(type, booleanAssertion, booleanValue);
            }
            return false;
        }

        private <T extends Comparable<T>> boolean compare0(FilterType type, T assertion, T value) {
            switch (type) {
                case CONTAINS: 
                case STARTS_WITH: 
                case EQUALS: {
                    return value.equals(assertion);
                }
                case GREATER_THAN: {
                    return value.compareTo(assertion) > 0;
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    return value.compareTo(assertion) >= 0;
                }
                case LESS_THAN: {
                    return value.compareTo(assertion) < 0;
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    return value.compareTo(assertion) <= 0;
                }
            }
            return false;
        }
    }

    private class IndexQueryBuilder<T>
    implements QueryFilterVisitor<T, IndexQueryFactory<T>, JsonPointer> {
        private IndexQueryBuilder() {
        }

        public T visitAndFilter(IndexQueryFactory<T> indexQueryFactory, List<QueryFilter<JsonPointer>> subFilters) {
            ArrayList<Object> subQueries = new ArrayList<Object>(subFilters.size());
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                subQueries.add(subFilter.accept((QueryFilterVisitor)this, indexQueryFactory));
            }
            return (T)indexQueryFactory.createIntersectionQuery(subQueries);
        }

        public T visitBooleanLiteralFilter(IndexQueryFactory<T> indexQueryFactory, boolean value) {
            return (T)(value ? indexQueryFactory.createMatchAllQuery() : indexQueryFactory.createUnionQuery(Collections.emptySet()));
        }

        public T visitContainsFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            return this.visitPresentFilter(indexQueryFactory, field);
        }

        public T visitEqualsFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            ByteString fieldKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer);
            ByteSequence key = JsonQueryEqualityMatchingRuleImpl.this.createIndexKey(fieldKey, valueAssertion);
            return (T)indexQueryFactory.createExactMatchQuery(JsonQueryEqualityMatchingRuleImpl.this.indexID, key);
        }

        public T visitExtendedMatchFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, String operator, Object valueAssertion) {
            return (T)indexQueryFactory.createUnionQuery(Collections.emptySet());
        }

        public T visitGreaterThanFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            ByteString fieldKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer);
            ByteSequence startKey = JsonQueryEqualityMatchingRuleImpl.this.createIndexKey(fieldKey, valueAssertion);
            ByteString endKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldEndIndexKey(normalizedJsonPointer);
            return (T)indexQueryFactory.createRangeMatchQuery(JsonQueryEqualityMatchingRuleImpl.this.indexID, startKey, (ByteSequence)endKey, false, false);
        }

        public T visitGreaterThanOrEqualToFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            ByteString fieldKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer);
            ByteSequence startKey = JsonQueryEqualityMatchingRuleImpl.this.createIndexKey(fieldKey, valueAssertion);
            ByteString endKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldEndIndexKey(normalizedJsonPointer);
            return (T)indexQueryFactory.createRangeMatchQuery(JsonQueryEqualityMatchingRuleImpl.this.indexID, startKey, (ByteSequence)endKey, true, false);
        }

        public T visitLessThanFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            ByteString startKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer);
            ByteSequence endKey = JsonQueryEqualityMatchingRuleImpl.this.createIndexKey(startKey, valueAssertion);
            return (T)indexQueryFactory.createRangeMatchQuery(JsonQueryEqualityMatchingRuleImpl.this.indexID, (ByteSequence)startKey, endKey, false, false);
        }

        public T visitLessThanOrEqualToFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            ByteString startKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer);
            ByteSequence endKey = JsonQueryEqualityMatchingRuleImpl.this.createIndexKey(startKey, valueAssertion);
            return (T)indexQueryFactory.createRangeMatchQuery(JsonQueryEqualityMatchingRuleImpl.this.indexID, (ByteSequence)startKey, endKey, false, true);
        }

        public T visitNotFilter(IndexQueryFactory<T> indexQueryFactory, QueryFilter<JsonPointer> subFilter) {
            return (T)indexQueryFactory.createMatchAllQuery();
        }

        public T visitOrFilter(IndexQueryFactory<T> indexQueryFactory, List<QueryFilter<JsonPointer>> subFilters) {
            ArrayList<Object> subQueries = new ArrayList<Object>(subFilters.size());
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                subQueries.add(subFilter.accept((QueryFilterVisitor)this, indexQueryFactory));
            }
            return (T)indexQueryFactory.createUnionQuery(subQueries);
        }

        public T visitPresentFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            ByteString startKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer);
            ByteString endKey = JsonQueryEqualityMatchingRuleImpl.this.createFieldEndIndexKey(normalizedJsonPointer);
            return (T)indexQueryFactory.createRangeMatchQuery(JsonQueryEqualityMatchingRuleImpl.this.indexID, (ByteSequence)startKey, (ByteSequence)endKey, true, false);
        }

        public T visitStartsWithFilter(IndexQueryFactory<T> indexQueryFactory, JsonPointer field, Object valueAssertion) {
            String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(field);
            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) {
                return (T)indexQueryFactory.createMatchAllQuery();
            }
            if (valueAssertion instanceof String) {
                return this.visitGreaterThanOrEqualToFilter(indexQueryFactory, field, valueAssertion);
            }
            return this.visitEqualsFilter(indexQueryFactory, field, valueAssertion);
        }
    }

    private class IndexerImpl
    implements Indexer {
        private IndexerImpl() {
        }

        public String getIndexID() {
            return JsonQueryEqualityMatchingRuleImpl.this.indexID;
        }

        public void createKeys(Schema schema, ByteSequence value, Collection<ByteString> keys) throws DecodeException {
            try (InputStream inputStream = value.asReader().asInputStream();
                 JsonParser parser = JsonSchema.ValidationPolicy.LENIENT.getJsonFactory().createParser(inputStream);){
                JsonToken jsonToken = parser.nextToken();
                if (jsonToken == null) {
                    throw DecodeException.error((LocalizableMessage)Rest2ldapMessages.ERR_JSON_EMPTY_CONTENT.get());
                }
                JsonPointer parentJsonPointer = new JsonPointer();
                JsonPointer jsonPointer = new JsonPointer();
                String normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(jsonPointer);
                ByteStringBuilder builder = new ByteStringBuilder();
                int depth = 0;
                do {
                    switch (jsonToken) {
                        case START_OBJECT: {
                            parentJsonPointer = jsonPointer;
                            ++depth;
                            break;
                        }
                        case START_ARRAY: {
                            ++depth;
                            break;
                        }
                        case END_OBJECT: {
                            jsonPointer = parentJsonPointer;
                            normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(jsonPointer);
                            parentJsonPointer = parentJsonPointer.parent();
                            --depth;
                            break;
                        }
                        case END_ARRAY: {
                            --depth;
                            break;
                        }
                        case FIELD_NAME: {
                            jsonPointer = parentJsonPointer.child(parser.getCurrentName());
                            normalizedJsonPointer = JsonQueryEqualityMatchingRuleImpl.this.normalizeJsonPointer(jsonPointer);
                            break;
                        }
                        case VALUE_NULL: {
                            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) break;
                            JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer, builder);
                            keys.add(JsonQueryEqualityMatchingRuleImpl.this.createNullIndexKey(builder));
                            break;
                        }
                        case VALUE_FALSE: {
                            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) break;
                            JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer, builder);
                            keys.add(JsonQueryEqualityMatchingRuleImpl.this.createBooleanIndexKey(builder, false));
                            break;
                        }
                        case VALUE_TRUE: {
                            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) break;
                            JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer, builder);
                            keys.add(JsonQueryEqualityMatchingRuleImpl.this.createBooleanIndexKey(builder, true));
                            break;
                        }
                        case VALUE_NUMBER_INT: 
                        case VALUE_NUMBER_FLOAT: {
                            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) break;
                            JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer, builder);
                            keys.add(JsonQueryEqualityMatchingRuleImpl.this.createNumberIndexKey(builder, parser.getDecimalValue()));
                            break;
                        }
                        case VALUE_STRING: {
                            if (!JsonQueryEqualityMatchingRuleImpl.this.isFieldIndexed(normalizedJsonPointer)) break;
                            JsonQueryEqualityMatchingRuleImpl.this.createFieldStartIndexKey(normalizedJsonPointer, builder);
                            keys.add(JsonQueryEqualityMatchingRuleImpl.this.createStringIndexKey(builder, parser.getText()));
                            break;
                        }
                        case NOT_AVAILABLE: 
                        case VALUE_EMBEDDED_OBJECT: {
                            throw new IllegalStateException();
                        }
                    }
                    builder.setLength(0);
                    jsonToken = parser.nextToken();
                } while (depth > 0);
                if (parser.nextToken() != null) {
                    throw DecodeException.error((LocalizableMessage)Rest2ldapMessages.ERR_JSON_TRAILING_CONTENT.get());
                }
            }
            catch (DecodeException e) {
                throw e;
            }
            catch (IOException e) {
                throw DecodeException.error((LocalizableMessage)JsonSchema.jsonParsingException(e));
            }
        }

        public String keyToHumanReadableString(ByteSequence key) {
            return key.toByteString().toASCIIString();
        }
    }
}

