/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.UncategorizedException;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.rest2ldap.Action;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.NamingStrategy;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.RoutingContext;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.ClientContext;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

final class SubResourceImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final ResourceException SUCCESS = new UncategorizedException(0, null, null);
    private static final JsonPointer ROOT = new JsonPointer();
    private final DN baseDn;
    private final AttributeDescription etagAttribute;
    private final NamingStrategy namingStrategy;
    private final DecodeOptions decodeOptions;
    private final ReadOnUpdatePolicy readOnUpdatePolicy;
    private final boolean useSubtreeDelete;
    private final boolean usePermissiveModify;
    private final Resource resource;
    private final Attribute glueObjectClasses;

    SubResourceImpl(Rest2Ldap rest2Ldap, DN baseDn, Attribute glueObjectClasses, NamingStrategy namingStrategy, Resource resource) {
        this.readOnUpdatePolicy = (ReadOnUpdatePolicy)((Object)rest2Ldap.getOptions().get(Rest2Ldap.READ_ON_UPDATE_POLICY));
        this.useSubtreeDelete = (Boolean)rest2Ldap.getOptions().get(Rest2Ldap.USE_SUBTREE_DELETE);
        this.usePermissiveModify = (Boolean)rest2Ldap.getOptions().get(Rest2Ldap.USE_PERMISSIVE_MODIFY);
        this.etagAttribute = (Boolean)rest2Ldap.getOptions().get(Rest2Ldap.USE_MVCC) != false ? AttributeDescription.valueOf((String)((String)rest2Ldap.getOptions().get(Rest2Ldap.MVCC_ATTRIBUTE))) : null;
        this.decodeOptions = (DecodeOptions)rest2Ldap.getOptions().get(Rest2Ldap.DECODE_OPTIONS);
        this.baseDn = baseDn;
        this.glueObjectClasses = glueObjectClasses;
        this.namingStrategy = namingStrategy;
        this.resource = resource;
    }

    Promise<ActionResponse, ResourceException> action(Context context, String resourceId, ActionRequest request) {
        try {
            Action action = (Action)org.forgerock.util.Utils.asEnum((String)request.getAction(), Action.class);
            if (this.resource.hasSupportedAction(action)) {
                switch (action) {
                    case RESET_PASSWORD: {
                        return this.resetPassword(context, resourceId);
                    }
                    case MODIFY_PASSWORD: {
                        return this.modifyPassword(context, resourceId, request);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Utils.newNotSupportedException(Rest2ldapMessages.ERR_ACTION_NOT_SUPPORTED.get((Object)request.getAction())).asPromise();
    }

    private Promise<ActionResponse, ResourceException> resetPassword(Context context, String resourceId) {
        if (!context.containsContext(ClientContext.class) || !((ClientContext)context.asContext(ClientContext.class)).isSecure()) {
            return ResourceException.newResourceException((int)403, (String)Rest2ldapMessages.ERR_PASSWORD_RESET_SECURE_CONNECTION.get().toString()).asPromise();
        }
        if (!context.containsContext(SecurityContext.class) || ((SecurityContext)context.asContext(SecurityContext.class)).getAuthenticationId() == null) {
            return ResourceException.newResourceException((int)403, (String)Rest2ldapMessages.ERR_PASSWORD_RESET_USER_AUTHENTICATED.get().toString()).asPromise();
        }
        final Connection connection = Utils.connectionFrom(context);
        return this.resolveResourceDnAndType(context, connection, resourceId, null).thenAsync((AsyncFunction)new AsyncFunction<RoutingContext, PasswordModifyExtendedResult, ResourceException>(){

            public Promise<PasswordModifyExtendedResult, ResourceException> apply(RoutingContext dnAndType) {
                PasswordModifyExtendedRequest pwdModifyRequest = Requests.newPasswordModifyExtendedRequest().setUserIdentity((Object)("dn: " + dnAndType.getDn()));
                return connection.extendedRequestAsync((ExtendedRequest)pwdModifyRequest).thenCatchAsync(SubResourceImpl.adaptLdapException(PasswordModifyExtendedResult.class));
            }
        }).thenAsync((AsyncFunction)new AsyncFunction<PasswordModifyExtendedResult, ActionResponse, ResourceException>(){

            public Promise<ActionResponse, ResourceException> apply(PasswordModifyExtendedResult r) {
                JsonValue result = new JsonValue(new LinkedHashMap());
                byte[] generatedPwd = r.getGeneratedPassword();
                if (generatedPwd != null) {
                    result.put("generatedPassword", (Object)ByteString.valueOfBytes((byte[])generatedPwd).toString());
                }
                return Responses.newActionResponse((JsonValue)result).asPromise();
            }
        });
    }

    private Promise<ActionResponse, ResourceException> modifyPassword(Context context, String resourceId, ActionRequest request) {
        String newPassword;
        String oldPassword;
        if (!context.containsContext(ClientContext.class) || !((ClientContext)context.asContext(ClientContext.class)).isSecure()) {
            return ResourceException.newResourceException((int)403, (String)Rest2ldapMessages.ERR_PASSWORD_MODIFY_SECURE_CONNECTION.get().toString()).asPromise();
        }
        if (!context.containsContext(SecurityContext.class) || ((SecurityContext)context.asContext(SecurityContext.class)).getAuthenticationId() == null) {
            return ResourceException.newResourceException((int)403, (String)Rest2ldapMessages.ERR_PASSWORD_MODIFY_USER_AUTHENTICATED.get().toString()).asPromise();
        }
        JsonValue jsonContent = request.getContent();
        try {
            oldPassword = jsonContent.get("oldPassword").required().asString();
            newPassword = jsonContent.get("newPassword").required().asString();
        }
        catch (JsonValueException e) {
            return Utils.newBadRequestException(Rest2ldapMessages.ERR_PASSWORD_MODIFY_REQUEST_IS_INVALID.get(), e).asPromise();
        }
        final Connection connection = Utils.connectionFrom(context);
        return this.resolveResourceDnAndType(context, connection, resourceId, null).thenAsync((AsyncFunction)new AsyncFunction<RoutingContext, PasswordModifyExtendedResult, ResourceException>(){

            public Promise<PasswordModifyExtendedResult, ResourceException> apply(RoutingContext dnAndType) {
                PasswordModifyExtendedRequest pwdModifyRequest = Requests.newPasswordModifyExtendedRequest().setUserIdentity((Object)("dn: " + dnAndType.getDn())).setOldPassword(SubResourceImpl.this.asBytes(oldPassword)).setNewPassword(SubResourceImpl.this.asBytes(newPassword));
                return connection.extendedRequestAsync((ExtendedRequest)pwdModifyRequest).thenCatchAsync(SubResourceImpl.adaptLdapException(PasswordModifyExtendedResult.class));
            }
        }).thenAsync((AsyncFunction)new AsyncFunction<PasswordModifyExtendedResult, ActionResponse, ResourceException>(){

            public Promise<ActionResponse, ResourceException> apply(PasswordModifyExtendedResult r) {
                return Responses.newActionResponse((JsonValue)new JsonValue(new LinkedHashMap(0))).asPromise();
            }
        });
    }

    private byte[] asBytes(String s) {
        return s != null ? s.getBytes(StandardCharsets.UTF_8) : null;
    }

    Promise<ResourceResponse, ResourceException> create(final Context context, final CreateRequest request) {
        Resource subType;
        try {
            subType = this.resource.resolveSubTypeFromJson(request.getContent());
        }
        catch (ResourceException e) {
            return e.asPromise();
        }
        RoutingContext parentDnAndType = RoutingContext.newCollectionRoutingContext(context, this.baseDn, subType);
        final Connection connection = Utils.connectionFrom(context);
        return subType.getPropertyMapper().create((Context)parentDnAndType, subType, ROOT, request.getContent()).thenAsync((AsyncFunction)new AsyncFunction<List<Attribute>, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(List<Attribute> attributes) {
                AddRequest addRequest = Requests.newAddRequest((DN)DN.rootDN());
                addRequest.addAttribute(subType.getObjectClassAttribute());
                for (Attribute attribute : attributes) {
                    addRequest.addAttribute(attribute);
                }
                try {
                    SubResourceImpl.this.namingStrategy.encodeResourceId(SubResourceImpl.this.baseDn, request.getNewResourceId(), (Entry)addRequest);
                }
                catch (ResourceException e) {
                    logger.error(LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]), (Throwable)e);
                    return e.asPromise();
                }
                if (SubResourceImpl.this.readOnUpdatePolicy == ReadOnUpdatePolicy.CONTROLS) {
                    Set ldapAttributes = SubResourceImpl.this.getLdapAttributesForKnownType(request.getFields(), subType);
                    addRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (Collection)ldapAttributes));
                }
                RoutingContext dnAndType = RoutingContext.newRoutingContext(context, addRequest.getName(), subType);
                return connection.addAsync(addRequest).thenCatchAsync(SubResourceImpl.this.lazilyAddGlueEntry(connection, addRequest)).thenAsync(SubResourceImpl.this.encodeUpdateResourceResponse((Context)dnAndType, subType), SubResourceImpl.adaptLdapException(ResourceResponse.class));
            }
        });
    }

    private AsyncFunction<LdapException, Result, LdapException> lazilyAddGlueEntry(final Connection connection, final AddRequest addRequest) {
        return new AsyncFunction<LdapException, Result, LdapException>(){

            public Promise<Result, LdapException> apply(LdapException e) throws LdapException {
                if (SubResourceImpl.this.glueObjectClasses != null && e instanceof EntryNotFoundException) {
                    AddRequest glueAddRequest = Requests.newAddRequest((DN)SubResourceImpl.this.baseDn);
                    glueAddRequest.addAttribute(SubResourceImpl.this.glueObjectClasses);
                    glueAddRequest.addAttribute(SubResourceImpl.this.baseDn.rdn().getFirstAVA().toAttribute());
                    return connection.addAsync(glueAddRequest).thenAsync((AsyncFunction)new AsyncFunction<Result, Result, LdapException>(){

                        public Promise<Result, LdapException> apply(Result value) {
                            return connection.addAsync(addRequest);
                        }
                    });
                }
                throw e;
            }
        };
    }

    Promise<ResourceResponse, ResourceException> delete(Context context, String resourceId, final org.forgerock.json.resource.DeleteRequest request) {
        final Connection connection = Utils.connectionFrom(context);
        return this.resolveResourceDnAndType(context, connection, resourceId, request.getRevision()).thenAsync((AsyncFunction)new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(RoutingContext dnAndType) throws ResourceException {
                DeleteRequest deleteRequest = Requests.newDeleteRequest((DN)dnAndType.getDn());
                if (SubResourceImpl.this.readOnUpdatePolicy == ReadOnUpdatePolicy.CONTROLS) {
                    Set attributes = SubResourceImpl.this.getLdapAttributesForKnownType(request.getFields(), dnAndType.getType());
                    deleteRequest.addControl((Control)PreReadRequestControl.newControl((boolean)false, (Collection)attributes));
                }
                if (SubResourceImpl.this.resource.mayHaveSubResources() && SubResourceImpl.this.useSubtreeDelete) {
                    deleteRequest.addControl((Control)SubtreeDeleteRequestControl.newControl((boolean)false));
                }
                SubResourceImpl.this.addAssertionControl((ChangeRecord)deleteRequest, request.getRevision());
                return connection.applyChangeAsync((ChangeRecord)deleteRequest).thenCatchAsync(SubResourceImpl.this.deleteSubtreeWithoutUsingSubtreeDeleteControl(connection, (ChangeRecord)deleteRequest)).thenAsync(SubResourceImpl.this.encodeUpdateResourceResponse((Context)dnAndType, dnAndType.getType()), SubResourceImpl.adaptLdapException(ResourceResponse.class));
            }
        });
    }

    private AsyncFunction<LdapException, Result, LdapException> deleteSubtreeWithoutUsingSubtreeDeleteControl(final Connection connection, final ChangeRecord deleteRequest) {
        return new AsyncFunction<LdapException, Result, LdapException>(){

            public Promise<Result, LdapException> apply(LdapException e) throws LdapException {
                if (e.getResult().getResultCode().asEnum() != ResultCode.Enum.NOT_ALLOWED_ON_NONLEAF || !SubResourceImpl.this.resource.mayHaveSubResources()) {
                    throw e;
                }
                SearchRequest subordinates = Requests.newSearchRequest((DN)deleteRequest.getName(), (SearchScope)SearchScope.SUBORDINATES, (Filter)Filter.objectClassPresent(), (String[])new String[]{"1.1"});
                final ArrayList subordinateEntries = new ArrayList();
                return connection.searchAsync(subordinates, new SearchResultHandler(){

                    public boolean handleEntry(SearchResultEntry entry) {
                        subordinateEntries.add(entry.getName());
                        return true;
                    }

                    public boolean handleReference(SearchResultReference reference) {
                        return false;
                    }
                }).thenAsync((AsyncFunction)new AsyncFunction<Result, Result, LdapException>(){

                    public Promise<Result, LdapException> apply(Result result) {
                        Collections.sort(subordinateEntries);
                        LdapPromise promise = LdapPromises.newSuccessfulLdapPromise((Object)org.forgerock.opendj.ldap.responses.Responses.newResult((ResultCode)ResultCode.SUCCESS));
                        for (int i = subordinateEntries.size() - 1; i >= 0; --i) {
                            DeleteRequest subordinateDelete = Requests.newDeleteRequest((DN)((DN)subordinateEntries.get(i)));
                            promise = promise.thenAsync((AsyncFunction)new AsyncFunction<Result, Result, LdapException>((ChangeRecord)subordinateDelete){
                                final /* synthetic */ ChangeRecord val$subordinateDelete;
                                {
                                    this.val$subordinateDelete = changeRecord;
                                }

                                public Promise<Result, LdapException> apply(Result result) {
                                    return connection.applyChangeAsync(this.val$subordinateDelete);
                                }
                            });
                        }
                        return promise.thenAsync((AsyncFunction)new AsyncFunction<Result, Result, LdapException>(){

                            public Promise<Result, LdapException> apply(Result result) {
                                return connection.applyChangeAsync(deleteRequest);
                            }
                        });
                    }
                });
            }
        };
    }

    Promise<ResourceResponse, ResourceException> patch(Context context, String resourceId, final PatchRequest request) {
        final Connection connection = Utils.connectionFrom(context);
        final AtomicReference dnAndTypeHolder = new AtomicReference();
        return this.resolveResourceDnAndType(context, connection, resourceId, request.getRevision()).thenAsync((AsyncFunction)new AsyncFunction<RoutingContext, List<List<Modification>>, ResourceException>(){

            public Promise<List<List<Modification>>, ResourceException> apply(RoutingContext dnAndType) throws ResourceException {
                dnAndTypeHolder.set(dnAndType);
                ArrayList<Promise<List<Modification>, ResourceException>> promises = new ArrayList<Promise<List<Modification>, ResourceException>>(request.getPatchOperations().size());
                Resource subType = dnAndType.getType();
                PropertyMapper propertyMapper = subType.getPropertyMapper();
                for (PatchOperation operation : request.getPatchOperations()) {
                    promises.add(propertyMapper.patch((Context)dnAndType, subType, ROOT, operation));
                }
                return Promises.when(promises);
            }
        }).thenAsync((AsyncFunction)new AsyncFunction<List<List<Modification>>, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(List<List<Modification>> result) throws ResourceException {
                RoutingContext dnAndType = (RoutingContext)((Object)dnAndTypeHolder.get());
                ModifyRequest modifyRequest = Requests.newModifyRequest((DN)dnAndType.getDn());
                for (List<Modification> modifications : result) {
                    if (modifications == null) continue;
                    modifyRequest.getModifications().addAll(modifications);
                }
                Resource subType = dnAndType.getType();
                Set attributes = SubResourceImpl.this.getLdapAttributesForKnownType(request.getFields(), subType);
                if (modifyRequest.getModifications().isEmpty()) {
                    return connection.readEntryAsync(dnAndType.getDn(), (Collection)attributes).thenAsync(SubResourceImpl.this.encodeEmptyPatchResourceResponse((Context)dnAndType, subType, request), SubResourceImpl.adaptLdapException(ResourceResponse.class));
                }
                if (SubResourceImpl.this.readOnUpdatePolicy == ReadOnUpdatePolicy.CONTROLS) {
                    modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (Collection)attributes));
                }
                if (SubResourceImpl.this.usePermissiveModify) {
                    modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                }
                SubResourceImpl.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                return connection.applyChangeAsync((ChangeRecord)modifyRequest).thenAsync(SubResourceImpl.this.encodeUpdateResourceResponse((Context)dnAndType, subType), SubResourceImpl.adaptLdapException(ResourceResponse.class));
            }
        });
    }

    private AsyncFunction<Entry, ResourceResponse, ResourceException> encodeEmptyPatchResourceResponse(final Context context, final Resource resource, final PatchRequest request) {
        return new AsyncFunction<Entry, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(Entry entry) throws ResourceException {
                try {
                    SubResourceImpl.this.ensureMvccVersionMatches(entry, request.getRevision());
                    return SubResourceImpl.this.encodeResourceResponse(context, resource, entry);
                }
                catch (Exception e) {
                    return Rest2Ldap.asResourceException(e).asPromise();
                }
            }
        };
    }

    Promise<QueryResponse, ResourceException> query(Context context, QueryRequest request, QueryResourceHandler resourceHandler) {
        return this.getLdapFilter(context, (QueryFilter<JsonPointer>)request.getQueryFilter()).thenAsync(this.runQuery(context, request, resourceHandler));
    }

    private Promise<Filter, ResourceException> getLdapFilter(Context context, QueryFilter<JsonPointer> queryFilter) {
        if (queryFilter == null) {
            return new BadRequestException(Rest2ldapMessages.ERR_QUERY_BY_ID_OR_EXPRESSION_NOT_SUPPORTED.get().toString()).asPromise();
        }
        final RoutingContext parentDnAndType = RoutingContext.newCollectionRoutingContext(context, this.baseDn, this.resource);
        final PropertyMapper propertyMapper = this.resource.getPropertyMapper();
        QueryFilterVisitor<Promise<Filter, ResourceException>, Void, JsonPointer> visitor = new QueryFilterVisitor<Promise<Filter, ResourceException>, Void, JsonPointer>(){

            public Promise<Filter, ResourceException> visitAndFilter(Void unused, List<QueryFilter<JsonPointer>> subFilters) {
                ArrayList<Object> promises = new ArrayList<Object>(subFilters.size());
                for (QueryFilter<JsonPointer> subFilter : subFilters) {
                    promises.add(subFilter.accept((QueryFilterVisitor)this, (Object)unused));
                }
                return Promises.when(promises).then((Function)new Function<List<Filter>, Filter, ResourceException>(){

                    public Filter apply(List<Filter> value) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                return Filter.alwaysFalse();
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            i.remove();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysTrue();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.and(value);
                    }
                });
            }

            public Promise<Filter, ResourceException> visitBooleanLiteralFilter(Void unused, boolean value) {
                return Promises.newResultPromise((Object)Utils.toFilter(value));
            }

            public Promise<Filter, ResourceException> visitContainsFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.CONTAINS, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitEqualsFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.EQUAL_TO, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitExtendedMatchFilter(Void unused, JsonPointer field, String operator, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.EXTENDED, operator, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitGreaterThanFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.GREATER_THAN, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitGreaterThanOrEqualToFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.GREATER_THAN_OR_EQUAL_TO, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitLessThanFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.LESS_THAN, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitLessThanOrEqualToFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.LESS_THAN_OR_EQUAL_TO, null, valueAssertion);
            }

            public Promise<Filter, ResourceException> visitNotFilter(Void unused, QueryFilter<JsonPointer> subFilter) {
                return ((Promise)subFilter.accept((QueryFilterVisitor)this, (Object)unused)).then((Function)new Function<Filter, Filter, ResourceException>(){

                    public Filter apply(Filter value) {
                        if (value == null || value == Filter.alwaysFalse()) {
                            return Filter.alwaysTrue();
                        }
                        if (value == Filter.alwaysTrue()) {
                            return Filter.alwaysFalse();
                        }
                        return Filter.not((Filter)value);
                    }
                });
            }

            public Promise<Filter, ResourceException> visitOrFilter(Void unused, List<QueryFilter<JsonPointer>> subFilters) {
                ArrayList<Object> promises = new ArrayList<Object>(subFilters.size());
                for (QueryFilter<JsonPointer> subFilter : subFilters) {
                    promises.add(subFilter.accept((QueryFilterVisitor)this, (Object)unused));
                }
                return Promises.when(promises).then((Function)new Function<List<Filter>, Filter, ResourceException>(){

                    public Filter apply(List<Filter> value) {
                        Iterator<Filter> i = value.iterator();
                        while (i.hasNext()) {
                            Filter f = i.next();
                            if (f == Filter.alwaysFalse()) {
                                i.remove();
                                continue;
                            }
                            if (f != Filter.alwaysTrue()) continue;
                            return Filter.alwaysTrue();
                        }
                        switch (value.size()) {
                            case 0: {
                                return Filter.alwaysFalse();
                            }
                            case 1: {
                                return value.get(0);
                            }
                        }
                        return Filter.or(value);
                    }
                });
            }

            public Promise<Filter, ResourceException> visitPresentFilter(Void unused, JsonPointer field) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.PRESENT, null, null);
            }

            public Promise<Filter, ResourceException> visitStartsWithFilter(Void unused, JsonPointer field, Object valueAssertion) {
                return propertyMapper.getLdapFilter((Context)parentDnAndType, SubResourceImpl.this.resource, ROOT, field, FilterType.STARTS_WITH, null, valueAssertion);
            }
        };
        return (Promise)queryFilter.accept((QueryFilterVisitor)visitor, null);
    }

    private AsyncFunction<Filter, QueryResponse, ResourceException> runQuery(final Context context, final QueryRequest request, final QueryResourceHandler resourceHandler) {
        return new AsyncFunction<Filter, QueryResponse, ResourceException>(){
            private final Object sequenceLock = new Object();
            private String cookie;
            private ResourceException pendingResult;
            private int pendingResourceCount;
            private boolean resultSent;
            private int totalResourceCount;

            public Promise<QueryResponse, ResourceException> apply(Filter ldapFilter) {
                int pageResultStartIndex;
                if (ldapFilter == null || ldapFilter == Filter.alwaysFalse()) {
                    return Responses.newQueryResponse().asPromise();
                }
                final PromiseImpl promise = PromiseImpl.create();
                String[] attributes = SubResourceImpl.this.getLdapAttributesForUnknownType(request.getFields()).toArray(new String[0]);
                Filter searchFilter = ldapFilter == Filter.alwaysTrue() ? Filter.objectClassPresent() : ldapFilter;
                SearchRequest searchRequest = Requests.newSearchRequest((DN)SubResourceImpl.this.baseDn, (SearchScope)SearchScope.SINGLE_LEVEL, (Filter)searchFilter, (String[])attributes);
                int pageSize = request.getPageSize();
                if (request.getPageSize() > 0) {
                    int pageResultEndIndex;
                    if (request.getPagedResultsOffset() > 0) {
                        pageResultStartIndex = request.getPagedResultsOffset() * pageSize;
                        pageResultEndIndex = pageResultStartIndex + pageSize;
                    } else {
                        pageResultStartIndex = 0;
                        pageResultEndIndex = pageSize;
                    }
                    ByteString cookie = request.getPagedResultsCookie() != null ? ByteString.valueOfBase64((String)request.getPagedResultsCookie()) : ByteString.empty();
                    SimplePagedResultsControl control = SimplePagedResultsControl.newControl((boolean)true, (int)pageResultEndIndex, (ByteString)cookie);
                    searchRequest.addControl((Control)control);
                } else {
                    pageResultStartIndex = 0;
                }
                Utils.connectionFrom(context).searchAsync(searchRequest, new SearchResultHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean handleEntry(SearchResultEntry entry) {
                        Object object = sequenceLock;
                        synchronized (object) {
                            if (pendingResult != null) {
                                return false;
                            }
                            if (totalResourceCount++ < pageResultStartIndex) {
                                return true;
                            }
                            pendingResourceCount++;
                        }
                        final String id = SubResourceImpl.this.namingStrategy.decodeResourceId((Entry)entry);
                        final String revision = SubResourceImpl.this.getRevisionFromEntry((Entry)entry);
                        Resource subType = SubResourceImpl.this.resource.resolveSubTypeFromObjectClasses((Entry)entry);
                        RoutingContext dnAndType = RoutingContext.newRoutingContext(context, entry.getName(), subType);
                        PropertyMapper propertyMapper = subType.getPropertyMapper();
                        propertyMapper.read((Context)dnAndType, subType, ROOT, (Entry)entry).thenOnResult((ResultHandler)new ResultHandler<JsonValue>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleResult(JsonValue result) {
                                Object object = sequenceLock;
                                synchronized (object) {
                                    pendingResourceCount--;
                                    if (!resultSent) {
                                        resourceHandler.handleResource(Responses.newResourceResponse((String)id, (String)revision, (JsonValue)result));
                                    }
                                    this.completeIfNecessary((PromiseImpl<QueryResponse, ResourceException>)promise);
                                }
                            }
                        }).thenOnException((ExceptionHandler)new ExceptionHandler<ResourceException>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void handleException(ResourceException exception) {
                                Object object = sequenceLock;
                                synchronized (object) {
                                    pendingResourceCount--;
                                    this.completeIfNecessary(exception, (PromiseImpl<QueryResponse, ResourceException>)promise);
                                }
                            }
                        });
                        return true;
                    }

                    public boolean handleReference(SearchResultReference reference) {
                        return true;
                    }
                }).thenOnResult((ResultHandler)new ResultHandler<Result>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleResult(Result result) {
                        Object object = sequenceLock;
                        synchronized (object) {
                            if (request.getPageSize() > 0) {
                                try {
                                    SimplePagedResultsControl control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, SubResourceImpl.this.decodeOptions);
                                    if (control != null && !control.getCookie().isEmpty()) {
                                        cookie = control.getCookie().toBase64String();
                                    }
                                }
                                catch (DecodeException e) {
                                    logger.error(Rest2ldapMessages.ERR_DECODING_CONTROL.get((Object)e.getLocalizedMessage()), (Throwable)e);
                                }
                            }
                            this.completeIfNecessary(SUCCESS, (PromiseImpl<QueryResponse, ResourceException>)promise);
                        }
                    }
                }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleException(LdapException e) {
                        Object object = sequenceLock;
                        synchronized (object) {
                            if (SubResourceImpl.this.glueObjectClasses != null && e instanceof EntryNotFoundException) {
                                this.completeIfNecessary(SUCCESS, (PromiseImpl<QueryResponse, ResourceException>)promise);
                            } else {
                                this.completeIfNecessary(Rest2Ldap.asResourceException(e), (PromiseImpl<QueryResponse, ResourceException>)promise);
                            }
                        }
                    }
                });
                return promise;
            }

            private void completeIfNecessary(ResourceException e, PromiseImpl<QueryResponse, ResourceException> handler) {
                if (this.pendingResult == null) {
                    this.pendingResult = e;
                }
                this.completeIfNecessary(handler);
            }

            private void completeIfNecessary(PromiseImpl<QueryResponse, ResourceException> handler) {
                if (this.pendingResourceCount == 0 && this.pendingResult != null && !this.resultSent) {
                    if (this.pendingResult == SUCCESS) {
                        handler.handleResult((Object)Responses.newQueryResponse((String)this.cookie));
                    } else {
                        handler.handleException((Exception)((Object)this.pendingResult));
                    }
                    this.resultSent = true;
                }
            }
        };
    }

    Promise<ResourceResponse, ResourceException> read(final Context context, String resourceId, ReadRequest request) {
        Connection connection = Utils.connectionFrom(context);
        return connection.searchSingleEntryAsync(this.searchRequestForUnknownType(resourceId, request.getFields())).thenCatchAsync(SubResourceImpl.adaptLdapException(SearchResultEntry.class)).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(SearchResultEntry entry) {
                Resource subType = SubResourceImpl.this.resource.resolveSubTypeFromObjectClasses((Entry)entry);
                RoutingContext dnAndType = RoutingContext.newRoutingContext(context, entry.getName(), subType);
                return SubResourceImpl.this.encodeResourceResponse((Context)dnAndType, subType, (Entry)entry);
            }
        });
    }

    Promise<ResourceResponse, ResourceException> update(final Context context, String resourceId, final UpdateRequest request) {
        final Connection connection = Utils.connectionFrom(context);
        final AtomicReference entryHolder = new AtomicReference();
        final AtomicReference dnAndTypeHolder = new AtomicReference();
        return connection.searchSingleEntryAsync(this.searchRequestForUnknownType(resourceId, Collections.emptyList())).thenCatchAsync(SubResourceImpl.adaptLdapException(SearchResultEntry.class)).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, List<Modification>, ResourceException>(){

            public Promise<List<Modification>, ResourceException> apply(SearchResultEntry entry) throws ResourceException {
                entryHolder.set(entry);
                SubResourceImpl.this.ensureMvccVersionMatches((Entry)entry, request.getRevision());
                Resource subType = SubResourceImpl.this.resource.resolveSubTypeFromObjectClasses((Entry)entry);
                RoutingContext dnAndType = RoutingContext.newRoutingContext(context, entry.getName(), subType);
                dnAndTypeHolder.set(dnAndType);
                PropertyMapper propertyMapper = subType.getPropertyMapper();
                return propertyMapper.update((Context)dnAndType, subType, ROOT, (Entry)entry, request.getContent());
            }
        }).thenAsync((AsyncFunction)new AsyncFunction<List<Modification>, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(List<Modification> modifications) throws ResourceException {
                RoutingContext dnAndType = (RoutingContext)((Object)dnAndTypeHolder.get());
                Resource subType = dnAndType.getType();
                if (modifications.isEmpty()) {
                    return SubResourceImpl.this.encodeResourceResponse((Context)dnAndType, subType, (Entry)entryHolder.get());
                }
                ModifyRequest modifyRequest = Requests.newModifyRequest((DN)((Entry)entryHolder.get()).getName());
                if (SubResourceImpl.this.readOnUpdatePolicy == ReadOnUpdatePolicy.CONTROLS) {
                    Set attributes = SubResourceImpl.this.getLdapAttributesForKnownType(request.getFields(), subType);
                    modifyRequest.addControl((Control)PostReadRequestControl.newControl((boolean)false, (Collection)attributes));
                }
                if (SubResourceImpl.this.usePermissiveModify) {
                    modifyRequest.addControl((Control)PermissiveModifyRequestControl.newControl((boolean)true));
                }
                SubResourceImpl.this.addAssertionControl((ChangeRecord)modifyRequest, request.getRevision());
                modifyRequest.getModifications().addAll(modifications);
                return connection.applyChangeAsync((ChangeRecord)modifyRequest).thenAsync(SubResourceImpl.this.encodeUpdateResourceResponse((Context)dnAndType, subType), SubResourceImpl.adaptLdapException(ResourceResponse.class));
            }
        });
    }

    private Promise<ResourceResponse, ResourceException> encodeResourceResponse(Context context, Resource resource, final Entry entry) {
        PropertyMapper propertyMapper = resource.getPropertyMapper();
        return propertyMapper.read(context, resource, ROOT, entry).then((Function)new Function<JsonValue, ResourceResponse, ResourceException>(){

            public ResourceResponse apply(JsonValue value) {
                String revision = SubResourceImpl.this.getRevisionFromEntry(entry);
                String actualResourceId = SubResourceImpl.this.namingStrategy.decodeResourceId(entry);
                return Responses.newResourceResponse((String)actualResourceId, (String)revision, (JsonValue)new JsonValue((Object)value));
            }
        });
    }

    private void addAssertionControl(ChangeRecord request, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMvccSupported();
            Filter filter = Filter.equality((String)this.etagAttribute.toString(), (Object)expectedRevision);
            request.addControl((Control)AssertionRequestControl.newControl((boolean)true, (Filter)filter));
        }
    }

    private Promise<RoutingContext, ResourceException> resolveResourceDnAndType(final Context context, Connection connection, String resourceId, final String revision) {
        SearchRequest searchRequest = this.namingStrategy.createSearchRequest(this.baseDn, resourceId);
        if (searchRequest.getScope().equals((Object)SearchScope.BASE_OBJECT) && !this.resource.hasSubTypes()) {
            return Promises.newResultPromise((Object)((Object)RoutingContext.newRoutingContext(context, searchRequest.getName(), this.resource)));
        }
        if (this.etagAttribute != null && revision != null) {
            searchRequest.addAttribute(new String[]{this.etagAttribute.toString()});
        }
        searchRequest.addAttribute(new String[]{"objectClass"});
        return connection.searchSingleEntryAsync(searchRequest).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, RoutingContext, ResourceException>(){

            public Promise<RoutingContext, ResourceException> apply(SearchResultEntry entry) throws ResourceException {
                SubResourceImpl.this.ensureMvccVersionMatches((Entry)entry, revision);
                Resource subType = SubResourceImpl.this.resource.resolveSubTypeFromObjectClasses((Entry)entry);
                return Promises.newResultPromise((Object)((Object)RoutingContext.newRoutingContext(context, entry.getName(), subType)));
            }
        }, SubResourceImpl.adaptLdapException(RoutingContext.class));
    }

    private void ensureMvccSupported() throws NotSupportedException {
        if (this.etagAttribute == null) {
            throw Utils.newNotSupportedException(Rest2ldapMessages.ERR_MVCC_NOT_SUPPORTED.get());
        }
    }

    private void ensureMvccVersionMatches(Entry entry, String expectedRevision) throws ResourceException {
        if (expectedRevision != null) {
            this.ensureMvccSupported();
            String actualRevision = entry.parseAttribute(this.etagAttribute).asString();
            if (actualRevision == null) {
                throw new PreconditionFailedException(Rest2ldapMessages.ERR_MVCC_NO_VERSION_INFORMATION.get((Object)expectedRevision).toString());
            }
            if (!expectedRevision.equals(actualRevision)) {
                throw new PreconditionFailedException(Rest2ldapMessages.ERR_MVCC_VERSIONS_MISMATCH.get((Object)expectedRevision, (Object)actualRevision).toString());
            }
        }
    }

    private Set<String> getLdapAttributesForUnknownType(Collection<JsonPointer> fields) {
        Set<String> ldapAttributes = this.getLdapAttributesForKnownType(fields, this.resource);
        this.getLdapAttributesForUnknownType(fields, this.resource, ldapAttributes);
        return ldapAttributes;
    }

    private void getLdapAttributesForUnknownType(Collection<JsonPointer> fields, Resource resource, Set<String> ldapAttributes) {
        for (Resource subType : resource.getSubTypes()) {
            this.addLdapAttributesForFields(fields, subType, ldapAttributes);
            this.getLdapAttributesForUnknownType(fields, subType, ldapAttributes);
        }
    }

    private Set<String> getLdapAttributesForKnownType(Collection<JsonPointer> fields, Resource resource) {
        LinkedHashSet<String> ldapAttributes = new LinkedHashSet<String>();
        ldapAttributes.add("objectClass");
        String resourceIdLdapAttribute = this.namingStrategy.getResourceIdLdapAttribute();
        if (resourceIdLdapAttribute != null) {
            ldapAttributes.add(resourceIdLdapAttribute);
        }
        if (this.etagAttribute != null) {
            ldapAttributes.add(this.etagAttribute.toString());
        }
        this.addLdapAttributesForFields(fields, resource, ldapAttributes);
        return ldapAttributes;
    }

    private void addLdapAttributesForFields(Collection<JsonPointer> fields, Resource resource, Set<String> ldapAttributes) {
        PropertyMapper propertyMapper = resource.getPropertyMapper();
        if (fields.isEmpty()) {
            propertyMapper.getLdapAttributes(ROOT, ROOT, ldapAttributes);
        } else {
            for (JsonPointer field : fields) {
                propertyMapper.getLdapAttributes(ROOT, field, ldapAttributes);
            }
        }
    }

    private String getRevisionFromEntry(Entry entry) {
        return this.etagAttribute != null ? entry.parseAttribute(this.etagAttribute).asString() : null;
    }

    private AsyncFunction<Result, ResourceResponse, ResourceException> encodeUpdateResourceResponse(final Context context, final Resource resource) {
        return new AsyncFunction<Result, ResourceResponse, ResourceException>(){

            public Promise<ResourceResponse, ResourceException> apply(Result result) {
                try {
                    PostReadResponseControl postReadControl = (PostReadResponseControl)result.getControl(PostReadResponseControl.DECODER, SubResourceImpl.this.decodeOptions);
                    if (postReadControl != null) {
                        return SubResourceImpl.this.encodeResourceResponse(context, resource, postReadControl.getEntry());
                    }
                    PreReadResponseControl preReadControl = (PreReadResponseControl)result.getControl(PreReadResponseControl.DECODER, SubResourceImpl.this.decodeOptions);
                    if (preReadControl != null) {
                        return SubResourceImpl.this.encodeResourceResponse(context, resource, preReadControl.getEntry());
                    }
                }
                catch (DecodeException e) {
                    logger.error(Rest2ldapMessages.ERR_DECODING_CONTROL.get((Object)e.getLocalizedMessage()), (Throwable)e);
                }
                return Responses.newResourceResponse(null, null, (JsonValue)new JsonValue(Collections.emptyMap())).asPromise();
            }
        };
    }

    private SearchRequest searchRequestForUnknownType(String resourceId, List<JsonPointer> fields) {
        String[] attributes = this.getLdapAttributesForUnknownType(fields).toArray(new String[0]);
        return this.namingStrategy.createSearchRequest(this.baseDn, resourceId).addAttribute(attributes);
    }

    private static <R> AsyncFunction<LdapException, R, ResourceException> adaptLdapException(Class<R> clazz) {
        return new AsyncFunction<LdapException, R, ResourceException>(){

            public Promise<R, ResourceException> apply(LdapException ldapException) {
                return Rest2Ldap.asResourceException(ldapException).asPromise();
            }
        };
    }
}

