/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.AbstractLdapPropertyMapper;
import org.forgerock.opendj.rest2ldap.DnTemplate;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

public final class ReferencePropertyMapper
extends AbstractLdapPropertyMapper<ReferencePropertyMapper> {
    private static final int SEARCH_MAX_CANDIDATES = 1000;
    private final DnTemplate baseDnTemplate;
    private final Schema schema;
    private Filter filter;
    private final PropertyMapper mapper;
    private final AttributeDescription primaryKey;
    private SearchScope scope = SearchScope.WHOLE_SUBTREE;

    ReferencePropertyMapper(Schema schema, AttributeDescription ldapAttributeName, String baseDnTemplate, AttributeDescription primaryKey, PropertyMapper mapper) {
        super(ldapAttributeName);
        this.schema = schema;
        this.baseDnTemplate = DnTemplate.compile(baseDnTemplate);
        this.primaryKey = primaryKey;
        this.mapper = mapper;
    }

    public ReferencePropertyMapper searchFilter(Filter filter) {
        this.filter = (Filter)Reject.checkNotNull((Object)filter);
        return this;
    }

    public ReferencePropertyMapper searchFilter(String filter) {
        return this.searchFilter(Filter.valueOf((String)filter));
    }

    public ReferencePropertyMapper searchScope(SearchScope scope) {
        this.scope = (SearchScope)Reject.checkNotNull((Object)scope);
        return this;
    }

    public String toString() {
        return "reference(" + this.ldapAttributeName + ")";
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(final Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        return this.mapper.getLdapFilter(context, resource, path, subPath, type, operator, valueAssertion).thenAsync((AsyncFunction)new AsyncFunction<Filter, Filter, ResourceException>(){

            public Promise<Filter, ResourceException> apply(Filter result) {
                SearchRequest request = ReferencePropertyMapper.this.createSearchRequest(context, result);
                final LinkedList subFilters = new LinkedList();
                return Utils.connectionFrom(context).searchAsync(request, new SearchResultHandler(){

                    public boolean handleEntry(SearchResultEntry entry) {
                        if (subFilters.size() < 1000) {
                            subFilters.add(Filter.equality((String)ReferencePropertyMapper.this.ldapAttributeName.toString(), (Object)entry.getName()));
                            return true;
                        }
                        return false;
                    }

                    public boolean handleReference(SearchResultReference reference) {
                        return true;
                    }
                }).then((Function)new Function<Result, Filter, ResourceException>(){

                    public Filter apply(Result result) throws ResourceException {
                        if (subFilters.size() >= 1000) {
                            throw Rest2Ldap.asResourceException(LdapException.newLdapException((ResultCode)ResultCode.ADMIN_LIMIT_EXCEEDED));
                        }
                        if (subFilters.size() == 1) {
                            return (Filter)subFilters.get(0);
                        }
                        return Filter.or((Collection)subFilters);
                    }
                }, (Function)new Function<LdapException, Filter, ResourceException>(){

                    public Filter apply(LdapException exception) throws ResourceException {
                        throw Rest2Ldap.asResourceException(exception);
                    }
                });
            }
        });
    }

    @Override
    Promise<Attribute, ResourceException> getNewLdapAttributes(final Context context, Resource resource, final JsonPointer path, List<Object> newValues) {
        LinkedAttribute newLDAPAttribute = new LinkedAttribute(this.ldapAttributeName);
        AtomicInteger pendingSearches = new AtomicInteger(newValues.size());
        AtomicReference exception = new AtomicReference();
        final PromiseImpl promise = PromiseImpl.create();
        for (Object value : newValues) {
            this.mapper.create(context, resource, path, new JsonValue(value)).thenOnResult((ResultHandler)new ResultHandler<List<Attribute>>((Attribute)newLDAPAttribute, exception, pendingSearches){
                final /* synthetic */ Attribute val$newLDAPAttribute;
                final /* synthetic */ AtomicReference val$exception;
                final /* synthetic */ AtomicInteger val$pendingSearches;
                {
                    this.val$newLDAPAttribute = attribute;
                    this.val$exception = atomicReference;
                    this.val$pendingSearches = atomicInteger;
                }

                public void handleResult(List<Attribute> result) {
                    Attribute primaryKeyAttribute = null;
                    for (Attribute attribute : result) {
                        if (!attribute.getAttributeDescription().equals((Object)ReferencePropertyMapper.this.primaryKey)) continue;
                        primaryKeyAttribute = attribute;
                        break;
                    }
                    if (primaryKeyAttribute == null || primaryKeyAttribute.isEmpty()) {
                        promise.handleException((Exception)Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_NO_PRIMARY_KEY.get((Object)path)));
                        return;
                    }
                    if (primaryKeyAttribute.size() > 1) {
                        promise.handleException((Exception)Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_MULTIPLE_PRIMARY_KEYS.get((Object)path)));
                        return;
                    }
                    final ByteString primaryKeyValue = primaryKeyAttribute.firstValue();
                    Filter filter = Filter.equality((String)ReferencePropertyMapper.this.primaryKey.toString(), (Object)primaryKeyValue);
                    SearchRequest search = ReferencePropertyMapper.this.createSearchRequest(context, filter);
                    Utils.connectionFrom(context).searchSingleEntryAsync(search).thenOnResult((ResultHandler)new ResultHandler<SearchResultEntry>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleResult(SearchResultEntry result) {
                            Attribute attribute = val$newLDAPAttribute;
                            synchronized (attribute) {
                                val$newLDAPAttribute.add(new Object[]{result.getName()});
                            }
                            this.completeIfNecessary();
                        }
                    }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

                        public void handleException(LdapException error) {
                            ResourceException re;
                            try {
                                throw error;
                            }
                            catch (EntryNotFoundException e) {
                                re = Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_DOES_NOT_EXIST.get((Object)primaryKeyValue, (Object)path));
                            }
                            catch (MultipleEntriesFoundException e) {
                                re = Utils.newBadRequestException(Rest2ldapMessages.ERR_REFERENCE_FIELD_AMBIGUOUS.get((Object)primaryKeyValue, (Object)path));
                            }
                            catch (LdapException e) {
                                re = Rest2Ldap.asResourceException(e);
                            }
                            val$exception.compareAndSet(null, re);
                            this.completeIfNecessary();
                        }
                    });
                }

                private void completeIfNecessary() {
                    if (this.val$pendingSearches.decrementAndGet() == 0) {
                        if (this.val$exception.get() != null) {
                            promise.handleException((Exception)this.val$exception.get());
                        } else {
                            promise.handleResult((Object)this.val$newLDAPAttribute);
                        }
                    }
                }
            });
        }
        return promise;
    }

    @Override
    ReferencePropertyMapper getThis() {
        return this;
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        Set dns = e.parseAttribute(this.ldapAttributeName).usingSchema(this.schema).asSetOfDN();
        switch (dns.size()) {
            case 0: {
                return Promises.newResultPromise(null);
            }
            case 1: {
                if (!this.attributeIsSingleValued()) break;
                try {
                    return this.readEntry(context, resource, path, (DN)dns.iterator().next());
                }
                catch (Exception ex) {
                    return Promises.newExceptionPromise((Exception)((Object)Rest2Ldap.asResourceException(ex)));
                }
            }
        }
        try {
            ArrayList<Promise<JsonValue, ResourceException>> promises = new ArrayList<Promise<JsonValue, ResourceException>>(dns.size());
            for (DN dn : dns) {
                promises.add(this.readEntry(context, resource, path, dn));
            }
            return Promises.when(promises).then((Function)new Function<List<JsonValue>, JsonValue, ResourceException>(){

                public JsonValue apply(List<JsonValue> value) {
                    if (value.isEmpty()) {
                        return null;
                    }
                    ArrayList<Object> result = new ArrayList<Object>(value.size());
                    for (JsonValue e : value) {
                        if (e == null) continue;
                        result.add(e.getObject());
                    }
                    return result.isEmpty() ? null : new JsonValue(result);
                }
            });
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2Ldap.asResourceException(ex)));
        }
    }

    private SearchRequest createSearchRequest(Context context, Filter result) {
        Filter searchFilter = this.filter != null ? Filter.and((Filter[])new Filter[]{this.filter, result}) : result;
        return Requests.newSearchRequest((DN)this.baseDnTemplate.format(context), (SearchScope)this.scope, (Filter)searchFilter, (String[])new String[]{"1.1"});
    }

    private Promise<JsonValue, ResourceException> readEntry(final Context context, final Resource resource, final JsonPointer path, DN dn) {
        LinkedHashSet<String> requestedLDAPAttributes = new LinkedHashSet<String>();
        this.mapper.getLdapAttributes(path, new JsonPointer(), requestedLDAPAttributes);
        Filter searchFilter = this.filter != null ? this.filter : Filter.alwaysTrue();
        String[] attributes = requestedLDAPAttributes.toArray(new String[requestedLDAPAttributes.size()]);
        SearchRequest request = Requests.newSearchRequest((DN)dn, (SearchScope)SearchScope.BASE_OBJECT, (Filter)searchFilter, (String[])attributes);
        return Utils.connectionFrom(context).searchSingleEntryAsync(request).thenAsync((AsyncFunction)new AsyncFunction<SearchResultEntry, JsonValue, ResourceException>(){

            public Promise<JsonValue, ResourceException> apply(SearchResultEntry result) {
                return ReferencePropertyMapper.this.mapper.read(context, resource, path, (Entry)result);
            }
        }, (AsyncFunction)new AsyncFunction<LdapException, JsonValue, ResourceException>(){

            public Promise<JsonValue, ResourceException> apply(LdapException error) {
                if (error instanceof EntryNotFoundException) {
                    return Promises.newResultPromise(null);
                }
                return Promises.newExceptionPromise((Exception)((Object)Rest2Ldap.asResourceException((Throwable)error)));
            }
        });
    }

    @Override
    JsonValue toJsonSchema() {
        if (this.mapper.isMultiValued()) {
            JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"array"), JsonValue.field((String)"items", (Object)this.mapper.toJsonSchema()), JsonValue.field((String)"uniqueItems", (Object)true)}));
            this.putWritabilityProperties(jsonSchema);
            return jsonSchema;
        }
        return this.mapper.toJsonSchema();
    }
}

