/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2LdapContext;
import org.forgerock.opendj.rest2ldap.RoutingContext;
import org.forgerock.services.context.Context;
import org.forgerock.util.Options;

final class DnTemplate {
    private static final Pattern TEMPLATE_VARIABLE_RE = Pattern.compile("\\{([^}]+)\\}");
    private final String template;
    private final String formatString;
    private final List<String> variables;
    private final int relativeOffset;

    static DnTemplate compileRelative(String template) {
        return DnTemplate.compile(template, true);
    }

    static DnTemplate compile(String template) {
        return DnTemplate.compile(template, false);
    }

    private static DnTemplate compile(String template, boolean isRelative) {
        int relativeOffset;
        String trimmedTemplate;
        if (template.equals("..")) {
            trimmedTemplate = "";
            relativeOffset = 1;
        } else if (template.endsWith(",..")) {
            relativeOffset = 0;
            trimmedTemplate = template;
            while (trimmedTemplate.endsWith(",..")) {
                ++relativeOffset;
                trimmedTemplate = trimmedTemplate.substring(0, trimmedTemplate.length() - 3);
            }
        } else if (isRelative) {
            trimmedTemplate = template;
            relativeOffset = 0;
        } else {
            trimmedTemplate = template;
            relativeOffset = -1;
        }
        ArrayList<String> templateVariables = new ArrayList<String>();
        Matcher matcher = TEMPLATE_VARIABLE_RE.matcher(trimmedTemplate);
        StringBuffer buffer = new StringBuffer(trimmedTemplate.length());
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "%s");
            templateVariables.add(matcher.group(1));
        }
        matcher.appendTail(buffer);
        return new DnTemplate(trimmedTemplate, buffer.toString(), templateVariables, relativeOffset);
    }

    private DnTemplate(String template, String formatString, List<String> variables, int relativeOffset) {
        this.template = template;
        this.formatString = formatString;
        this.variables = variables;
        this.relativeOffset = relativeOffset;
    }

    DN format(Context context) {
        DN baseDn = null;
        if (this.relativeOffset >= 0 && context.containsContext(RoutingContext.class)) {
            RoutingContext routingContext = (RoutingContext)context.asContext(RoutingContext.class);
            baseDn = routingContext.getDn().parent(routingContext.isCollection() ? this.relativeOffset - 1 : this.relativeOffset);
        }
        if (baseDn == null) {
            baseDn = DN.rootDN();
        }
        Options options = ((Rest2LdapContext)context.asContext(Rest2LdapContext.class)).getRest2ldap().getOptions();
        Schema schema = ((DecodeOptions)options.get(Rest2Ldap.DECODE_OPTIONS)).getSchemaResolver().resolveSchema(this.template);
        if (this.variables.isEmpty()) {
            DN relativeDn = DN.valueOf((String)this.template, (Schema)schema);
            return baseDn.child(relativeDn);
        }
        String[] values = new String[this.variables.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.getTemplateParameter(context, this.variables.get(i));
        }
        DN relativeDn = DN.format((String)this.formatString, (Schema)schema, (Object[])values);
        return baseDn.child(relativeDn);
    }

    private String getTemplateParameter(Context context, String parameter) {
        UriRouterContext uriRouterContext = (UriRouterContext)context.asContext(UriRouterContext.class);
        Map uriTemplateVariables;
        String value;
        while ((value = (String)(uriTemplateVariables = uriRouterContext.getUriTemplateVariables()).get(parameter)) == null) {
            if (!uriRouterContext.getParent().containsContext(UriRouterContext.class)) {
                throw new IllegalStateException("DN template parameter \"" + parameter + "\" cannot be resolved");
            }
            uriRouterContext = (UriRouterContext)uriRouterContext.getParent().asContext(UriRouterContext.class);
        }
        return value;
    }
}

