/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.util.Reject;

public class ReferenceResolver {
    private static final String DEFINITIONS_REF = "#/definitions/";
    private static final String ERRORS_REF = "#/errors/";
    private static final String SERVICES_REF = "#/services/";
    private final ApiDescription local;
    private final Map<String, ApiDescription> map;

    public ReferenceResolver(ApiDescription local) {
        this.local = (ApiDescription)Reject.checkNotNull((Object)local);
        this.map = new HashMap<String, ApiDescription>();
        this.register(local);
    }

    public ReferenceResolver register(ApiDescription apiDescription) {
        if (this.map.containsKey(apiDescription.getId())) {
            throw new IllegalStateException("Already registered ID = " + apiDescription.getId());
        }
        this.map.put(apiDescription.getId(), apiDescription);
        return this;
    }

    public ReferenceResolver registerAll(ApiDescription ... apiDescriptions) {
        for (ApiDescription item : apiDescriptions) {
            this.register(item);
        }
        return this;
    }

    public Schema getDefinition(Reference reference) {
        return this.resolveDefinition(reference, new HashSet<String>());
    }

    private Schema resolveDefinition(Reference reference, Set<String> visitedRefs) {
        String name;
        int nameStart = reference.getValue().indexOf(DEFINITIONS_REF);
        if (nameStart != -1 && !(name = reference.getValue().substring(nameStart + DEFINITIONS_REF.length())).isEmpty()) {
            if (!visitedRefs.add(reference.getValue())) {
                throw new IllegalStateException("Reference loop detected: " + reference.getValue());
            }
            if (nameStart == 0) {
                if (this.local.getDefinitions() != null) {
                    Schema schema = this.local.getDefinitions().get(name);
                    if (schema != null && schema.getReference() != null) {
                        return this.resolveDefinition(schema.getReference(), visitedRefs);
                    }
                    return schema;
                }
            } else {
                String namespace = reference.getValue().substring(0, nameStart);
                ApiDescription apiDescription = this.map.get(namespace);
                if (apiDescription != null && apiDescription.getDefinitions() != null) {
                    Schema schema = apiDescription.getDefinitions().get(name);
                    if (schema != null && schema.getReference() != null) {
                        return this.resolveDefinition(schema.getReference(), visitedRefs);
                    }
                    return schema;
                }
            }
        }
        return null;
    }

    public ApiError getError(Reference reference) {
        return this.resolveError(reference, new HashSet<String>());
    }

    private ApiError resolveError(Reference reference, Set<String> visitedRefs) {
        String name;
        int nameStart = reference.getValue().indexOf(ERRORS_REF);
        if (nameStart != -1 && !(name = reference.getValue().substring(nameStart + ERRORS_REF.length())).isEmpty()) {
            if (!visitedRefs.add(reference.getValue())) {
                throw new IllegalStateException("Reference loop detected: " + reference.getValue());
            }
            if (nameStart == 0) {
                if (this.local.getErrors() != null) {
                    ApiError error = this.local.getErrors().get(name);
                    if (error != null && error.getReference() != null) {
                        return this.resolveError(error.getReference(), visitedRefs);
                    }
                    return error;
                }
            } else {
                String namespace = reference.getValue().substring(0, nameStart);
                ApiDescription apiDescription = this.map.get(namespace);
                if (apiDescription != null && apiDescription.getErrors() != null) {
                    ApiError error = apiDescription.getErrors().get(name);
                    if (error != null && error.getReference() != null) {
                        return this.resolveError(error.getReference(), visitedRefs);
                    }
                    return error;
                }
            }
        }
        return null;
    }

    public Resource getService(Reference reference) {
        return this.resolveService(reference, new HashSet<String>());
    }

    private Resource resolveService(Reference reference, Set<String> visitedRefs) {
        String name;
        int nameStart = reference.getValue().indexOf(SERVICES_REF);
        if (nameStart != -1 && !(name = reference.getValue().substring(nameStart + SERVICES_REF.length())).isEmpty()) {
            if (!visitedRefs.add(reference.getValue())) {
                throw new IllegalStateException("Reference loop detected: " + reference.getValue());
            }
            if (nameStart == 0) {
                if (this.local.getServices() != null) {
                    Resource service = this.local.getServices().get(name);
                    if (service != null && service.getReference() != null) {
                        return this.resolveService(service.getReference(), visitedRefs);
                    }
                    return service;
                }
            } else {
                String namespace = reference.getValue().substring(0, nameStart);
                ApiDescription apiDescription = this.map.get(namespace);
                if (apiDescription != null && apiDescription.getServices() != null) {
                    Resource service = apiDescription.getServices().get(name);
                    if (service != null && service.getReference() != null) {
                        return this.resolveService(service.getReference(), visitedRefs);
                    }
                    return service;
                }
            }
        }
        return null;
    }
}

