/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.api.enums.ParameterSource;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.util.ValidationUtil;

public final class PathUtil {
    private static final Pattern SQUASH_FORWARD_SLASHES_PATTERN = Pattern.compile("[/]{2,}");
    private static final Pattern TRAILING_SLASHES_PATTERN = Pattern.compile("[/]+$");
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("\\{([^{}]+)\\}");

    private PathUtil() {
    }

    public static String buildPath(String segment, String ... moreSegments) {
        Matcher m;
        if (ValidationUtil.isEmpty(segment)) {
            throw new IllegalArgumentException("segment argument required");
        }
        StringBuilder path = new StringBuilder().append('/').append(segment);
        if (moreSegments != null) {
            for (String s : moreSegments) {
                path.append('/').append(s);
            }
        }
        String normalized = (m = SQUASH_FORWARD_SLASHES_PATTERN.matcher(path)).find() ? m.replaceAll("/") : path.toString();
        return TRAILING_SLASHES_PATTERN.matcher(normalized).replaceAll("");
    }

    public static Parameter[] buildPathParameters(String pathSegment) {
        Matcher m;
        if (!ValidationUtil.isEmpty(pathSegment) && (m = PATH_VARIABLE_PATTERN.matcher(pathSegment)).find()) {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            int start = 0;
            while (m.find(start)) {
                parameters.add(Parameter.parameter().name(m.group(1)).type("string").source(ParameterSource.PATH).required(true).build());
                start = m.end();
            }
            return parameters.toArray(new Parameter[parameters.size()]);
        }
        return null;
    }

    public static List<Parameter> mergeParameters(List<Parameter> parameterList, Parameter ... parameters) {
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                int replaceIndex = -1;
                for (int i = 0; i < parameterList.size(); ++i) {
                    if (!parameterList.get(i).getName().equals(parameter.getName())) continue;
                    replaceIndex = i;
                    break;
                }
                if (replaceIndex != -1) {
                    parameterList.set(replaceIndex, parameter);
                    continue;
                }
                parameterList.add(parameter);
            }
        }
        return parameterList;
    }
}

