/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.Property;
import java.util.Objects;
import org.forgerock.api.transform.LocalizableProperty;
import org.forgerock.util.i18n.LocalizableString;

class LocalizableBooleanProperty
extends BooleanProperty
implements LocalizableProperty<Property> {
    private LocalizableString title;
    private LocalizableString description;

    LocalizableBooleanProperty() {
    }

    @Override
    public LocalizableBooleanProperty title(LocalizableString title) {
        this.title = title;
        return this;
    }

    @Override
    public LocalizableBooleanProperty description(LocalizableString desc) {
        this.description = desc;
        return this;
    }

    @Override
    public LocalizableBooleanProperty title(String title) {
        this.setTitle(title);
        return this;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = new LocalizableString(title);
    }

    @Override
    public LocalizableBooleanProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableTitle() {
        return this.title;
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LocalizableBooleanProperty)) {
            return false;
        }
        LocalizableBooleanProperty other = (LocalizableBooleanProperty)o;
        if (!Objects.equals(this.title, other.title)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.description);
    }
}

