/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.validation.ValidationException;
import javax.xml.bind.DatatypeConverter;
import org.forgerock.api.enums.ReadPolicy;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.api.jackson.CrestReadWritePoliciesSchema;
import org.forgerock.api.jackson.EnumSchema;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.jackson.OrderedFieldSchema;
import org.forgerock.api.jackson.PropertyFormatSchema;
import org.forgerock.api.jackson.ValidatableSchema;
import org.forgerock.api.jackson.WithExampleSchema;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.guava.common.net.InetAddresses;
import org.forgerock.guava.common.net.InternetDomainName;
import org.forgerock.json.JsonValue;

class CrestStringSchema
extends StringSchema
implements CrestReadWritePoliciesSchema,
OrderedFieldSchema,
EnumSchema,
ValidatableSchema,
PropertyFormatSchema,
WithExampleSchema<String> {
    private WritePolicy writePolicy;
    private ReadPolicy readPolicy;
    private Boolean errorOnWritePolicyFailure;
    private Boolean returnOnDemand;
    private Integer propertyOrder;
    private String propertyFormat;
    @JsonProperty
    private Map<String, List<String>> options;
    private String example;

    CrestStringSchema() {
    }

    @Override
    public WritePolicy getWritePolicy() {
        return this.writePolicy;
    }

    @Override
    public void setWritePolicy(WritePolicy policy) {
        this.writePolicy = policy;
    }

    @Override
    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    @Override
    public void setReadPolicy(ReadPolicy readPolicy) {
        this.readPolicy = readPolicy;
    }

    @Override
    public Boolean getErrorOnWritePolicyFailure() {
        return this.errorOnWritePolicyFailure;
    }

    @Override
    public void setErrorOnWritePolicyFailure(Boolean errorOnWritePolicyFailure) {
        this.errorOnWritePolicyFailure = errorOnWritePolicyFailure;
    }

    @Override
    public Boolean getReturnOnDemand() {
        return this.returnOnDemand;
    }

    @Override
    public void setReturnOnDemand(Boolean returnOnDemand) {
        this.returnOnDemand = returnOnDemand;
    }

    @Override
    public Integer getPropertyOrder() {
        return this.propertyOrder;
    }

    @Override
    public void setPropertyOrder(Integer order) {
        this.propertyOrder = order;
    }

    @Override
    public List<String> getEnumTitles() {
        return this.options == null ? null : this.options.get("enum_titles");
    }

    @Override
    public void setEnumTitles(List<String> titles) {
        this.options = Collections.singletonMap("enum_titles", titles);
    }

    @Override
    public void validate(JsonValue object) throws ValidationException {
        if (!object.isString()) {
            throw new ValidationException("Expected string but got: " + object.getObject());
        }
        String s = object.asString();
        JacksonUtils.validateEnum(this.enums, s);
        if (!ValidationUtil.isEmpty(this.propertyFormat)) {
            this.validateFormat(s);
        }
    }

    private void validateFormat(String s) throws ValidationException {
        switch (this.propertyFormat) {
            case "date-time": {
                try {
                    DatatypeConverter.parseDateTime((String)s);
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException("Expected date-time format, but got " + s, (Throwable)e);
                }
                return;
            }
            case "date": 
            case "full-date": {
                try {
                    DatatypeConverter.parseDate((String)s);
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException("Expected date/full-date format, but got " + s, (Throwable)e);
                }
                return;
            }
            case "email": {
                try {
                    new InternetAddress(s).validate();
                }
                catch (AddressException e) {
                    throw new ValidationException("Expected email, but got " + s, (Throwable)e);
                }
                return;
            }
            case "hostname": {
                if (!InternetDomainName.isValid((String)s)) {
                    throw new ValidationException("Expected host-name, but got " + s);
                }
                return;
            }
            case "ipv4": {
                if (!InetAddresses.isInetAddress((String)s) || s.indexOf(58) != -1) {
                    throw new ValidationException("Expected ipv4, but got " + s);
                }
                return;
            }
            case "ipv6": {
                if (!InetAddresses.isInetAddress((String)s) || s.indexOf(58) == -1) {
                    throw new ValidationException("Expected ipv6, but got " + s);
                }
                return;
            }
            case "uri": {
                try {
                    URI.create(s);
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException("Expected URI format, but got " + s, (Throwable)e);
                }
                return;
            }
        }
    }

    @Override
    @JsonProperty(value="format")
    public String getPropertyFormat() {
        if (!ValidationUtil.isEmpty(this.propertyFormat)) {
            return this.propertyFormat;
        }
        return this.format == null ? null : this.format.toString();
    }

    @Override
    public void setPropertyFormat(String propertyFormat) {
        this.propertyFormat = propertyFormat;
    }

    @Override
    public String getExample() {
        return this.example;
    }

    @Override
    public void setExample(String example) {
        this.example = example;
    }
}

