/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.ValidationException;
import org.forgerock.api.enums.ReadPolicy;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.api.jackson.CrestReadWritePoliciesSchema;
import org.forgerock.api.jackson.JacksonUtils;
import org.forgerock.api.jackson.OrderedFieldSchema;
import org.forgerock.api.jackson.RequiredFieldsSchema;
import org.forgerock.api.jackson.ValidatableSchema;
import org.forgerock.api.jackson.WithExampleSchema;
import org.forgerock.json.JsonValue;

public class CrestObjectSchema
extends ObjectSchema
implements CrestReadWritePoliciesSchema,
OrderedFieldSchema,
ValidatableSchema,
RequiredFieldsSchema,
WithExampleSchema<Map<String, Object>> {
    private static final JavaType EXAMPLE_VALUE_TYPE = JacksonUtils.OBJECT_MAPPER.getTypeFactory().constructParametrizedType(HashMap.class, Map.class, new Class[]{String.class, Object.class});
    private WritePolicy writePolicy;
    private ReadPolicy readPolicy;
    private Boolean errorOnWritePolicyFailure;
    private Boolean returnOnDemand;
    private Integer propertyOrder;
    private Set<String> requiredFields;
    private Map<String, Object> example;

    @Override
    public WritePolicy getWritePolicy() {
        return this.writePolicy;
    }

    @Override
    public void setWritePolicy(WritePolicy policy) {
        this.writePolicy = policy;
    }

    @Override
    public ReadPolicy getReadPolicy() {
        return this.readPolicy;
    }

    @Override
    public void setReadPolicy(ReadPolicy readPolicy) {
        this.readPolicy = readPolicy;
    }

    @Override
    public Boolean getErrorOnWritePolicyFailure() {
        return this.errorOnWritePolicyFailure;
    }

    @Override
    public void setErrorOnWritePolicyFailure(Boolean errorOnWritePolicyFailure) {
        this.errorOnWritePolicyFailure = errorOnWritePolicyFailure;
    }

    @Override
    public Boolean getReturnOnDemand() {
        return this.returnOnDemand;
    }

    @Override
    public void setReturnOnDemand(Boolean returnOnDemand) {
        this.returnOnDemand = returnOnDemand;
    }

    @Override
    public Integer getPropertyOrder() {
        return this.propertyOrder;
    }

    @Override
    public void setPropertyOrder(Integer order) {
        this.propertyOrder = order;
    }

    @Override
    public void validate(JsonValue object) throws ValidationException {
        Object schema;
        if (!object.isMap()) {
            throw new ValidationException("Object expected, but got: " + object.getObject());
        }
        HashMap propertyValues = new HashMap((Map)object.getObject());
        Iterator propertyIterator = propertyValues.entrySet().iterator();
        HashMap patternProperties = new HashMap();
        if (this.getPatternProperties() != null) {
            for (Map.Entry pattern : this.getPatternProperties().entrySet()) {
                patternProperties.put(Pattern.compile((String)pattern.getKey()), pattern.getValue());
            }
        }
        while (propertyIterator.hasNext()) {
            Map.Entry property = propertyIterator.next();
            boolean validated = false;
            if (this.getProperties().containsKey(property.getKey())) {
                schema = (JsonSchema)this.getProperties().get(property.getKey());
                if (schema instanceof ValidatableSchema && !"reference".equals(property.getKey())) {
                    ((ValidatableSchema)schema).validate(JsonValue.json(property.getValue()));
                }
                validated = true;
            }
            for (Map.Entry pattern : patternProperties.entrySet()) {
                if (!((Pattern)pattern.getKey()).matcher((CharSequence)property.getKey()).matches()) continue;
                if (pattern.getValue() instanceof ValidatableSchema) {
                    ((ValidatableSchema)pattern.getValue()).validate(JsonValue.json(property.getValue()));
                }
                validated = true;
            }
            if (!validated) continue;
            propertyIterator.remove();
        }
        ObjectSchema.AdditionalProperties additionalProperties = this.getAdditionalProperties();
        if (additionalProperties != null) {
            if (additionalProperties instanceof ObjectSchema.NoAdditionalProperties && !propertyValues.isEmpty()) {
                throw new ValidationException("Did not expect additional properties, but got " + propertyValues);
            }
            ObjectSchema.SchemaAdditionalProperties schemaAdditionalProperties = (ObjectSchema.SchemaAdditionalProperties)additionalProperties;
            if (schemaAdditionalProperties.getJsonSchema() instanceof ValidatableSchema) {
                schema = (ValidatableSchema)schemaAdditionalProperties.getJsonSchema();
                for (Object value : propertyValues.values()) {
                    schema.validate(JsonValue.json(value));
                }
            }
        }
    }

    @JsonProperty(value="readOnly")
    public Boolean getReadonly() {
        return super.getReadonly();
    }

    @Override
    @JsonProperty(value="required")
    public Set<String> getRequiredFields() {
        return this.requiredFields;
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    @Override
    public Map<String, Object> getExample() {
        Map<String, Object> example = this.example;
        if (example == null) {
            example = new HashMap<String, Object>();
            for (Map.Entry property : this.getProperties().entrySet()) {
                Object propertyExample;
                if (!(property.getValue() instanceof WithExampleSchema) || (propertyExample = ((WithExampleSchema)property.getValue()).getExample()) == null) continue;
                example.put((String)property.getKey(), propertyExample);
            }
            if (example.isEmpty()) {
                example = null;
            }
        }
        return example;
    }

    @Override
    public void setExample(String example) throws IOException {
        this.example = (Map)JacksonUtils.OBJECT_MAPPER.readValue(example, EXAMPLE_VALUE_TYPE);
    }
}

