/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwt;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.exceptions.JwtRuntimeException;
import org.forgerock.json.jose.utils.Utils;

public abstract class JWObject {
    private final JsonValue jsonValue = new JsonValue(new LinkedHashMap());

    protected void checkValueIsOfType(Object value, Class<?> requiredClazz) {
        if (!requiredClazz.isAssignableFrom(value.getClass())) {
            throw new JwtRuntimeException("Value is not of the required type. Required, " + requiredClazz.getName() + ", actual, " + value.getClass().getName());
        }
    }

    protected void checkListValuesAreOfType(List<?> value, Class<?> requiredClazz) {
        if (value.size() > 0) {
            this.checkValueIsOfType(value.get(0), requiredClazz);
        }
    }

    protected boolean isValueOfType(Object value, Class<?> requiredClazz) {
        return requiredClazz.isAssignableFrom(value.getClass());
    }

    public void put(String key, Object value) {
        if (value != null) {
            this.jsonValue.put(key, value);
        } else if (this.jsonValue.isDefined(key)) {
            this.jsonValue.remove(key);
        }
    }

    public JsonValue get(String key) {
        return this.jsonValue.get(key);
    }

    public boolean isDefined(String key) {
        return this.jsonValue.isDefined(key);
    }

    public Set<String> keys() {
        return this.jsonValue.keys();
    }

    Map<String, Object> getAll() {
        return this.jsonValue.asMap();
    }

    public String toString() {
        return Utils.writeJsonObject(this.jsonValue.asMap());
    }
}

