/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jws;

import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.forgerock.json.jose.jws.handlers.ECDSASigningHandler;
import org.forgerock.json.jose.jws.handlers.HmacSigningHandler;
import org.forgerock.json.jose.jws.handlers.NOPSigningHandler;
import org.forgerock.json.jose.jws.handlers.RSASigningHandler;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.util.SignatureUtil;

public class SigningManager {
    private final SignatureUtil signatureUtil = SignatureUtil.getInstance();

    public SigningHandler newNopSigningHandler() {
        return new NOPSigningHandler();
    }

    public SigningHandler newHmacSigningHandler(byte[] sharedSecret) {
        return new HmacSigningHandler(sharedSecret);
    }

    public SigningHandler newRsaSigningHandler(Key key) {
        return new RSASigningHandler(key, this.signatureUtil);
    }

    public SigningHandler newEcdsaSigningHandler(ECPrivateKey key) {
        return new ECDSASigningHandler(key);
    }

    public SigningHandler newEcdsaVerificationHandler(ECPublicKey key) {
        return new ECDSASigningHandler(key);
    }
}

