/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import org.forgerock.json.JsonException;

public enum KeyType {
    RSA("RSA"),
    EC("EC"),
    OCT("oct");

    private String value = null;

    private KeyType(String value) {
        this.value = value;
    }

    public String value() {
        return this.toString();
    }

    public static KeyType getKeyType(String keyType) {
        if (keyType == null || keyType.isEmpty()) {
            return null;
        }
        try {
            return KeyType.valueOf(keyType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid key type");
        }
    }

    public String toString() {
        return this.value;
    }
}

