/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwt.JWObject;

public class JWKSet
extends JWObject {
    public JWKSet() {
    }

    public JWKSet(JWK jwk) {
        if (jwk == null) {
            throw new JsonException("JWK must not be null");
        }
        this.put("keys", jwk);
    }

    public JWKSet(JsonValue jwk) {
        if (jwk == null) {
            throw new JsonException("JWK must not be null");
        }
        this.put("keys", jwk);
    }

    public JWKSet(List<JWK> jwkList) {
        if (jwkList == null) {
            throw new JsonException("The list cant be null");
        }
        this.put("keys", jwkList);
    }

    public List<JWK> getJWKsAsList() {
        LinkedList<JWK> listOfJWKs = new LinkedList<JWK>();
        JsonValue jwks = this.get("keys");
        Iterator i = jwks.iterator();
        while (i.hasNext()) {
            listOfJWKs.add(JWK.parse((JsonValue)i.next()));
        }
        return listOfJWKs;
    }

    public JsonValue getJWKsAsJsonValue() {
        return this.get("keys");
    }

    protected static JsonValue toJsonValue(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return new JsonValue(mapper.readValue(json, Map.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", (Throwable)e);
        }
    }

    public static JWKSet parse(String json) {
        JsonValue jwkSet = new JsonValue((Object)JWKSet.toJsonValue(json));
        return JWKSet.parse(jwkSet);
    }

    public static JWKSet parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Cant parse JWKSet. No json data.");
        }
        return new JWKSet(json.get("keys"));
    }

    public String toJsonString() {
        return super.toString();
    }
}

