/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.exceptions.JweEncryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweAlgorithm;
import org.forgerock.json.jose.jwe.JweAlgorithmType;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.ContentEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.EncryptionHandler;
import org.forgerock.util.Reject;

public final class RSAEncryptionHandler
implements EncryptionHandler {
    private static final OAEPParameterSpec RSA_OAEP_256_PARAMS = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
    private final EncryptionMethod encryptionMethod;
    private final ContentEncryptionHandler contentEncryptionHandler;
    private final JweAlgorithm jweAlgorithm;
    private final AlgorithmParameterSpec parameterSpec;

    public RSAEncryptionHandler(EncryptionMethod encryptionMethod, JweAlgorithm jweAlgorithm) {
        this.encryptionMethod = (EncryptionMethod)((Object)Reject.checkNotNull((Object)((Object)encryptionMethod), (String)"EncryptionMethod must not be null"));
        this.jweAlgorithm = (JweAlgorithm)Reject.checkNotNull((Object)jweAlgorithm, (String)"JweAlgorithm must not be null");
        Reject.ifFalse((jweAlgorithm.getAlgorithmType() == JweAlgorithmType.RSA ? 1 : 0) != 0, (String)"JweAlgorithm type must be RSA");
        this.contentEncryptionHandler = ContentEncryptionHandler.getInstance(encryptionMethod);
        this.parameterSpec = jweAlgorithm == JweAlgorithm.RSA_OAEP_256 ? RSA_OAEP_256_PARAMS : null;
    }

    @Override
    public Key getContentEncryptionKey() {
        return this.contentEncryptionHandler.generateEncryptionKey();
    }

    @Override
    public byte[] generateJWEEncryptedKey(Key key, Key contentEncryptionKey) {
        return this.encryptKey((RSAPublicKey)key, contentEncryptionKey);
    }

    @Override
    public byte[] generateInitialisationVector() {
        return this.contentEncryptionHandler.generateInitialisationVector();
    }

    @Override
    public JweEncryption encryptPlaintext(Key contentEncryptionKey, byte[] initialisationVector, byte[] plaintext, byte[] additionalAuthenticatedData) {
        return this.contentEncryptionHandler.encrypt(contentEncryptionKey, initialisationVector, plaintext, additionalAuthenticatedData);
    }

    @Override
    public Key decryptContentEncryptionKey(Key key, byte[] encryptedContentEncryptionKey) {
        try {
            Cipher cipher = Cipher.getInstance(this.jweAlgorithm.getAlgorithm());
            cipher.init(4, key, this.parameterSpec);
            return cipher.unwrap(encryptedContentEncryptionKey, this.encryptionMethod.getEncryptionAlgorithm(), 3);
        }
        catch (GeneralSecurityException e) {
            throw new JweDecryptionException();
        }
    }

    @Override
    public byte[] decryptCiphertext(Key contentEncryptionKey, byte[] initialisationVector, byte[] ciphertext, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        return this.contentEncryptionHandler.decrypt(contentEncryptionKey, initialisationVector, new JweEncryption(ciphertext, authenticationTag), additionalAuthenticatedData);
    }

    private byte[] encryptKey(RSAPublicKey keyEncryptionKey, Key contentKey) {
        try {
            Cipher cipher = Cipher.getInstance(this.jweAlgorithm.getAlgorithm());
            cipher.init(3, (Key)keyEncryptionKey, this.parameterSpec);
            return cipher.wrap(contentKey);
        }
        catch (GeneralSecurityException e) {
            throw new JweEncryptionException(e);
        }
    }
}

