/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.exceptions.JweEncryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.ContentEncryptionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.EncryptionHandler;

public final class AESKeyWrapEncryptionHandler
implements EncryptionHandler {
    private final ContentEncryptionHandler contentEncryptionHandler;
    private final EncryptionMethod encryptionMethod;

    public AESKeyWrapEncryptionHandler(EncryptionMethod method) {
        this.contentEncryptionHandler = ContentEncryptionHandler.getInstance(method);
        this.encryptionMethod = method;
    }

    @Override
    public Key getContentEncryptionKey() {
        return this.contentEncryptionHandler.generateEncryptionKey();
    }

    @Override
    public byte[] generateJWEEncryptedKey(Key key, Key contentEncryptionKey) {
        try {
            Cipher cipher = Cipher.getInstance("AESWrap");
            cipher.init(3, key);
            return cipher.wrap(contentEncryptionKey);
        }
        catch (GeneralSecurityException e) {
            throw new JweEncryptionException(e);
        }
    }

    @Override
    public byte[] generateInitialisationVector() {
        return this.contentEncryptionHandler.generateInitialisationVector();
    }

    @Override
    public JweEncryption encryptPlaintext(Key contentEncryptionKey, byte[] initialisationVector, byte[] plaintext, byte[] additionalAuthenticatedData) {
        return this.contentEncryptionHandler.encrypt(contentEncryptionKey, initialisationVector, plaintext, additionalAuthenticatedData);
    }

    @Override
    public Key decryptContentEncryptionKey(Key key, byte[] encryptedContentEncryptionKey) {
        try {
            Cipher cipher = Cipher.getInstance("AESWrap");
            cipher.init(4, key);
            return cipher.unwrap(encryptedContentEncryptionKey, this.encryptionMethod.getEncryptionAlgorithm(), 3);
        }
        catch (GeneralSecurityException e) {
            throw new JweDecryptionException();
        }
    }

    @Override
    public byte[] decryptCiphertext(Key contentEncryptionKey, byte[] initialisationVector, byte[] ciphertext, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        return this.contentEncryptionHandler.decrypt(contentEncryptionKey, initialisationVector, new JweEncryption(ciphertext, authenticationTag), additionalAuthenticatedData);
    }
}

