/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.GCMParameterSpec;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.exceptions.JweEncryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.ContentEncryptionHandler;

final class AESGCMContentEncryptionHandler
extends ContentEncryptionHandler {
    private static final Logger LOGGER = Logger.getLogger(AESGCMContentEncryptionHandler.class.getName());
    private static final int TAG_LENGTH = 128;
    private static final int IV_LENGTH = 12;
    private final EncryptionMethod encryptionMethod;

    AESGCMContentEncryptionHandler(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    @Override
    JweEncryption encrypt(Key key, byte[] iv, byte[] plainText, byte[] additionalData) {
        try {
            Cipher cipher = Cipher.getInstance(this.encryptionMethod.getTransformation());
            cipher.init(1, key, new GCMParameterSpec(128, iv));
            cipher.updateAAD(additionalData);
            byte[] cipherText = cipher.doFinal(plainText);
            int tagStart = cipherText.length - 16;
            return new JweEncryption(Arrays.copyOfRange(cipherText, 0, tagStart), Arrays.copyOfRange(cipherText, tagStart, cipherText.length));
        }
        catch (GeneralSecurityException ex) {
            throw new JweEncryptionException(ex);
        }
    }

    @Override
    byte[] decrypt(Key key, byte[] iv, JweEncryption cipherText, byte[] additionalData) {
        try {
            Cipher cipher = Cipher.getInstance(this.encryptionMethod.getTransformation());
            cipher.init(2, key, new GCMParameterSpec(128, iv));
            cipher.updateAAD(additionalData);
            cipher.update(cipherText.getCiphertext());
            return cipher.doFinal(cipherText.getAuthenticationTag());
        }
        catch (GeneralSecurityException ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Decryption failed: " + ex, ex);
            }
            throw new JweDecryptionException();
        }
    }

    @Override
    Key generateEncryptionKey() {
        try {
            KeyGenerator encKeyGenerator = KeyGenerator.getInstance(this.encryptionMethod.getEncryptionAlgorithm());
            encKeyGenerator.init(this.encryptionMethod.getKeySize());
            return encKeyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new JweEncryptionException("Unsupported Encryption Algorithm, " + this.encryptionMethod.getEncryptionAlgorithm(), e);
        }
    }

    @Override
    int getIVByteLength() {
        return 12;
    }
}

