/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.security.Key;
import org.forgerock.json.jose.builders.EncryptedJwtBuilder;
import org.forgerock.json.jose.builders.JweHeaderBuilder;
import org.forgerock.json.jose.builders.SignedJwtBuilderImpl;
import org.forgerock.json.jose.builders.SignedThenEncryptedJwtHeaderBuilder;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jwe.SignedThenEncryptedJwt;
import org.forgerock.json.jose.jws.SignedJwt;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.json.jose.jwt.JwtType;
import org.forgerock.util.Reject;

public class SignedThenEncryptedJwtBuilder
extends EncryptedJwtBuilder {
    private SignedJwtBuilderImpl signedJwtBuilder;
    private final SignedThenEncryptedJwtHeaderBuilder headerBuilder;

    SignedThenEncryptedJwtBuilder(SignedJwtBuilderImpl signedJwtBuilder, Key publicKey) {
        super(publicKey);
        this.signedJwtBuilder = (SignedJwtBuilderImpl)Reject.checkNotNull((Object)signedJwtBuilder);
        this.headerBuilder = new SignedThenEncryptedJwtHeaderBuilder(this);
    }

    @Override
    public SignedThenEncryptedJwt asJwt() {
        JweHeader header = (JweHeader)((JweHeaderBuilder)this.headerBuilder.cty(JwtType.JWT.toString())).build();
        SignedJwt signedJwt = this.signedJwtBuilder.asJwt();
        return new SignedThenEncryptedJwt(header, signedJwt, this.publicKey);
    }

    @Override
    public SignedThenEncryptedJwtBuilder claims(JwtClaimsSet claims) {
        this.signedJwtBuilder = this.signedJwtBuilder.claims(claims);
        return this;
    }

    @Override
    public JweHeaderBuilder<SignedThenEncryptedJwtBuilder> headers() {
        return this.headerBuilder;
    }
}

