/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.server.config.server.JEBackendCfg;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.opends.messages.BackendMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.api.Backupable;
import org.opends.server.api.DiskSpaceMonitorHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.JEMonitor;
import org.opends.server.backends.pluggable.spi.AccessMode;
import org.opends.server.backends.pluggable.spi.Cursor;
import org.opends.server.backends.pluggable.spi.EmptyCursor;
import org.opends.server.backends.pluggable.spi.Importer;
import org.opends.server.backends.pluggable.spi.ReadOnlyStorageException;
import org.opends.server.backends.pluggable.spi.ReadOperation;
import org.opends.server.backends.pluggable.spi.ReadableTransaction;
import org.opends.server.backends.pluggable.spi.SequentialCursor;
import org.opends.server.backends.pluggable.spi.Storage;
import org.opends.server.backends.pluggable.spi.StorageRuntimeException;
import org.opends.server.backends.pluggable.spi.StorageStatus;
import org.opends.server.backends.pluggable.spi.StorageUtils;
import org.opends.server.backends.pluggable.spi.TreeName;
import org.opends.server.backends.pluggable.spi.UpdateFunction;
import org.opends.server.backends.pluggable.spi.WriteOperation;
import org.opends.server.backends.pluggable.spi.WriteableTransaction;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.MemoryQuota;
import org.opends.server.core.ServerContext;
import org.opends.server.extensions.DiskSpaceMonitor;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.BackupManager;
import org.opends.server.util.StaticUtils;

public final class JEStorage
implements Storage,
Backupable,
ConfigurationChangeListener<JEBackendCfg>,
DiskSpaceMonitorHandler {
    private static final int IMPORT_DB_CACHE_SIZE = 0x2000000;
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final TransactionConfig TXN_READ_COMMITTED = new TransactionConfig().setReadCommitted(true);
    private final ServerContext serverContext;
    private final File backendDirectory;
    private JEBackendCfg config;
    private AccessMode accessMode;
    private Environment env;
    private EnvironmentConfig envConfig;
    private MemoryQuota memQuota;
    private JEMonitor monitor;
    private DiskSpaceMonitor diskMonitor;
    private StorageStatus storageStatus = StorageStatus.working();
    private final ConcurrentMap<TreeName, Database> trees = new ConcurrentHashMap<TreeName, Database>();

    private WriteableTransaction newWriteableTransaction(Transaction txn) {
        if (this.env == null) {
            return new ReadOnlyEmptyTransactionImpl();
        }
        WriteableTransactionImpl writeableStorage = new WriteableTransactionImpl(txn);
        return this.accessMode.isWriteable() ? writeableStorage : new ReadOnlyTransactionImpl(writeableStorage);
    }

    JEStorage(JEBackendCfg cfg, ServerContext serverContext) throws ConfigException {
        this.serverContext = serverContext;
        this.backendDirectory = JEStorage.getBackendDirectory(cfg);
        this.config = cfg;
        cfg.addJEChangeListener((ConfigurationChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getOrOpenTree0(Map<TreeName, Database> trees, TreeName treeName) {
        Database tree = trees.get(treeName);
        if (tree == null) {
            Map<TreeName, Database> map = trees;
            synchronized (map) {
                tree = trees.get(treeName);
                if (tree == null) {
                    tree = this.env.openDatabase(null, JEStorage.toDatabaseName(treeName), this.dbConfig());
                    trees.put(treeName, tree);
                }
            }
        }
        return tree;
    }

    private void buildConfiguration(AccessMode accessMode, boolean isImport) throws ConfigException {
        this.accessMode = accessMode;
        if (isImport) {
            this.envConfig = new EnvironmentConfig();
            this.envConfig.setTransactional(false).setAllowCreate(true).setLockTimeout(0L, TimeUnit.SECONDS).setTxnTimeout(0L, TimeUnit.SECONDS).setCacheSize(0x2000000L).setDurability(Durability.COMMIT_NO_SYNC).setConfigParam("je.cleaner.minUtilization", String.valueOf(this.config.getDBCleanerMinUtilization())).setConfigParam("je.log.fileMax", String.valueOf(this.config.getDBLogFileMax()));
        } else {
            this.envConfig = ConfigurableEnvironment.parseConfigEntry(this.config);
        }
        this.diskMonitor = this.serverContext.getDiskSpaceMonitor();
        this.memQuota = this.serverContext.getMemoryQuota();
        if (this.config.getDBCacheSize() > 0L) {
            this.memQuota.acquireMemory(this.config.getDBCacheSize());
        } else {
            this.memQuota.acquireMemory(this.memQuota.memPercentToBytes(this.config.getDBCachePercent()));
        }
    }

    private DatabaseConfig dbConfig() {
        boolean isImport = !this.envConfig.getTransactional();
        return new DatabaseConfig().setKeyPrefixing(true).setAllowCreate(true).setTransactional(!isImport).setDeferredWrite(isImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConcurrentMap<TreeName, Database> concurrentMap = this.trees;
        synchronized (concurrentMap) {
            Utils.closeSilently(this.trees.values());
            this.trees.clear();
        }
        if (this.env != null) {
            DirectoryServer.deregisterMonitorProvider((MonitorProvider)this.monitor);
            this.monitor = null;
            try {
                this.env.close();
                this.env = null;
            }
            catch (DatabaseException e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.memQuota != null) {
            if (this.config.getDBCacheSize() > 0L) {
                this.memQuota.releaseMemory(this.config.getDBCacheSize());
            } else {
                this.memQuota.releaseMemory(this.memQuota.memPercentToBytes(this.config.getDBCachePercent()));
            }
        }
        this.config.removeJEChangeListener((ConfigurationChangeListener)this);
        this.envConfig = null;
        if (this.diskMonitor != null) {
            this.diskMonitor.deregisterMonitoredDirectory(this.getDirectory(), (DiskSpaceMonitorHandler)this);
        }
    }

    public void open(AccessMode accessMode) throws ConfigException, StorageRuntimeException {
        Reject.ifNull((Object)accessMode, (String)"accessMode must not be null");
        if (this.isBackendIncomplete(accessMode)) {
            this.envConfig = new EnvironmentConfig();
            this.envConfig.setAllowCreate(false).setTransactional(false);
            return;
        }
        this.buildConfiguration(accessMode, false);
        this.open0();
    }

    private boolean isBackendIncomplete(AccessMode accessMode) {
        return !accessMode.isWriteable() && (!this.backendDirectory.exists() || this.backendDirectoryIncomplete());
    }

    private boolean backendDirectoryIncomplete() {
        try {
            return !this.getFilesToBackup().hasNext();
        }
        catch (DirectoryException ignored) {
            return true;
        }
    }

    private void open0() throws ConfigException {
        StorageUtils.setupStorageFiles((File)this.backendDirectory, (String)this.config.getDBDirectoryPermissions(), (DN)this.config.dn());
        try {
            if (this.env != null) {
                throw new IllegalStateException("Database is already open, either the backend is enabled or an import is currently running.");
            }
            this.env = new Environment(this.backendDirectory, this.envConfig);
            this.monitor = new JEMonitor(this.config.getBackendId() + " JE Database", this.env);
            DirectoryServer.registerMonitorProvider((MonitorProvider)this.monitor);
        }
        catch (DatabaseException e) {
            throw new StorageRuntimeException((Throwable)e);
        }
        this.registerMonitoredDirectory(this.config);
    }

    public <T> T read(ReadOperation<T> operation) throws Exception {
        try {
            return (T)operation.run((ReadableTransaction)this.newWriteableTransaction(null));
        }
        catch (StorageRuntimeException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    public Importer startImport() throws ConfigException, StorageRuntimeException {
        this.buildConfiguration(AccessMode.READ_WRITE, true);
        this.open0();
        return new ImporterImpl();
    }

    private static String toDatabaseName(TreeName treeName) {
        return treeName.toString();
    }

    public void write(WriteOperation operation) throws Exception {
        Transaction txn = this.beginTransaction();
        try {
            operation.run(this.newWriteableTransaction(txn));
            this.commit(txn);
        }
        catch (StorageRuntimeException e) {
            if (e.getCause() != null) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        finally {
            this.abort(txn);
        }
    }

    private Transaction beginTransaction() {
        if (this.envConfig.getTransactional()) {
            Transaction txn = this.env.beginTransaction(null, TXN_READ_COMMITTED);
            logger.trace("beginTransaction txnid=%d", (Object)txn.getId());
            return txn;
        }
        return null;
    }

    private void commit(Transaction txn) {
        if (txn != null) {
            txn.commit();
            logger.trace("commit txnid=%d", (Object)txn.getId());
        }
    }

    private void abort(Transaction txn) {
        if (txn != null) {
            txn.abort();
            logger.trace("abort txnid=%d", (Object)txn.getId());
        }
    }

    public boolean supportsBackupAndRestore() {
        return true;
    }

    public File getDirectory() {
        return JEStorage.getBackendDirectory(this.config);
    }

    private static File getBackendDirectory(JEBackendCfg cfg) {
        return StorageUtils.getDBDirectory((String)cfg.getDBDirectory(), (String)cfg.getBackendId());
    }

    public ListIterator<Path> getFilesToBackup() throws DirectoryException {
        return new JELogFilesIterator(this.getDirectory(), this.config.getBackendId());
    }

    public Path beforeRestore() throws DirectoryException {
        return null;
    }

    public boolean isDirectRestore() {
        return false;
    }

    public void afterRestore(Path restoreDirectory, Path saveDirectory) throws DirectoryException {
        File targetDirectory = this.getDirectory();
        StaticUtils.recursiveDelete((File)targetDirectory);
        try {
            Files.move(restoreDirectory, targetDirectory.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LocalizableMessage msg = UtilityMessages.ERR_CANNOT_RENAME_RESTORE_DIRECTORY.get((Object)restoreDirectory, (Object)targetDirectory.getPath());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), msg);
        }
    }

    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        new BackupManager(this.config.getBackendId()).createBackup((Backupable)this, backupConfig);
    }

    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        new BackupManager(this.config.getBackendId()).removeBackup(backupDirectory, backupID);
    }

    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        new BackupManager(this.config.getBackendId()).restoreBackup((Backupable)this, restoreConfig);
    }

    public Set<TreeName> listTrees() {
        if (this.env == null) {
            return Collections.emptySet();
        }
        try {
            List treeNames = this.env.getDatabaseNames();
            HashSet<TreeName> results = new HashSet<TreeName>(treeNames.size());
            for (String treeName : treeNames) {
                results.add(TreeName.valueOf((String)treeName));
            }
            return results;
        }
        catch (DatabaseException e) {
            throw new StorageRuntimeException((Throwable)e);
        }
    }

    public boolean isConfigurationChangeAcceptable(JEBackendCfg newCfg, List<LocalizableMessage> unacceptableReasons) {
        long oldSize;
        long newSize = this.computeSize(newCfg);
        return (newSize <= (oldSize = this.computeSize(this.config)) || this.memQuota.isMemoryAvailable(newSize - oldSize)) && JEStorage.checkConfigurationDirectories(newCfg, unacceptableReasons);
    }

    private long computeSize(JEBackendCfg cfg) {
        return cfg.getDBCacheSize() > 0L ? cfg.getDBCacheSize() : this.memQuota.memPercentToBytes(cfg.getDBCachePercent());
    }

    static boolean isConfigurationAcceptable(JEBackendCfg cfg, List<LocalizableMessage> unacceptableReasons, ServerContext context) {
        if (context != null) {
            MemoryQuota memQuota = context.getMemoryQuota();
            if (cfg.getDBCacheSize() > 0L && !memQuota.isMemoryAvailable(cfg.getDBCacheSize())) {
                unacceptableReasons.add(BackendMessages.ERR_BACKEND_CONFIG_CACHE_SIZE_GREATER_THAN_JVM_HEAP.get((Object)cfg.getDBCacheSize(), (Object)memQuota.getAvailableMemory()));
                return false;
            }
            if (!memQuota.isMemoryAvailable(memQuota.memPercentToBytes(cfg.getDBCachePercent()))) {
                unacceptableReasons.add(BackendMessages.ERR_BACKEND_CONFIG_CACHE_PERCENT_GREATER_THAN_JVM_HEAP.get((Object)cfg.getDBCachePercent(), (Object)memQuota.memBytesToPercent(memQuota.getAvailableMemory())));
                return false;
            }
        }
        return JEStorage.checkConfigurationDirectories(cfg, unacceptableReasons);
    }

    private static boolean checkConfigurationDirectories(JEBackendCfg cfg, List<LocalizableMessage> unacceptableReasons) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        File newBackendDirectory = JEStorage.getBackendDirectory(cfg);
        StorageUtils.checkDBDirExistsOrCanCreate((File)newBackendDirectory, (ConfigChangeResult)ccr, (boolean)true);
        StorageUtils.checkDBDirPermissions((String)cfg.getDBDirectoryPermissions(), (DN)cfg.dn(), (ConfigChangeResult)ccr);
        if (!ccr.getMessages().isEmpty()) {
            unacceptableReasons.addAll(ccr.getMessages());
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(JEBackendCfg cfg) {
        ConfigChangeResult ccr = new ConfigChangeResult();
        try {
            File newBackendDirectory = JEStorage.getBackendDirectory(cfg);
            if (!cfg.getDBDirectory().equals(this.config.getDBDirectory())) {
                StorageUtils.checkDBDirExistsOrCanCreate((File)newBackendDirectory, (ConfigChangeResult)ccr, (boolean)false);
                if (!ccr.getMessages().isEmpty()) {
                    return ccr;
                }
                ccr.setAdminActionRequired(true);
                ccr.addMessage(BackendMessages.NOTE_CONFIG_DB_DIR_REQUIRES_RESTART.get((Object)this.config.getDBDirectory(), (Object)cfg.getDBDirectory()));
            }
            if (!cfg.getDBDirectoryPermissions().equalsIgnoreCase(this.config.getDBDirectoryPermissions()) || !cfg.getDBDirectory().equals(this.config.getDBDirectory())) {
                StorageUtils.checkDBDirPermissions((String)cfg.getDBDirectoryPermissions(), (DN)cfg.dn(), (ConfigChangeResult)ccr);
                if (!ccr.getMessages().isEmpty()) {
                    return ccr;
                }
                StorageUtils.setDBDirPermissions((File)newBackendDirectory, (String)cfg.getDBDirectoryPermissions(), (DN)cfg.dn(), (ConfigChangeResult)ccr);
                if (!ccr.getMessages().isEmpty()) {
                    return ccr;
                }
            }
            this.registerMonitoredDirectory(cfg);
            this.config = cfg;
        }
        catch (Exception e) {
            StorageUtils.addErrorMessage((ConfigChangeResult)ccr, (LocalizableMessage)LocalizableMessage.raw((CharSequence)StaticUtils.stackTraceToSingleLineString((Throwable)e), (Object[])new Object[0]));
        }
        return ccr;
    }

    private void registerMonitoredDirectory(JEBackendCfg cfg) {
        this.diskMonitor.registerMonitoredDirectory(cfg.getBackendId() + " backend", this.getDirectory(), cfg.getDiskLowThreshold(), cfg.getDiskFullThreshold(), (DiskSpaceMonitorHandler)this);
    }

    public void removeStorageFiles() throws StorageRuntimeException {
        StorageUtils.removeStorageFiles((File)this.backendDirectory);
    }

    public StorageStatus getStorageStatus() {
        return this.storageStatus;
    }

    public void diskFullThresholdReached(File directory, long thresholdInBytes) {
        this.storageStatus = StorageUtils.statusWhenDiskSpaceFull((File)directory, (long)thresholdInBytes, (String)this.config.getBackendId());
    }

    public void diskLowThresholdReached(File directory, long thresholdInBytes) {
        this.storageStatus = StorageUtils.statusWhenDiskSpaceLow((File)directory, (long)thresholdInBytes, (String)this.config.getBackendId());
    }

    public void diskSpaceRestored(File directory, long lowThresholdInBytes, long fullThresholdInBytes) {
        this.storageStatus = StorageStatus.working();
    }

    private static void setData(DatabaseEntry dbEntry, ByteSequence bs) {
        dbEntry.setData(bs != null ? bs.toByteArray() : null);
    }

    private static DatabaseEntry db(ByteSequence bs) {
        return new DatabaseEntry(bs != null ? bs.toByteArray() : null);
    }

    private static ByteString valueToBytes(DatabaseEntry dbValue, boolean isDefined) {
        if (isDefined) {
            return ByteString.wrap((byte[])dbValue.getData());
        }
        return null;
    }

    private static class JELogFileFilter
    implements FileFilter {
        private final String latestFilename;
        private final long latestFileSize;

        JELogFileFilter(String latestFilename, long latestFileSize) {
            this.latestFilename = latestFilename;
            this.latestFileSize = latestFileSize;
        }

        JELogFileFilter() {
            this("", 0L);
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            int cmp = name.compareTo(this.latestFilename);
            return name.endsWith(".jdb") && (cmp > 0 || cmp == 0 && file.length() > this.latestFileSize);
        }
    }

    static class JELogFilesIterator
    implements ListIterator<Path> {
        private final File rootDirectory;
        private final String backendID;
        private ListIterator<Path> iterator;
        private List<Path> files;
        private String lastFileName = "";
        private long lastFileSize;

        JELogFilesIterator(File rootDirectory, String backendID) throws DirectoryException {
            this.rootDirectory = rootDirectory;
            this.backendID = backendID;
            this.setFiles(BackupManager.getFiles((File)rootDirectory, (FileFilter)new JELogFileFilter(), (String)backendID));
        }

        private void setFiles(List<Path> files) {
            this.files = files;
            Collections.sort(files);
            if (!files.isEmpty()) {
                Path lastFile = files.get(files.size() - 1);
                this.lastFileName = lastFile.getFileName().toString();
                this.lastFileSize = lastFile.toFile().length();
            }
            this.iterator = files.listIterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.iterator.hasNext();
            if (!hasNext && !this.files.isEmpty()) {
                try {
                    List allFiles = BackupManager.getFiles((File)this.rootDirectory, (FileFilter)new JELogFileFilter(), (String)this.backendID);
                    ArrayList<Path> compare = new ArrayList<Path>(this.files);
                    compare.removeAll(allFiles);
                    if (!compare.isEmpty()) {
                        List newFiles = BackupManager.getFiles((File)this.rootDirectory, (FileFilter)new JELogFileFilter(this.lastFileName, this.lastFileSize), (String)this.backendID);
                        logger.info(BackendMessages.NOTE_JEB_BACKUP_CLEANER_ACTIVITY.get((Object)newFiles.size()));
                        if (!newFiles.isEmpty()) {
                            this.setFiles(newFiles);
                            hasNext = this.iterator.hasNext();
                        }
                    }
                }
                catch (DirectoryException e) {
                    logger.error(BackendMessages.ERR_BACKEND_LIST_FILES_TO_BACKUP.get((Object)this.backendID, (Object)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
                }
            }
            return hasNext;
        }

        @Override
        public Path next() {
            if (this.hasNext()) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public Path previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not implemented");
        }

        @Override
        public void set(Path e) {
            throw new UnsupportedOperationException("set() is not implemented");
        }

        @Override
        public void add(Path e) {
            throw new UnsupportedOperationException("add() is not implemented");
        }
    }

    private final class ReadOnlyEmptyTransactionImpl
    implements WriteableTransaction {
        private ReadOnlyEmptyTransactionImpl() {
        }

        public void openTree(TreeName name, boolean createOnDemand) {
            if (createOnDemand) {
                throw new ReadOnlyStorageException();
            }
        }

        public void deleteTree(TreeName name) {
            throw new ReadOnlyStorageException();
        }

        public void put(TreeName treeName, ByteSequence key, ByteSequence value) {
            throw new ReadOnlyStorageException();
        }

        public boolean update(TreeName treeName, ByteSequence key, UpdateFunction f) {
            throw new ReadOnlyStorageException();
        }

        public boolean delete(TreeName treeName, ByteSequence key) {
            throw new ReadOnlyStorageException();
        }

        public ByteString read(TreeName treeName, ByteSequence key) {
            return null;
        }

        public Cursor<ByteString, ByteString> openCursor(TreeName treeName) {
            return new EmptyCursor();
        }

        public long getRecordCount(TreeName treeName) {
            return 0L;
        }
    }

    private final class ReadOnlyTransactionImpl
    implements WriteableTransaction {
        private final WriteableTransactionImpl delegate;

        ReadOnlyTransactionImpl(WriteableTransactionImpl delegate) {
            this.delegate = delegate;
        }

        public ByteString read(TreeName treeName, ByteSequence key) {
            return this.delegate.read(treeName, key);
        }

        public Cursor<ByteString, ByteString> openCursor(TreeName treeName) {
            return this.delegate.openCursor(treeName);
        }

        public long getRecordCount(TreeName treeName) {
            return this.delegate.getRecordCount(treeName);
        }

        public void openTree(TreeName treeName, boolean createOnDemand) {
            if (createOnDemand) {
                throw new ReadOnlyStorageException();
            }
            this.delegate.openTree(treeName, false);
        }

        public void deleteTree(TreeName name) {
            throw new ReadOnlyStorageException();
        }

        public void put(TreeName treeName, ByteSequence key, ByteSequence value) {
            throw new ReadOnlyStorageException();
        }

        public boolean update(TreeName treeName, ByteSequence key, UpdateFunction f) {
            throw new ReadOnlyStorageException();
        }

        public boolean delete(TreeName treeName, ByteSequence key) {
            throw new ReadOnlyStorageException();
        }
    }

    private final class WriteableTransactionImpl
    implements WriteableTransaction {
        private final Transaction txn;

        private WriteableTransactionImpl(Transaction txn) {
            this.txn = txn;
        }

        private Database getOrOpenTree(TreeName treeName) {
            try {
                return JEStorage.this.getOrOpenTree0(JEStorage.this.trees, treeName);
            }
            catch (Exception e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public void put(TreeName treeName, ByteSequence key, ByteSequence value) {
            try {
                OperationStatus status = this.getOrOpenTree(treeName).put(this.txn, JEStorage.db(key), JEStorage.db(value));
                if (status != OperationStatus.SUCCESS) {
                    throw new StorageRuntimeException(this.putErrorMsg(treeName, key, value, "did not succeed: " + status));
                }
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException(this.putErrorMsg(treeName, key, value, "threw an exception"), (Throwable)e);
            }
        }

        private String putErrorMsg(TreeName treeName, ByteSequence key, ByteSequence value, String msg) {
            return "put(treeName=" + treeName + ", key=" + key + ", value=" + value + ") " + msg;
        }

        public boolean delete(TreeName treeName, ByteSequence key) {
            try {
                return this.getOrOpenTree(treeName).delete(this.txn, JEStorage.db(key)) == OperationStatus.SUCCESS;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException(this.deleteErrorMsg(treeName, key, "threw an exception"), (Throwable)e);
            }
        }

        private String deleteErrorMsg(TreeName treeName, ByteSequence key, String msg) {
            return "delete(treeName=" + treeName + ", key=" + key + ") " + msg;
        }

        public long getRecordCount(TreeName treeName) {
            try {
                return this.getOrOpenTree(treeName).count();
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public Cursor<ByteString, ByteString> openCursor(TreeName treeName) {
            try {
                return new CursorImpl(this.getOrOpenTree(treeName).openCursor(this.txn, CursorConfig.READ_COMMITTED));
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public ByteString read(TreeName treeName, ByteSequence key) {
            try {
                DatabaseEntry dbValue = new DatabaseEntry();
                boolean isDefined = this.getOrOpenTree(treeName).get(this.txn, JEStorage.db(key), dbValue, LockMode.READ_COMMITTED) == OperationStatus.SUCCESS;
                return JEStorage.valueToBytes(dbValue, isDefined);
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public boolean update(TreeName treeName, ByteSequence key, UpdateFunction f) {
            try {
                Database tree = this.getOrOpenTree(treeName);
                DatabaseEntry dbKey = JEStorage.db(key);
                DatabaseEntry dbValue = new DatabaseEntry();
                do {
                    boolean isDefined;
                    ByteString oldValue;
                    ByteSequence newValue;
                    if (Objects.equals(newValue = f.computeNewValue((ByteSequence)(oldValue = JEStorage.valueToBytes(dbValue, isDefined = tree.get(this.txn, dbKey, dbValue, LockMode.RMW) == OperationStatus.SUCCESS))), oldValue)) {
                        return false;
                    }
                    if (newValue == null) {
                        return tree.delete(this.txn, dbKey) == OperationStatus.SUCCESS;
                    }
                    JEStorage.setData(dbValue, newValue);
                    if (!isDefined) continue;
                    return tree.put(this.txn, dbKey, dbValue) == OperationStatus.SUCCESS;
                } while (tree.putNoOverwrite(this.txn, dbKey, dbValue) != OperationStatus.SUCCESS);
                return true;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public void openTree(TreeName treeName, boolean createOnDemand) {
            this.getOrOpenTree(treeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteTree(TreeName treeName) {
            try {
                ConcurrentMap concurrentMap = JEStorage.this.trees;
                synchronized (concurrentMap) {
                    Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)JEStorage.this.trees.remove(treeName)});
                    JEStorage.this.env.removeDatabase(this.txn, JEStorage.toDatabaseName(treeName));
                }
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }
    }

    private final class ImporterImpl
    implements Importer {
        private final Map<TreeName, Database> trees = new HashMap<TreeName, Database>();

        private ImporterImpl() {
        }

        private Database getOrOpenTree(TreeName treeName) {
            return JEStorage.this.getOrOpenTree0(this.trees, treeName);
        }

        public void put(TreeName treeName, ByteSequence key, ByteSequence value) {
            try {
                this.getOrOpenTree(treeName).put(null, JEStorage.db(key), JEStorage.db(value));
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public ByteString read(TreeName treeName, ByteSequence key) {
            try {
                DatabaseEntry dbValue = new DatabaseEntry();
                boolean isDefined = this.getOrOpenTree(treeName).get(null, JEStorage.db(key), dbValue, null) == OperationStatus.SUCCESS;
                return JEStorage.valueToBytes(dbValue, isDefined);
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public SequentialCursor<ByteString, ByteString> openCursor(TreeName treeName) {
            try {
                return new CursorImpl(this.getOrOpenTree(treeName).openCursor(null, new CursorConfig()));
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public void clearTree(TreeName treeName) {
            JEStorage.this.env.truncateDatabase(null, JEStorage.toDatabaseName(treeName), false);
        }

        public void close() {
            Utils.closeSilently(this.trees.values());
            this.trees.clear();
            JEStorage.this.close();
        }
    }

    private static final class CursorImpl
    implements Cursor<ByteString, ByteString> {
        private ByteString currentKey;
        private ByteString currentValue;
        private boolean isDefined;
        private final com.sleepycat.je.Cursor cursor;
        private final DatabaseEntry dbKey = new DatabaseEntry();
        private final DatabaseEntry dbValue = new DatabaseEntry();

        private CursorImpl(com.sleepycat.je.Cursor cursor) {
            this.cursor = cursor;
        }

        public void close() {
            Utils.closeSilently((Closeable[])new Closeable[]{this.cursor});
        }

        public boolean isDefined() {
            return this.isDefined;
        }

        public ByteString getKey() {
            if (this.currentKey == null) {
                this.throwIfNotSuccess();
                this.currentKey = ByteString.wrap((byte[])this.dbKey.getData());
            }
            return this.currentKey;
        }

        public ByteString getValue() {
            if (this.currentValue == null) {
                this.throwIfNotSuccess();
                this.currentValue = ByteString.wrap((byte[])this.dbValue.getData());
            }
            return this.currentValue;
        }

        public boolean next() {
            this.clearCurrentKeyAndValue();
            try {
                this.isDefined = this.cursor.getNext(this.dbKey, this.dbValue, null) == OperationStatus.SUCCESS;
                return this.isDefined;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public void delete() throws NoSuchElementException, UnsupportedOperationException {
            this.throwIfNotSuccess();
            try {
                this.cursor.delete();
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public boolean positionToKey(ByteSequence key) {
            this.clearCurrentKeyAndValue();
            JEStorage.setData(this.dbKey, key);
            try {
                this.isDefined = this.cursor.getSearchKey(this.dbKey, this.dbValue, null) == OperationStatus.SUCCESS;
                return this.isDefined;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public boolean positionToKeyOrNext(ByteSequence key) {
            this.clearCurrentKeyAndValue();
            JEStorage.setData(this.dbKey, key);
            try {
                this.isDefined = this.cursor.getSearchKeyRange(this.dbKey, this.dbValue, null) == OperationStatus.SUCCESS;
                return this.isDefined;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public boolean positionToIndex(int index) {
            this.clearCurrentKeyAndValue();
            try {
                boolean bl = this.isDefined = this.cursor.getFirst(this.dbKey, this.dbValue, null) == OperationStatus.SUCCESS;
                if (!this.isDefined) {
                    return false;
                }
                if (index == 0) {
                    return true;
                }
                long skipped = this.cursor.skipNext((long)index, this.dbKey, this.dbValue, null);
                this.isDefined = skipped == (long)index ? this.cursor.getCurrent(this.dbKey, this.dbValue, null) == OperationStatus.SUCCESS : false;
                return this.isDefined;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        public boolean positionToLastKey() {
            this.clearCurrentKeyAndValue();
            try {
                this.isDefined = this.cursor.getLast(this.dbKey, this.dbValue, null) == OperationStatus.SUCCESS;
                return this.isDefined;
            }
            catch (DatabaseException e) {
                throw new StorageRuntimeException((Throwable)e);
            }
        }

        private void clearCurrentKeyAndValue() {
            this.currentKey = null;
            this.currentValue = null;
        }

        private void throwIfNotSuccess() {
            if (!this.isDefined()) {
                throw new NoSuchElementException();
            }
        }
    }
}

