/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectOption;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.LDAPTrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.meta.TrustManagerProviderCfgDefn;
import org.forgerock.opendj.server.config.server.LDAPTrustManagerProviderCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class LDAPTrustManagerProviderCfgDefn
extends ManagedObjectDefinition<LDAPTrustManagerProviderCfgClient, LDAPTrustManagerProviderCfg> {
    private static final LDAPTrustManagerProviderCfgDefn INSTANCE = new LDAPTrustManagerProviderCfgDefn();
    private static final DNPropertyDefinition PD_BASE_DN;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_TRUST_STORE_PIN;
    private static final StringPropertyDefinition PD_TRUST_STORE_PIN_ENVIRONMENT_VARIABLE;
    private static final StringPropertyDefinition PD_TRUST_STORE_PIN_FILE;
    private static final StringPropertyDefinition PD_TRUST_STORE_PIN_PROPERTY;

    public static LDAPTrustManagerProviderCfgDefn getInstance() {
        return INSTANCE;
    }

    private LDAPTrustManagerProviderCfgDefn() {
        super("ldap-trust-manager-provider", TrustManagerProviderCfgDefn.getInstance());
    }

    @Override
    public LDAPTrustManagerProviderCfgClient createClientConfiguration(ManagedObject<? extends LDAPTrustManagerProviderCfgClient> impl) {
        return new LDAPTrustManagerProviderCfgClientImpl(impl);
    }

    @Override
    public LDAPTrustManagerProviderCfg createServerConfiguration(ServerManagedObject<? extends LDAPTrustManagerProviderCfg> impl) {
        return new LDAPTrustManagerProviderCfgServerImpl(impl);
    }

    @Override
    public Class<LDAPTrustManagerProviderCfg> getServerConfigurationClass() {
        return LDAPTrustManagerProviderCfg.class;
    }

    public DNPropertyDefinition getBaseDNPropertyDefinition() {
        return PD_BASE_DN;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return TrustManagerProviderCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getTrustStorePinPropertyDefinition() {
        return PD_TRUST_STORE_PIN;
    }

    public StringPropertyDefinition getTrustStorePinEnvironmentVariablePropertyDefinition() {
        return PD_TRUST_STORE_PIN_ENVIRONMENT_VARIABLE;
    }

    public StringPropertyDefinition getTrustStorePinFilePropertyDefinition() {
        return PD_TRUST_STORE_PIN_FILE;
    }

    public StringPropertyDefinition getTrustStorePinPropertyPropertyDefinition() {
        return PD_TRUST_STORE_PIN_PROPERTY;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = DNPropertyDefinition.createBuilder(INSTANCE, "base-dn");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "base-dn"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BASE_DN);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.LDAPTrustManagerProvider");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.TrustManagerProvider");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "trust-store-pin");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-store-pin"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_TRUST_STORE_PIN = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_STORE_PIN);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "trust-store-pin-environment-variable");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-store-pin-environment-variable"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_TRUST_STORE_PIN_ENVIRONMENT_VARIABLE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_STORE_PIN_ENVIRONMENT_VARIABLE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "trust-store-pin-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-store-pin-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_TRUST_STORE_PIN_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_STORE_PIN_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "trust-store-pin-property");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-store-pin-property"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_TRUST_STORE_PIN_PROPERTY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_STORE_PIN_PROPERTY);
        INSTANCE.registerOption(ManagedObjectOption.ADVANCED);
        INSTANCE.registerTag(Tag.valueOf("security"));
    }

    private static class LDAPTrustManagerProviderCfgServerImpl
    implements LDAPTrustManagerProviderCfg {
        private ServerManagedObject<? extends LDAPTrustManagerProviderCfg> impl;
        private final DN pBaseDN;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pTrustStorePin;
        private final String pTrustStorePinEnvironmentVariable;
        private final String pTrustStorePinFile;
        private final String pTrustStorePinProperty;

        private LDAPTrustManagerProviderCfgServerImpl(ServerManagedObject<? extends LDAPTrustManagerProviderCfg> impl) {
            this.impl = impl;
            this.pBaseDN = impl.getPropertyValue(INSTANCE.getBaseDNPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pTrustStorePin = impl.getPropertyValue(INSTANCE.getTrustStorePinPropertyDefinition());
            this.pTrustStorePinEnvironmentVariable = impl.getPropertyValue(INSTANCE.getTrustStorePinEnvironmentVariablePropertyDefinition());
            this.pTrustStorePinFile = impl.getPropertyValue(INSTANCE.getTrustStorePinFilePropertyDefinition());
            this.pTrustStorePinProperty = impl.getPropertyValue(INSTANCE.getTrustStorePinPropertyPropertyDefinition());
        }

        @Override
        public void addLDAPChangeListener(ConfigurationChangeListener<LDAPTrustManagerProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeLDAPChangeListener(ConfigurationChangeListener<LDAPTrustManagerProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<TrustManagerProviderCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<TrustManagerProviderCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public DN getBaseDN() {
            return this.pBaseDN;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getTrustStorePin() {
            return this.pTrustStorePin;
        }

        @Override
        public String getTrustStorePinEnvironmentVariable() {
            return this.pTrustStorePinEnvironmentVariable;
        }

        @Override
        public String getTrustStorePinFile() {
            return this.pTrustStorePinFile;
        }

        @Override
        public String getTrustStorePinProperty() {
            return this.pTrustStorePinProperty;
        }

        @Override
        public Class<? extends LDAPTrustManagerProviderCfg> configurationClass() {
            return LDAPTrustManagerProviderCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class LDAPTrustManagerProviderCfgClientImpl
    implements LDAPTrustManagerProviderCfgClient {
        private ManagedObject<? extends LDAPTrustManagerProviderCfgClient> impl;

        private LDAPTrustManagerProviderCfgClientImpl(ManagedObject<? extends LDAPTrustManagerProviderCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public DN getBaseDN() {
            return this.impl.getPropertyValue(INSTANCE.getBaseDNPropertyDefinition());
        }

        @Override
        public void setBaseDN(DN value) {
            this.impl.setPropertyValue(INSTANCE.getBaseDNPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getTrustStorePin() {
            return this.impl.getPropertyValue(INSTANCE.getTrustStorePinPropertyDefinition());
        }

        @Override
        public void setTrustStorePin(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustStorePinPropertyDefinition(), value);
        }

        @Override
        public String getTrustStorePinEnvironmentVariable() {
            return this.impl.getPropertyValue(INSTANCE.getTrustStorePinEnvironmentVariablePropertyDefinition());
        }

        @Override
        public void setTrustStorePinEnvironmentVariable(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustStorePinEnvironmentVariablePropertyDefinition(), value);
        }

        @Override
        public String getTrustStorePinFile() {
            return this.impl.getPropertyValue(INSTANCE.getTrustStorePinFilePropertyDefinition());
        }

        @Override
        public void setTrustStorePinFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustStorePinFilePropertyDefinition(), value);
        }

        @Override
        public String getTrustStorePinProperty() {
            return this.impl.getPropertyValue(INSTANCE.getTrustStorePinPropertyPropertyDefinition());
        }

        @Override
        public void setTrustStorePinProperty(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustStorePinPropertyPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends LDAPTrustManagerProviderCfgClient, ? extends LDAPTrustManagerProviderCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

