/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.AccessLogFilteringCriteriaCfgClient;
import org.forgerock.opendj.server.config.client.JsonFileAccessLogPublisherCfgClient;
import org.forgerock.opendj.server.config.client.LogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.client.LogRotationPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.AccessLogPublisherCfgDefn;
import org.forgerock.opendj.server.config.server.AccessLogFilteringCriteriaCfg;
import org.forgerock.opendj.server.config.server.AccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.JsonFileAccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.LogRotationPolicyCfg;

public final class JsonFileAccessLogPublisherCfgDefn
extends ManagedObjectDefinition<JsonFileAccessLogPublisherCfgClient, JsonFileAccessLogPublisherCfg> {
    private static final JsonFileAccessLogPublisherCfgDefn INSTANCE = new JsonFileAccessLogPublisherCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final BooleanPropertyDefinition PD_LOG_CONTROL_OIDS;
    private static final StringPropertyDefinition PD_LOG_DIRECTORY;
    private static final AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> PD_RETENTION_POLICY;
    private static final AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> PD_ROTATION_POLICY;

    public static JsonFileAccessLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private JsonFileAccessLogPublisherCfgDefn() {
        super("json-file-access-log-publisher", AccessLogPublisherCfgDefn.getInstance());
    }

    @Override
    public JsonFileAccessLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends JsonFileAccessLogPublisherCfgClient> impl) {
        return new JsonFileAccessLogPublisherCfgClientImpl(impl);
    }

    @Override
    public JsonFileAccessLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends JsonFileAccessLogPublisherCfg> impl) {
        return new JsonFileAccessLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<JsonFileAccessLogPublisherCfg> getServerConfigurationClass() {
        return JsonFileAccessLogPublisherCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public EnumPropertyDefinition<AccessLogPublisherCfgDefn.FilteringPolicy> getFilteringPolicyPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getFilteringPolicyPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public BooleanPropertyDefinition getLogControlOidsPropertyDefinition() {
        return PD_LOG_CONTROL_OIDS;
    }

    public StringPropertyDefinition getLogDirectoryPropertyDefinition() {
        return PD_LOG_DIRECTORY;
    }

    public AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> getRetentionPolicyPropertyDefinition() {
        return PD_RETENTION_POLICY;
    }

    public AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> getRotationPolicyPropertyDefinition() {
        return PD_ROTATION_POLICY;
    }

    public BooleanPropertyDefinition getSuppressInternalOperationsPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getSuppressInternalOperationsPropertyDefinition();
    }

    public BooleanPropertyDefinition getSuppressSynchronizationOperationsPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getSuppressSynchronizationOperationsPropertyDefinition();
    }

    public InstantiableRelationDefinition<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg> getAccessLogFilteringCriteriaRelationDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getAccessLogFilteringCriteriaRelationDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.JsonFileAccessLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.LogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "log-control-oids");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-control-oids"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_LOG_CONTROL_OIDS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_CONTROL_OIDS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "log-directory"));
        provider = new DefinedDefaultBehaviorProvider("logs");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "DIRECTORY");
        PD_LOG_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_DIRECTORY);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "retention-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "retention-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "retention-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-retention-policy");
        PD_RETENTION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETENTION_POLICY);
        INSTANCE.registerConstraint(PD_RETENTION_POLICY.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "rotation-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rotation-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "rotation-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-rotation-policy");
        PD_ROTATION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ROTATION_POLICY);
        INSTANCE.registerConstraint(PD_ROTATION_POLICY.getSourceConstraint());
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class JsonFileAccessLogPublisherCfgServerImpl
    implements JsonFileAccessLogPublisherCfg {
        private ServerManagedObject<? extends JsonFileAccessLogPublisherCfg> impl;
        private final boolean pEnabled;
        private final AccessLogPublisherCfgDefn.FilteringPolicy pFilteringPolicy;
        private final String pJavaClass;
        private final boolean pLogControlOids;
        private final String pLogDirectory;
        private final SortedSet<String> pRetentionPolicy;
        private final SortedSet<String> pRotationPolicy;
        private final boolean pSuppressInternalOperations;
        private final boolean pSuppressSynchronizationOperations;

        private JsonFileAccessLogPublisherCfgServerImpl(ServerManagedObject<? extends JsonFileAccessLogPublisherCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pFilteringPolicy = impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLogControlOids = impl.getPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition());
            this.pLogDirectory = impl.getPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition());
            this.pRetentionPolicy = impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
            this.pRotationPolicy = impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
            this.pSuppressInternalOperations = impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
            this.pSuppressSynchronizationOperations = impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
        }

        @Override
        public void addJsonFileAccessChangeListener(ConfigurationChangeListener<JsonFileAccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeJsonFileAccessChangeListener(ConfigurationChangeListener<JsonFileAccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addAccessChangeListener(ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeAccessChangeListener(ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public AccessLogPublisherCfgDefn.FilteringPolicy getFilteringPolicy() {
            return this.pFilteringPolicy;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public boolean isLogControlOids() {
            return this.pLogControlOids;
        }

        @Override
        public String getLogDirectory() {
            return this.pLogDirectory;
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.pRetentionPolicy;
        }

        @Override
        public SortedSet<DN> getRetentionPolicyDNs() {
            SortedSet<String> values = this.getRetentionPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRetentionPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.pRotationPolicy;
        }

        @Override
        public SortedSet<DN> getRotationPolicyDNs() {
            SortedSet<String> values = this.getRotationPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRotationPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public boolean isSuppressInternalOperations() {
            return this.pSuppressInternalOperations;
        }

        @Override
        public boolean isSuppressSynchronizationOperations() {
            return this.pSuppressSynchronizationOperations;
        }

        @Override
        public String[] listAccessLogFilteringCriteria() {
            return this.impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
        }

        @Override
        public AccessLogFilteringCriteriaCfg getAccessLogFilteringCriteria(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addAccessLogFilteringCriteriaAddListener(ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeAccessLogFilteringCriteriaAddListener(ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void addAccessLogFilteringCriteriaDeleteListener(ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeAccessLogFilteringCriteriaDeleteListener(ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public Class<? extends JsonFileAccessLogPublisherCfg> configurationClass() {
            return JsonFileAccessLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class JsonFileAccessLogPublisherCfgClientImpl
    implements JsonFileAccessLogPublisherCfgClient {
        private ManagedObject<? extends JsonFileAccessLogPublisherCfgClient> impl;

        private JsonFileAccessLogPublisherCfgClientImpl(ManagedObject<? extends JsonFileAccessLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public AccessLogPublisherCfgDefn.FilteringPolicy getFilteringPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
        }

        @Override
        public void setFilteringPolicy(AccessLogPublisherCfgDefn.FilteringPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public boolean isLogControlOids() {
            return this.impl.getPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition());
        }

        @Override
        public void setLogControlOids(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition(), value);
        }

        @Override
        public String getLogDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition());
        }

        @Override
        public void setLogDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
        }

        @Override
        public void setRetentionPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void setRotationPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition(), values);
        }

        @Override
        public boolean isSuppressInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
        }

        @Override
        public void setSuppressInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public boolean isSuppressSynchronizationOperations() {
            return this.impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
        }

        @Override
        public void setSuppressSynchronizationOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition(), value);
        }

        @Override
        public String[] listAccessLogFilteringCriteria() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
        }

        @Override
        public AccessLogFilteringCriteriaCfgClient getAccessLogFilteringCriteria(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
        }

        public <M extends AccessLogFilteringCriteriaCfgClient> M createAccessLogFilteringCriteria(ManagedObjectDefinition<M, ? extends AccessLogFilteringCriteriaCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((AccessLogFilteringCriteriaCfgClient)this.impl.createChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeAccessLogFilteringCriteria(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends JsonFileAccessLogPublisherCfgClient, ? extends JsonFileAccessLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

