/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.GenericConstraint;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.server.config.client.HTTPOauth2AuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.client.IdentityMapperCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPAuthorizationMechanismCfgDefn;
import org.forgerock.opendj.server.config.server.HTTPOauth2AuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.IdentityMapperCfg;

public final class HTTPOauth2AuthorizationMechanismCfgDefn
extends AbstractManagedObjectDefinition<HTTPOauth2AuthorizationMechanismCfgClient, HTTPOauth2AuthorizationMechanismCfg> {
    private static final HTTPOauth2AuthorizationMechanismCfgDefn INSTANCE = new HTTPOauth2AuthorizationMechanismCfgDefn();
    private static final BooleanPropertyDefinition PD_ACCESS_TOKEN_CACHE_ENABLED;
    private static final DurationPropertyDefinition PD_ACCESS_TOKEN_CACHE_EXPIRATION;
    private static final StringPropertyDefinition PD_AUTHZID_JSON_POINTER;
    private static final AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> PD_IDENTITY_MAPPER;
    private static final StringPropertyDefinition PD_REQUIRED_SCOPE;

    public static HTTPOauth2AuthorizationMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private HTTPOauth2AuthorizationMechanismCfgDefn() {
        super("http-oauth2-authorization-mechanism", HTTPAuthorizationMechanismCfgDefn.getInstance());
    }

    public BooleanPropertyDefinition getAccessTokenCacheEnabledPropertyDefinition() {
        return PD_ACCESS_TOKEN_CACHE_ENABLED;
    }

    public DurationPropertyDefinition getAccessTokenCacheExpirationPropertyDefinition() {
        return PD_ACCESS_TOKEN_CACHE_EXPIRATION;
    }

    public StringPropertyDefinition getAuthzidJsonPointerPropertyDefinition() {
        return PD_AUTHZID_JSON_POINTER;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPAuthorizationMechanismCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public AggregationPropertyDefinition<IdentityMapperCfgClient, IdentityMapperCfg> getIdentityMapperPropertyDefinition() {
        return PD_IDENTITY_MAPPER;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return HTTPAuthorizationMechanismCfgDefn.getInstance().getJavaClassPropertyDefinition();
    }

    public StringPropertyDefinition getRequiredScopePropertyDefinition() {
        return PD_REQUIRED_SCOPE;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "access-token-cache-enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "access-token-cache-enabled"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ACCESS_TOKEN_CACHE_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ACCESS_TOKEN_CACHE_ENABLED);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "access-token-cache-expiration");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "access-token-cache-expiration"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(false);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("s");
        ((DurationPropertyDefinition.Builder)builder).setUpperLimit("2147483647");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_ACCESS_TOKEN_CACHE_EXPIRATION = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ACCESS_TOKEN_CACHE_EXPIRATION);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "authzid-json-pointer");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "authzid-json-pointer"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_AUTHZID_JSON_POINTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTHZID_JSON_POINTER);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "identity-mapper");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "identity-mapper"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("identity-mapper");
        ((AggregationPropertyDefinition.Builder)builder).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_IDENTITY_MAPPER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_IDENTITY_MAPPER);
        INSTANCE.registerConstraint(PD_IDENTITY_MAPPER.getSourceConstraint());
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "required-scope");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "required-scope"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_REQUIRED_SCOPE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_REQUIRED_SCOPE);
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.contains("access-token-cache-enabled", "true"), Conditions.isPresent("access-token-cache-expiration"))));
    }
}

