/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.GroupImplementationCfgClient;
import org.forgerock.opendj.server.config.server.GroupImplementationCfg;

public final class GroupImplementationCfgDefn
extends ManagedObjectDefinition<GroupImplementationCfgClient, GroupImplementationCfg> {
    private static final GroupImplementationCfgDefn INSTANCE = new GroupImplementationCfgDefn();
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static GroupImplementationCfgDefn getInstance() {
        return INSTANCE;
    }

    private GroupImplementationCfgDefn() {
        super("group-implementation", TopCfgDefn.getInstance());
    }

    @Override
    public GroupImplementationCfgClient createClientConfiguration(ManagedObject<? extends GroupImplementationCfgClient> impl) {
        return new GroupImplementationCfgClientImpl(impl);
    }

    @Override
    public GroupImplementationCfg createServerConfiguration(ServerManagedObject<? extends GroupImplementationCfg> impl) {
        return new GroupImplementationCfgServerImpl(impl);
    }

    @Override
    public Class<GroupImplementationCfg> getServerConfigurationClass() {
        return GroupImplementationCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.Group");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class GroupImplementationCfgServerImpl
    implements GroupImplementationCfg {
        private ServerManagedObject<? extends GroupImplementationCfg> impl;
        private final boolean pEnabled;
        private final String pJavaClass;

        private GroupImplementationCfgServerImpl(ServerManagedObject<? extends GroupImplementationCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<GroupImplementationCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<GroupImplementationCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends GroupImplementationCfg> configurationClass() {
            return GroupImplementationCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class GroupImplementationCfgClientImpl
    implements GroupImplementationCfgClient {
        private ManagedObject<? extends GroupImplementationCfgClient> impl;

        private GroupImplementationCfgClientImpl(ManagedObject<? extends GroupImplementationCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends GroupImplementationCfgClient, ? extends GroupImplementationCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

