/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.AdminEndpointCfgClient;
import org.forgerock.opendj.server.config.client.HTTPAuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPEndpointCfgDefn;
import org.forgerock.opendj.server.config.server.AdminEndpointCfg;
import org.forgerock.opendj.server.config.server.HTTPAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPEndpointCfg;

public final class AdminEndpointCfgDefn
extends ManagedObjectDefinition<AdminEndpointCfgClient, AdminEndpointCfg> {
    private static final AdminEndpointCfgDefn INSTANCE = new AdminEndpointCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static AdminEndpointCfgDefn getInstance() {
        return INSTANCE;
    }

    private AdminEndpointCfgDefn() {
        super("admin-endpoint", HTTPEndpointCfgDefn.getInstance());
    }

    @Override
    public AdminEndpointCfgClient createClientConfiguration(ManagedObject<? extends AdminEndpointCfgClient> impl) {
        return new AdminEndpointCfgClientImpl(impl);
    }

    @Override
    public AdminEndpointCfg createServerConfiguration(ServerManagedObject<? extends AdminEndpointCfg> impl) {
        return new AdminEndpointCfgServerImpl(impl);
    }

    @Override
    public Class<AdminEndpointCfg> getServerConfigurationClass() {
        return AdminEndpointCfg.class;
    }

    public AggregationPropertyDefinition<HTTPAuthorizationMechanismCfgClient, HTTPAuthorizationMechanismCfg> getAuthorizationMechanismPropertyDefinition() {
        return HTTPEndpointCfgDefn.getInstance().getAuthorizationMechanismPropertyDefinition();
    }

    public StringPropertyDefinition getBasePathPropertyDefinition() {
        return HTTPEndpointCfgDefn.getInstance().getBasePathPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPEndpointCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        ClassPropertyDefinition.Builder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.http.rest2ldap.AdminEndpoint");
        builder.setDefaultBehaviorProvider(provider);
        builder.addInstanceOf("org.opends.server.api.HttpEndpoint");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
    }

    private static class AdminEndpointCfgServerImpl
    implements AdminEndpointCfg {
        private ServerManagedObject<? extends AdminEndpointCfg> impl;
        private final SortedSet<String> pAuthorizationMechanism;
        private final String pBasePath;
        private final boolean pEnabled;
        private final String pJavaClass;

        private AdminEndpointCfgServerImpl(ServerManagedObject<? extends AdminEndpointCfg> impl) {
            this.impl = impl;
            this.pAuthorizationMechanism = impl.getPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition());
            this.pBasePath = impl.getPropertyValue(INSTANCE.getBasePathPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addAdminEndpointChangeListener(ConfigurationChangeListener<AdminEndpointCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeAdminEndpointChangeListener(ConfigurationChangeListener<AdminEndpointCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<HTTPEndpointCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<HTTPEndpointCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getAuthorizationMechanism() {
            return this.pAuthorizationMechanism;
        }

        @Override
        public SortedSet<DN> getAuthorizationMechanismDNs() {
            SortedSet<String> values = this.getAuthorizationMechanism();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getAuthorizationMechanismPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public String getBasePath() {
            return this.pBasePath;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends AdminEndpointCfg> configurationClass() {
            return AdminEndpointCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class AdminEndpointCfgClientImpl
    implements AdminEndpointCfgClient {
        private ManagedObject<? extends AdminEndpointCfgClient> impl;

        private AdminEndpointCfgClientImpl(ManagedObject<? extends AdminEndpointCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getAuthorizationMechanism() {
            return this.impl.getPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition());
        }

        @Override
        public void setAuthorizationMechanism(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition(), values);
        }

        @Override
        public String getBasePath() {
            return this.impl.getPropertyValue(INSTANCE.getBasePathPropertyDefinition());
        }

        @Override
        public void setBasePath(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBasePathPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends AdminEndpointCfgClient, ? extends AdminEndpointCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

