/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.OperationsException;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.util.Reject;

public class MissingMandatoryPropertiesException
extends OperationsException {
    private static final long serialVersionUID = 6342522125252055588L;
    private final Collection<PropertyException> causes;
    private final boolean isCreate;
    private final LocalizableMessage ufn;

    private static LocalizableMessage createMessage(Collection<PropertyException> causes) {
        Reject.ifNull(causes);
        Reject.ifFalse((!causes.isEmpty() ? 1 : 0) != 0, (String)"causes should not be empty");
        if (causes.size() == 1) {
            return ConfigMessages.ERR_MISSING_MANDATORY_PROPERTIES_EXCEPTION_SINGLE.get((Object)causes.iterator().next().getPropertyDefinition().getName());
        }
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        boolean isFirst = true;
        for (PropertyException cause : causes) {
            if (!isFirst) {
                builder.append((CharSequence)", ");
            }
            builder.append((CharSequence)cause.getPropertyDefinition().getName());
            isFirst = false;
        }
        return ConfigMessages.ERR_MISSING_MANDATORY_PROPERTIES_EXCEPTION_PLURAL.get((Object)builder.toMessage());
    }

    public MissingMandatoryPropertiesException(LocalizableMessage ufn, Collection<PropertyException> causes, boolean isCreate) {
        super(MissingMandatoryPropertiesException.createMessage(causes));
        this.causes = new ArrayList<PropertyException>(causes);
        this.ufn = ufn;
        this.isCreate = isCreate;
    }

    @Override
    public PropertyException getCause() {
        return this.causes.iterator().next();
    }

    public Collection<PropertyException> getCauses() {
        return Collections.unmodifiableCollection(this.causes);
    }

    public LocalizableMessage getUserFriendlyName() {
        return this.ufn;
    }

    public boolean isCreate() {
        return this.isCreate;
    }
}

