/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class StringPropertyDefinition
extends PropertyDefinition<String> {
    private final boolean isCaseInsensitive;
    private final Pattern pattern;
    private final String patternUsage;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private StringPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior, boolean isCaseInsensitive, Pattern pattern, String patternUsage) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
        this.isCaseInsensitive = isCaseInsensitive;
        this.pattern = pattern;
        this.patternUsage = patternUsage;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitString(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitString(this, value, p);
    }

    @Override
    public String decodeValue(String value) {
        Reject.ifNull((Object)value);
        try {
            this.validateValue(value);
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        return value;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public LocalizableMessage getPatternSynopsis() {
        return this.getPatternSynopsis(Locale.getDefault());
    }

    public LocalizableMessage getPatternSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.string.pattern.synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getPatternUsage() {
        return this.patternUsage;
    }

    public boolean isCaseInsensitive() {
        return this.isCaseInsensitive;
    }

    @Override
    public String normalizeValue(String value) {
        Reject.ifNull((Object)value);
        if (this.isCaseInsensitive()) {
            return value.trim().toLowerCase();
        }
        return value.trim();
    }

    @Override
    public void validateValue(String value) {
        Matcher matcher;
        Reject.ifNull((Object)value);
        if (this.pattern != null && !(matcher = this.pattern.matcher(value)).matches()) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<String, StringPropertyDefinition> {
        private boolean isCaseInsensitive = true;
        private Pattern pattern;
        private String patternUsage;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setCaseInsensitive(boolean value) {
            this.isCaseInsensitive = value;
        }

        public final void setPattern(String pattern, String patternUsage) {
            if (pattern == null) {
                this.pattern = null;
                this.patternUsage = null;
            } else {
                this.pattern = Pattern.compile(pattern);
                this.patternUsage = patternUsage;
            }
        }

        @Override
        protected StringPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            return new StringPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.isCaseInsensitive, this.pattern, this.patternUsage);
        }
    }
}

