/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class IntegerPropertyDefinition
extends PropertyDefinition<Integer> {
    private static final String UNLIMITED = "unlimited";
    private final int lowerLimit;
    private final Integer upperLimit;
    private final boolean allowUnlimited;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private IntegerPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Integer> defaultBehavior, int lowerLimit, Integer upperLimit, boolean allowUnlimited) {
        super(d, Integer.class, propertyName, options, adminAction, defaultBehavior);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.allowUnlimited = allowUnlimited;
    }

    public int getLowerLimit() {
        return this.lowerLimit;
    }

    public Integer getUpperLimit() {
        return this.upperLimit;
    }

    public LocalizableMessage getUnitSynopsis() {
        return this.getUnitSynopsis(Locale.getDefault());
    }

    public LocalizableMessage getUnitSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.integer.unit-synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public boolean isAllowUnlimited() {
        return this.allowUnlimited;
    }

    @Override
    public void validateValue(Integer value) {
        Reject.ifNull((Object)value);
        if (!this.allowUnlimited && value < this.lowerLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (value >= 0 && value < this.lowerLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (this.upperLimit != null && value > this.upperLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(Integer value) {
        Reject.ifNull((Object)value);
        if (this.allowUnlimited && value < 0) {
            return UNLIMITED;
        }
        return value.toString();
    }

    @Override
    public Integer decodeValue(String value) {
        Integer i;
        Reject.ifNull((Object)value);
        if (this.allowUnlimited && UNLIMITED.equalsIgnoreCase(value.trim())) {
            return -1;
        }
        try {
            i = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        try {
            this.validateValue(i);
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        return i;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitInteger(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Integer value, P p) {
        return v.visitInteger(this, value, p);
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" lowerLimit=");
        builder.append(this.lowerLimit);
        if (this.upperLimit != null) {
            builder.append(" upperLimit=");
            builder.append(this.upperLimit);
        }
        builder.append(" allowUnlimited=");
        builder.append(this.allowUnlimited);
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<Integer, IntegerPropertyDefinition> {
        private int lowerLimit;
        private Integer upperLimit;
        private boolean allowUnlimited;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setLowerLimit(int lowerLimit) {
            if (lowerLimit < 0) {
                throw new IllegalArgumentException("Negative lower limit");
            }
            if (this.upperLimit != null && lowerLimit > this.upperLimit) {
                throw new IllegalArgumentException("Lower limit greater than upper limit");
            }
            this.lowerLimit = lowerLimit;
        }

        public final void setUpperLimit(Integer upperLimit) {
            if (upperLimit != null) {
                if (upperLimit < 0) {
                    throw new IllegalArgumentException("Negative lower limit");
                }
                if (this.lowerLimit > upperLimit) {
                    throw new IllegalArgumentException("Lower limit greater than upper limit");
                }
            }
            this.upperLimit = upperLimit;
        }

        public final void setAllowUnlimited(boolean allowUnlimited) {
            this.allowUnlimited = allowUnlimited;
        }

        @Override
        protected IntegerPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Integer> defaultBehavior) {
            return new IntegerPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.lowerLimit, this.upperLimit, this.allowUnlimited);
        }
    }
}

