/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.util.Reject;

public final class BooleanPropertyDefinition
extends PropertyDefinition<Boolean> {
    private static final Map<String, Boolean> VALUE_MAP = new HashMap<String, Boolean>();

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private BooleanPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Boolean> defaultBehavior) {
        super(d, Boolean.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(Boolean value) {
        Reject.ifNull((Object)value);
    }

    @Override
    public Boolean decodeValue(String value) {
        Reject.ifNull((Object)value);
        String nvalue = value.trim().toLowerCase();
        Boolean b = VALUE_MAP.get(nvalue);
        if (b == null) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        return b;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitBoolean(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Boolean value, P p) {
        return v.visitBoolean(this, value, p);
    }

    @Override
    public int compare(Boolean o1, Boolean o2) {
        return o1.compareTo(o2);
    }

    static {
        VALUE_MAP.put("false", Boolean.FALSE);
        VALUE_MAP.put("true", Boolean.TRUE);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<Boolean, BooleanPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected BooleanPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Boolean> defaultBehavior) {
            return new BooleanPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

