/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.apache;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.forgerock.http.header.ConnectionHeader;
import org.forgerock.http.header.ContentEncodingHeader;
import org.forgerock.http.header.ContentLengthHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.spi.HttpClient;
import org.forgerock.http.util.CaseInsensitiveSet;

public abstract class AbstractHttpClient
implements HttpClient {
    private static final CaseInsensitiveSet SUPPRESS_REQUEST_HEADERS = new CaseInsensitiveSet(Arrays.asList("Content-Encoding", "Content-Length", "Content-Type", "Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"));
    private static final CaseInsensitiveSet SUPPRESS_RESPONSE_HEADERS = new CaseInsensitiveSet(Arrays.asList("Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"));

    protected HttpUriRequest createHttpUriRequest(Request request) {
        Object clientRequest = request.getEntity().isRawContentEmpty() ? new NonEntityRequest(request) : new EntityRequest(request);
        clientRequest.setURI(request.getUri().asURI());
        CaseInsensitiveSet removableHeaderNames = new CaseInsensitiveSet();
        removableHeaderNames.addAll((Collection)ConnectionHeader.valueOf((Message)request).getTokens());
        for (String name : request.getHeaders().keySet()) {
            if (SUPPRESS_REQUEST_HEADERS.contains((Object)name) || removableHeaderNames.contains((Object)name)) continue;
            for (String value : request.getHeaders().get((Object)name).getValues()) {
                clientRequest.addHeader(name, value);
            }
        }
        return clientRequest;
    }

    protected static Response createResponseWithoutEntity(HttpResponse result) {
        StatusLine statusLine = result.getStatusLine();
        Response response = new Response(Status.valueOf((int)statusLine.getStatusCode(), (String)statusLine.getReasonPhrase()));
        response.setVersion(statusLine.getProtocolVersion().toString());
        CaseInsensitiveSet removableHeaderNames = new CaseInsensitiveSet();
        removableHeaderNames.addAll((Collection)ConnectionHeader.valueOf((Message)response).getTokens());
        HeaderIterator i = result.headerIterator();
        while (i.hasNext()) {
            Header header = i.nextHeader();
            String name = header.getName();
            if (SUPPRESS_RESPONSE_HEADERS.contains((Object)name) || removableHeaderNames.contains((Object)name)) continue;
            response.getHeaders().add(name, (Object)header.getValue());
        }
        return response;
    }

    private static class NonEntityRequest
    extends HttpRequestBase {
        private final String method;

        public NonEntityRequest(Request request) {
            this.method = request.getMethod();
            Header[] contentLengthHeader = this.getHeaders("Content-Length");
            if ((contentLengthHeader == null || contentLengthHeader.length == 0) && ("PUT".equals(this.method) || "POST".equals(this.method) || "PROPFIND".equals(this.method))) {
                this.setHeader("Content-Length", "0");
            }
        }

        public String getMethod() {
            return this.method;
        }
    }

    private static class EntityRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        public EntityRequest(Request request) {
            this.method = request.getMethod();
            InputStreamEntity entity = new InputStreamEntity(request.getEntity().getRawContentInputStream(), ContentLengthHeader.valueOf((Message)request).getLength());
            List contentType = ContentTypeHeader.valueOf((Message)request).getValues();
            if (contentType != null && contentType.size() > 1) {
                throw new IllegalArgumentException("Content-Type configured with multiple values");
            }
            entity.setContentType(contentType == null || contentType.size() == 0 ? null : (String)contentType.get(0));
            List encoding = ContentEncodingHeader.valueOf((Message)request).getValues();
            if (encoding != null && encoding.size() > 1) {
                throw new IllegalArgumentException("Content-Encoding configured with multiple values");
            }
            entity.setContentEncoding(encoding == null || encoding.size() == 0 ? null : (String)encoding.get(0));
            this.setEntity((HttpEntity)entity);
        }

        public String getMethod() {
            return this.method;
        }
    }
}

