/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.util;

import java.util.Date;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateUtil {
    private Chronology chrono;

    public static DateUtil getDateUtil() {
        return new DateUtil();
    }

    public static DateUtil getDateUtil(String zone) {
        return new DateUtil(zone);
    }

    public static DateUtil getDateUtil(DateTimeZone zone) {
        return new DateUtil(zone);
    }

    private DateUtil() {
        this(DateTimeZone.getDefault());
    }

    private DateUtil(String zone) {
        this(DateTimeZone.forID((String)zone));
    }

    private DateUtil(DateTimeZone zone) {
        this.chrono = ISOChronology.getInstance((DateTimeZone)zone);
    }

    public String now() {
        return new DateTime(this.chrono).toString();
    }

    public DateTime currentDateTime() {
        return new DateTime(this.chrono);
    }

    public String formatDateTime(DateTime date) {
        return date.withChronology(this.chrono).toString();
    }

    public String formatDateTime(Date date) {
        DateTime dt = new DateTime((Object)date, this.chrono);
        return dt.toString();
    }

    public String formatDateTime(long timestamp) {
        DateTime dt = new DateTime(timestamp, this.chrono);
        return dt.toString();
    }

    public DateTime parseTimestamp(String timestamp) {
        DateTimeFormatter parser = ISODateTimeFormat.dateTime();
        return parser.withOffsetParsed().parseDateTime(timestamp);
    }

    public DateTime parseIfDate(String timestamp) {
        DateTime d = null;
        if (timestamp.length() > 23 && timestamp.length() < 30) {
            try {
                d = this.parseTimestamp(timestamp);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return d;
    }

    public static int getDateDifferenceInDays(Date start, Date end, Boolean includeDay) {
        Integer result = null;
        if (start != null && end != null) {
            Long l = 86400000L;
            Long r = (end.getTime() - start.getTime()) / l;
            result = r.intValue();
            if (includeDay.booleanValue()) {
                Integer n = result;
                Integer n2 = result = Integer.valueOf(result + 1);
            }
        }
        return result;
    }
}

