/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.secure;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.forgerock.audit.secure.KeyStoreHandler;
import org.forgerock.security.keystore.KeyStoreBuilder;
import org.forgerock.security.keystore.KeyStoreType;
import org.forgerock.util.Utils;

public class JcaKeyStoreHandler
implements KeyStoreHandler {
    private final String location;
    private final String password;
    private final KeyStoreType type;
    private KeyStore store;

    public JcaKeyStoreHandler(String type, String location, String password) throws Exception {
        this.location = location;
        this.password = password;
        this.type = (KeyStoreType)Utils.asEnum((String)type, KeyStoreType.class);
        this.init();
    }

    private void init() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        File keystore = new File(this.location);
        this.store = !keystore.exists() ? new KeyStoreBuilder().withKeyStoreType(this.type).withPassword(this.password).build() : new KeyStoreBuilder().withKeyStoreFile(this.location).withKeyStoreType(this.type).withPassword(this.password).build();
    }

    @Override
    public KeyStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(KeyStore keystore) throws Exception {
        this.store = keystore;
        this.store();
    }

    @Override
    public void store() throws Exception {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.location));){
            this.store.store(out, this.password.toCharArray());
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getType() {
        return this.type.name();
    }
}

