/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.retention;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.audit.retention.FileNamingPolicy;
import org.forgerock.audit.retention.TimestampFilenameFilter;
import org.forgerock.audit.util.LastModifiedTimeFileComparator;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampFileNamingPolicy
implements FileNamingPolicy {
    private static final int INITIAL_STRING_BUFFER_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(TimeStampFileNamingPolicy.class);
    private final File initialFile;
    private DateTimeFormatter suffixDateFormat;
    private final String prefix;
    private final TimestampFilenameFilter timestampFilenameFilter;
    private final LastModifiedTimeFileComparator lastModifiedTimeFileComparator = new LastModifiedTimeFileComparator();
    private final AtomicInteger collisionCounter = new AtomicInteger();

    public TimeStampFileNamingPolicy(File initialFile, String timeStampFormat, String prefix) {
        this.initialFile = initialFile;
        this.prefix = prefix;
        if (timeStampFormat != null && timeStampFormat.trim().length() > 0) {
            try {
                this.suffixDateFormat = DateTimeFormat.forPattern((String)timeStampFormat);
            }
            catch (IllegalArgumentException iae) {
                logger.info("Date format invalid: {}", (Object)timeStampFormat, (Object)iae);
            }
        }
        if (this.suffixDateFormat == null) {
            this.suffixDateFormat = DateTimeFormat.forPattern((String)"-yyyy.MM.dd-HH.mm.ss");
        }
        this.timestampFilenameFilter = new TimestampFilenameFilter(initialFile, prefix, this.suffixDateFormat);
    }

    @Override
    public File getInitialName() {
        return this.initialFile;
    }

    @Override
    public File getNextName() {
        Path newFilePath;
        StringBuilder newFileName = new StringBuilder(64);
        Path path = this.initialFile.toPath();
        if (this.prefix != null) {
            newFileName.append(this.prefix);
        }
        newFileName.append(path.getFileName());
        if (this.suffixDateFormat != null) {
            newFileName.append(LocalDateTime.now().toString(this.suffixDateFormat));
        }
        if (Files.exists(newFilePath = path.resolveSibling(newFileName.toString()), new LinkOption[0])) {
            newFileName.append('.').append(this.collisionCounter.incrementAndGet());
            newFilePath = path.resolveSibling(newFileName.toString());
        }
        return newFilePath.toFile();
    }

    @Override
    public List<File> listFiles() {
        LinkedList<File> fileList = new LinkedList<File>(Arrays.asList(this.initialFile.getParentFile().listFiles(this.timestampFilenameFilter)));
        Collections.sort(fileList, Collections.reverseOrder(this.lastModifiedTimeFileComparator));
        return fileList;
    }
}

