/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.filter;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.filter.FilterPolicy;
import org.forgerock.audit.filter.ValueOrFieldFilter;
import org.forgerock.json.JsonPointer;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Filters {
    private static final Logger logger = LoggerFactory.getLogger(Filters.class);

    public static ValueOrFieldFilter newValueOrFieldFilter(List<String> auditTopics, FilterPolicy policy) {
        return new ValueOrFieldFilter(Filters.exclusionListPerTopic(auditTopics, policy));
    }

    public static ValueOrFieldFilter newFilter(String name, List<String> auditTopics, FilterPolicy policy) throws AuditException {
        Reject.ifNull((Object)name);
        FilterNames filterName = (FilterNames)Utils.asEnum((String)name, FilterNames.class);
        switch (filterName) {
            case VALUE: 
            case FIELD: {
                return Filters.newValueOrFieldFilter(auditTopics, policy);
            }
        }
        String error = String.format("Unknown filter policy name: %s", name);
        logger.error(error);
        throw new AuditException(error);
    }

    private static Map<String, List<JsonPointer>> exclusionListPerTopic(List<String> auditTopicsList, FilterPolicy policy) {
        Map<String, List<JsonPointer>> topicMap = Filters.initializeTopicMap(auditTopicsList);
        for (String value : policy.getExcludeIf()) {
            Filters.addToTopicMap(value, topicMap);
        }
        return topicMap;
    }

    private static void addToTopicMap(String value, Map<String, List<JsonPointer>> topicMap) {
        JsonPointer pointer = new JsonPointer(value);
        String topic = pointer.get(0);
        JsonPointer exclusionPointer = new JsonPointer(Arrays.copyOfRange(pointer.toArray(), 1, pointer.size()));
        List<JsonPointer> topicPolicies = topicMap.get(topic);
        if (topicPolicies != null) {
            topicPolicies.add(exclusionPointer);
        } else {
            logger.error(String.format("Attempting to create a policy for an audit topic not registered: %s", value));
        }
    }

    private static Map<String, List<JsonPointer>> initializeTopicMap(List<String> auditTopicsList) {
        LinkedHashMap<String, List<JsonPointer>> topicMap = new LinkedHashMap<String, List<JsonPointer>>(auditTopicsList.size());
        for (String auditTopic : auditTopicsList) {
            topicMap.put(auditTopic, new LinkedList());
        }
        return topicMap;
    }

    private Filters() {
    }

    protected static enum FilterNames {
        VALUE,
        FIELD;

    }
}

