/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers.writers;

import java.io.IOException;
import java.io.OutputStream;

public final class MeteredStream
extends OutputStream {
    private final OutputStream out;
    private long written;

    public MeteredStream(OutputStream out, long written) {
        this.out = out;
        this.written = written;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    @Override
    public void write(byte[] buff) throws IOException {
        this.out.write(buff);
        this.written += (long)buff.length;
    }

    @Override
    public void write(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        this.written += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long getBytesWritten() {
        return this.written;
    }
}

