/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers;

import org.forgerock.json.JsonValue;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;

public final class AuditEventTopicState {
    private final Context context;
    private final String topic;
    private final JsonValue event;

    public AuditEventTopicState(Context context, String topic, JsonValue event) {
        Reject.ifNull((Object[])new Object[]{topic, event});
        this.context = context;
        this.topic = topic;
        this.event = event;
    }

    public String getTopic() {
        return this.topic;
    }

    public JsonValue getEvent() {
        return this.event;
    }

    public Context getContext() {
        return this.context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.topic.hashCode();
        result = 31 * result + this.event.asMap().hashCode();
        result = 31 * result + this.context.toJsonValue().asMap().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuditEventTopicState) {
            AuditEventTopicState other = (AuditEventTopicState)obj;
            if (this.topic.equals(other.topic) && this.event.asMap().equals(other.event.asMap()) && this.context.toJsonValue().asMap().equals(other.context.toJsonValue().asMap())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("AuditEventTopicState [topic=%s, event=%s, contextId=%s]", this.topic, this.event, this.context.getId());
    }
}

