/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.annotations.Parameter;
import org.forgerock.api.annotations.Path;
import org.forgerock.api.annotations.SingletonProvider;
import org.forgerock.api.enums.ParameterSource;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Items;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.SubResources;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.AbstractConnectionWrapper;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedCollectionHandler;
import org.forgerock.json.resource.AnnotatedRequestHandler;
import org.forgerock.json.resource.AnnotatedSingletonHandler;
import org.forgerock.json.resource.AnnotationCollectionInstance;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.DescribableResourceHandler;
import org.forgerock.json.resource.DescribedSyncRequestHandlerAdapter;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.FilterChain;
import org.forgerock.json.resource.InterfaceCollectionHandler;
import org.forgerock.json.resource.InterfaceCollectionInstance;
import org.forgerock.json.resource.InterfaceSingletonHandler;
import org.forgerock.json.resource.InternalConnection;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.SynchronousRequestHandler;
import org.forgerock.json.resource.SynchronousRequestHandlerAdapter;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class Resources {
    public static RequestHandler asRequestHandler(SynchronousRequestHandler syncHandler) {
        return syncHandler instanceof Describable ? new DescribedSyncRequestHandlerAdapter(syncHandler) : new SynchronousRequestHandlerAdapter(syncHandler);
    }

    public static JsonValue filterResource(JsonValue resource, Collection<JsonPointer> fields) {
        if (fields.isEmpty() || resource.isNull() || resource.size() == 0) {
            return resource;
        }
        LinkedHashMap<String, Object> filtered = new LinkedHashMap<String, Object>(fields.size());
        for (JsonPointer field : fields) {
            if (field.isEmpty()) {
                filtered.putAll(resource.asMap());
                continue;
            }
            JsonValue value = resource.get(field);
            if (value == null) continue;
            String key = field.leaf();
            filtered.put(key, value.getObject());
        }
        return new JsonValue(filtered);
    }

    public static ResourceResponse filterResource(ResourceResponse resource, Collection<JsonPointer> fields) {
        Collection<JsonPointer> filterFields;
        JsonValue unfiltered = resource.getContent();
        JsonValue filtered = Resources.filterResource(unfiltered, filterFields = resource.hasFields() ? resource.getFields() : fields);
        if (filtered == unfiltered) {
            return resource;
        }
        return Responses.newResourceResponse(resource.getId(), resource.getRevision(), filtered);
    }

    public static Connection newInternalConnection(RequestHandler handler) {
        return new InternalConnection(handler);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler handler) {
        return new InternalConnectionFactory(handler);
    }

    public static RequestHandler newHandler(Object provider) {
        Router router;
        if (provider instanceof Describable) {
            router = new Router();
            Resources.addHandlers(provider, router, "", null, new org.forgerock.api.models.Parameter[0]);
        } else {
            final DescribableResourceHandler descriptorProvider = new DescribableResourceHandler();
            router = new Router(){

                protected ApiDescription buildApi(ApiProducer<ApiDescription> producer) {
                    return descriptorProvider.api(producer);
                }
            };
            descriptorProvider.describes(Resources.addHandlers(provider, router, "", descriptorProvider.getDefinitionDescriptions(), new org.forgerock.api.models.Parameter[0]));
        }
        Path path = provider.getClass().getAnnotation(Path.class);
        if (path != null) {
            Router pathRouter = new Router();
            pathRouter.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, path.value()), router);
            router = pathRouter;
        }
        return router;
    }

    private static Resource addHandlers(Object provider, Router router, String basePath, ApiDescription definitions, org.forgerock.api.models.Parameter ... pathParameters) {
        HandlerVariant variant = Resources.deduceHandlerVariant(provider);
        org.forgerock.api.models.Parameter[] nextPathParameters = pathParameters;
        switch (variant) {
            case SINGLETON_RESOURCE: {
                Resources.addSingletonHandlerToRouter(provider, router, basePath);
                break;
            }
            case COLLECTION_RESOURCE: {
                nextPathParameters = new org.forgerock.api.models.Parameter[pathParameters.length + 1];
                System.arraycopy(pathParameters, 0, nextPathParameters, 0, pathParameters.length);
                nextPathParameters[pathParameters.length] = Resources.addCollectionHandlersToRouter(provider, router, basePath);
                String pathParameter = nextPathParameters[pathParameters.length].getName();
                basePath = (basePath.isEmpty() ? "" : basePath + "/") + "{" + pathParameter + "}";
                break;
            }
            case REQUEST_HANDLER: {
                Resources.addRequestHandlerToRouter(provider, router, basePath);
                break;
            }
            default: {
                return null;
            }
        }
        SubResources.Builder subResourcesBuilder = null;
        for (Method m : provider.getClass().getMethods()) {
            Path subpathAnnotation = m.getAnnotation(Path.class);
            if (subpathAnnotation == null) continue;
            if (subResourcesBuilder == null) {
                subResourcesBuilder = SubResources.subresources();
            }
            String subpath = subpathAnnotation.value().replaceAll("^/", "");
            try {
                Resource subResource = Resources.addHandlers(m.invoke(provider, new Object[0]), router, basePath.isEmpty() ? subpath : basePath + "/" + subpath, definitions, nextPathParameters);
                if (subResource == null) continue;
                subResourcesBuilder.put(subpath, subResource);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not construct handler tree", e);
            }
        }
        SubResources subResources = subResourcesBuilder == null ? null : subResourcesBuilder.build();
        return Resources.makeDescriptor(provider, variant, subResources, definitions, pathParameters);
    }

    private static HandlerVariant deduceHandlerVariant(Object provider) {
        Class<?> type = provider.getClass();
        org.forgerock.api.annotations.RequestHandler handler = provider.getClass().getAnnotation(org.forgerock.api.annotations.RequestHandler.class);
        if (handler != null || provider instanceof RequestHandler) {
            return HandlerVariant.REQUEST_HANDLER;
        }
        if (type.getAnnotation(SingletonProvider.class) != null || provider instanceof SingletonResourceProvider) {
            return HandlerVariant.SINGLETON_RESOURCE;
        }
        if (type.getAnnotation(CollectionProvider.class) != null || provider instanceof CollectionResourceProvider) {
            return HandlerVariant.COLLECTION_RESOURCE;
        }
        throw new IllegalArgumentException("Cannot deduce provider variant" + provider.getClass());
    }

    private static void addRequestHandlerToRouter(Object provider, Router router, String basePath) {
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, basePath), new AnnotatedRequestHandler(provider));
    }

    private static org.forgerock.api.models.Parameter addCollectionHandlersToRouter(Object provider, Router router, String basePath) {
        boolean fromInterface = provider instanceof CollectionResourceProvider;
        InterfaceCollectionHandler collectionHandler = fromInterface ? new InterfaceCollectionHandler((CollectionResourceProvider)provider) : new AnnotatedCollectionHandler(provider);
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, basePath), collectionHandler);
        RequestHandler instanceHandler = fromInterface ? new InterfaceCollectionInstance((CollectionResourceProvider)provider) : new AnnotationCollectionInstance(provider);
        Class<?> providerClass = provider.getClass();
        CollectionProvider providerAnnotation = providerClass.getAnnotation(CollectionProvider.class);
        org.forgerock.api.models.Parameter pathParameter = providerAnnotation != null ? org.forgerock.api.models.Parameter.fromAnnotation(providerClass, (Parameter)providerAnnotation.pathParam()) : org.forgerock.api.models.Parameter.parameter().name("id").type("string").source(ParameterSource.PATH).required(Boolean.valueOf(true)).build();
        String pathParam = pathParameter.getName();
        instanceHandler = new FilterChain(instanceHandler, new CollectionInstanceIdContextFilter(pathParam));
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, (basePath.isEmpty() ? "" : basePath + "/") + "{" + pathParam + "}"), instanceHandler);
        return pathParameter;
    }

    private static void addSingletonHandlerToRouter(Object provider, Router router, String basePath) {
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, basePath), provider instanceof SingletonResourceProvider ? new InterfaceSingletonHandler((SingletonResourceProvider)provider) : new AnnotatedSingletonHandler(provider));
    }

    private static Resource makeDescriptor(Object provider, HandlerVariant variant, SubResources subResources, ApiDescription definitions, org.forgerock.api.models.Parameter[] pathParameters) {
        if (provider instanceof Describable) {
            return null;
        }
        Class<?> type = provider.getClass();
        switch (variant) {
            case SINGLETON_RESOURCE: {
                return Resource.fromAnnotatedType(type, (Resource.AnnotatedTypeVariant)Resource.AnnotatedTypeVariant.SINGLETON_RESOURCE, (SubResources)subResources, (ApiDescription)definitions, (org.forgerock.api.models.Parameter[])pathParameters);
            }
            case COLLECTION_RESOURCE: {
                Items items = Items.fromAnnotatedType(type, (ApiDescription)definitions, (SubResources)subResources);
                return Resource.fromAnnotatedType(type, (Resource.AnnotatedTypeVariant)Resource.AnnotatedTypeVariant.COLLECTION_RESOURCE_COLLECTION, (Items)items, (ApiDescription)definitions, (org.forgerock.api.models.Parameter[])pathParameters);
            }
            case REQUEST_HANDLER: {
                return Resource.fromAnnotatedType(type, (Resource.AnnotatedTypeVariant)Resource.AnnotatedTypeVariant.REQUEST_HANDLER, (SubResources)subResources, (ApiDescription)definitions, (org.forgerock.api.models.Parameter[])pathParameters);
            }
        }
        return null;
    }

    @Deprecated
    public static RequestHandler newCollection(Object provider) {
        return Resources.newHandler(provider);
    }

    @Deprecated
    public static RequestHandler newSingleton(Object provider) {
        return Resources.newHandler(provider);
    }

    @Deprecated
    public static RequestHandler newAnnotatedRequestHandler(Object provider) {
        Reject.ifTrue((boolean)(provider instanceof RequestHandler), (String)"Refusing to create an annotated request handler using a provider that implements RequestHandler. Use the RequestHandler implementation directly instead");
        return Resources.newHandler(provider);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public Promise<Connection, ResourceException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            @Override
            public Connection getConnection() throws ResourceException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    static String idOf(Context context) {
        String idFieldName = ((IdFieldContext)context.asContext(IdFieldContext.class)).getIdFieldName();
        return (String)((UriRouterContext)context.asContext(UriRouterContext.class)).getUriTemplateVariables().get(idFieldName);
    }

    static ResourceException newBadRequestException(String fs, Object ... args) {
        String msg = String.format(fs, args);
        return new BadRequestException(msg);
    }

    private static <V> Promise<V, ResourceException> newSuccessfulPromise(V result) {
        return Promises.newResultPromise(result);
    }

    static Context parentOf(Context context) {
        if (context instanceof IdFieldContext) {
            context = context.getParent();
        }
        assert (context instanceof UriRouterContext);
        return context.getParent();
    }

    private Resources() {
    }

    static enum HandlerVariant {
        SINGLETON_RESOURCE,
        COLLECTION_RESOURCE,
        REQUEST_HANDLER;

    }

    private static final class CollectionInstanceIdContextFilter
    implements Filter {
        private final String idFieldName;

        private CollectionInstanceIdContextFilter(String idFieldName) {
            this.idFieldName = idFieldName;
        }

        @Override
        public Promise<ActionResponse, ResourceException> filterAction(Context context, ActionRequest request, RequestHandler next) {
            return next.handleAction((Context)new IdFieldContext(context, this.idFieldName), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterCreate(Context context, CreateRequest request, RequestHandler next) {
            return next.handleCreate((Context)new IdFieldContext(context, this.idFieldName), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterDelete(Context context, DeleteRequest request, RequestHandler next) {
            return next.handleDelete((Context)new IdFieldContext(context, this.idFieldName), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterPatch(Context context, PatchRequest request, RequestHandler next) {
            return next.handlePatch((Context)new IdFieldContext(context, this.idFieldName), request);
        }

        @Override
        public Promise<QueryResponse, ResourceException> filterQuery(Context context, QueryRequest request, QueryResourceHandler handler, RequestHandler next) {
            return next.handleQuery((Context)new IdFieldContext(context, this.idFieldName), request, handler);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterRead(Context context, ReadRequest request, RequestHandler next) {
            return next.handleRead((Context)new IdFieldContext(context, this.idFieldName), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> filterUpdate(Context context, UpdateRequest request, RequestHandler next) {
            return next.handleUpdate((Context)new IdFieldContext(context, this.idFieldName), request);
        }
    }

    private static class IdFieldContext
    extends AbstractContext {
        private static final String ID_FIELD_NAME = "IdFieldName";

        protected IdFieldContext(Context parent, String idFieldName) {
            super(parent, "IdField");
            this.data.put(ID_FIELD_NAME, (Object)idFieldName);
        }

        protected IdFieldContext(JsonValue data, ClassLoader loader) {
            super(data, loader);
        }

        String getIdFieldName() {
            return this.data.get(ID_FIELD_NAME).asString();
        }
    }

    private static final class InternalConnectionFactory
    implements ConnectionFactory {
        private final RequestHandler handler;

        private InternalConnectionFactory(RequestHandler handler) {
            this.handler = handler;
        }

        @Override
        public void close() {
        }

        @Override
        public Connection getConnection() {
            return Resources.newInternalConnection(this.handler);
        }

        @Override
        public Promise<Connection, ResourceException> getConnectionAsync() {
            return Resources.newSuccessfulPromise(this.getConnection());
        }
    }
}

