/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.annotations.Delete;
import org.forgerock.api.annotations.Patch;
import org.forgerock.api.annotations.Read;
import org.forgerock.api.annotations.Update;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedActionMethods;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InterfaceCollectionInstance;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

class AnnotationCollectionInstance
extends InterfaceCollectionInstance {
    private final AnnotatedMethod readMethod;
    private final AnnotatedMethod updateMethod;
    private final AnnotatedMethod deleteMethod;
    private final AnnotatedMethod patchMethod;
    private final AnnotatedActionMethods actionMethods;

    AnnotationCollectionInstance(Object requestHandler) {
        super(null);
        if (!requestHandler.getClass().isAnnotationPresent(CollectionProvider.class)) {
            throw new IllegalArgumentException("CollectionProvider missing from class: " + requestHandler.getClass().getName());
        }
        this.readMethod = AnnotatedMethod.findMethod(requestHandler, Read.class, true);
        this.updateMethod = AnnotatedMethod.findMethod(requestHandler, Update.class, true);
        this.deleteMethod = AnnotatedMethod.findMethod(requestHandler, Delete.class, true);
        this.patchMethod = AnnotatedMethod.findMethod(requestHandler, Patch.class, true);
        this.actionMethods = AnnotatedActionMethods.findAll(requestHandler, true);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return this.readMethod.invoke(context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return this.updateMethod.invoke(context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return this.deleteMethod.invoke(context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return this.patchMethod.invoke(context, (Request)request, Resources.idOf(context));
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.actionMethods.invoke(context, request, Resources.idOf(context));
    }
}

