/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.annotations.Create;
import org.forgerock.api.annotations.Query;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AnnotatedActionMethods;
import org.forgerock.json.resource.AnnotatedMethod;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.InterfaceCollectionHandler;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.promise.Promise;

class AnnotatedCollectionHandler
extends InterfaceCollectionHandler
implements Describable<ApiDescription, Request> {
    private final AnnotatedMethod createMethod;
    private final AnnotatedMethod queryMethod;
    private final AnnotatedActionMethods actionMethods;
    private final Describable<ApiDescription, Request> describable;

    public AnnotatedCollectionHandler(Object requestHandler) {
        super(null);
        if (!requestHandler.getClass().isAnnotationPresent(CollectionProvider.class)) {
            throw new IllegalArgumentException("CollectionProvider missing from class: " + requestHandler.getClass().getName());
        }
        this.createMethod = AnnotatedMethod.findMethod(requestHandler, Create.class, false);
        this.queryMethod = AnnotatedMethod.findMethod(requestHandler, Query.class, false);
        this.actionMethods = AnnotatedActionMethods.findAll(requestHandler, false);
        this.describable = requestHandler instanceof Describable ? (Describable)requestHandler : null;
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return this.createMethod.invoke(context, request);
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.queryMethod.invoke(context, (Request)request, handler);
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.actionMethods.invoke(context, request);
    }

    public ApiDescription api(ApiProducer<ApiDescription> producer) {
        if (this.describable == null) {
            throw new UnsupportedOperationException("The provided request handler does not support API Descriptor methods");
        }
        return (ApiDescription)this.describable.api(producer);
    }

    public ApiDescription handleApiRequest(Context context, Request request) {
        if (this.describable == null) {
            throw new UnsupportedOperationException("The provided request handler does not support API Descriptor methods");
        }
        return (ApiDescription)this.describable.handleApiRequest(context, (Object)request);
    }

    public void addDescriptorListener(Describable.Listener listener) {
        if (this.describable != null) {
            this.describable.addDescriptorListener(listener);
        }
    }

    public void removeDescriptorListener(Describable.Listener listener) {
        if (this.describable != null) {
            this.describable.removeDescriptorListener(listener);
        }
    }
}

