/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.forgerock.audit.Audit;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.handlers.jms.BatchPublisher;
import org.forgerock.audit.handlers.jms.BatchPublisherConfiguration;
import org.forgerock.audit.handlers.jms.JmsAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.jms.JmsContextManager;
import org.forgerock.audit.handlers.jms.JmsResourceManager;
import org.forgerock.audit.handlers.jms.JndiJmsContextManager;
import org.forgerock.audit.handlers.jms.Publisher;
import org.forgerock.audit.util.ResourceExceptionsUtil;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAuditEventHandler
extends AuditEventHandlerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsAuditEventHandler.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JmsResourceManager jmsResourceManager;
    private final Publisher<JsonValue> publisher;

    @Inject
    public JmsAuditEventHandler(@Audit JmsContextManager jmsContextManager, JmsAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData) throws ResourceException {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        this.publisher = this.buildPublisher(configuration);
        this.jmsResourceManager = jmsContextManager == null ? new JmsResourceManager(configuration, new JndiJmsContextManager(configuration.getJndi())) : new JmsResourceManager(configuration, jmsContextManager);
        LOGGER.debug("Successfully configured JMS audit event handler.");
    }

    Publisher<JsonValue> buildPublisher(JmsAuditEventHandlerConfiguration configuration) {
        return configuration.getBatch().isBatchEnabled() ? new JmsBatchPublisher(configuration.getBatch()) : new JmsPublisher();
    }

    public void startup() throws ResourceException {
        this.publisher.startup();
        LOGGER.debug("JMS audit event handler is started.");
    }

    public void shutdown() throws ResourceException {
        this.publisher.shutdown();
        LOGGER.debug("JMS audit event handler is shutdown.");
    }

    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String auditTopic, JsonValue auditEvent) {
        try {
            this.publisher.publish(JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"auditTopic", (Object)auditTopic), JsonValue.field((String)"event", (Object)auditEvent.getObject())})));
            return Responses.newResourceResponse((String)auditEvent.get("_id").asString(), null, (JsonValue)auditEvent).asPromise();
        }
        catch (Exception ex) {
            return ResourceExceptionsUtil.adapt((Throwable)ex).asPromise();
        }
    }

    private void publishJmsMessagesWithRetry(List<JsonValue> messages) throws InternalServerErrorException {
        try {
            this.publishJmsMessages(messages);
        }
        catch (JMSException e) {
            LOGGER.debug("Retrying publish", (Throwable)e);
            try {
                this.resetConnection();
                this.publishJmsMessages(messages);
            }
            catch (JMSException | ResourceException ex) {
                String message = "Unable to publish JMS messages, messages are likely lost";
                LOGGER.error("Unable to publish JMS messages, messages are likely lost", (Throwable)e);
                throw new InternalServerErrorException("Unable to publish JMS messages, messages are likely lost", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishJmsMessages(List<JsonValue> messages) throws JMSException, InternalServerErrorException {
        Session session = null;
        try {
            session = this.jmsResourceManager.createSession();
            MessageProducer producer = null;
            try {
                producer = this.jmsResourceManager.createProducer(session);
                for (JsonValue message : messages) {
                    String text = MAPPER.writeValueAsString(message.getObject());
                    producer.send((Message)session.createTextMessage(text));
                }
            }
            finally {
                if (null != producer) {
                    producer.close();
                }
            }
        }
        catch (JMSException e) {
            LOGGER.debug("Failed to publish messages", (Throwable)e);
            throw e;
        }
        catch (JsonProcessingException e) {
            String message = "Unable to publish JMS messages, messages are likely lost";
            LOGGER.error("Unable to publish JMS messages, messages are likely lost", (Throwable)e);
            throw new InternalServerErrorException("Unable to publish JMS messages, messages are likely lost", (Throwable)e);
        }
        finally {
            if (null != session) {
                session.close();
            }
        }
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, String topic, QueryRequest queryRequest, QueryResourceHandler queryResourceHandler) {
        return ResourceExceptionsUtil.notSupported((Request)queryRequest).asPromise();
    }

    public Promise<ResourceResponse, ResourceException> readEvent(Context context, String topic, String resourceId) {
        return new NotSupportedException("read operations are not supported").asPromise();
    }

    private void openJmsConnection() throws InternalServerErrorException {
        try {
            this.jmsResourceManager.openConnection();
        }
        catch (JMSException e) {
            throw new InternalServerErrorException("trouble opening connection", (Throwable)e);
        }
    }

    private void closeJmsConnection() throws InternalServerErrorException {
        try {
            this.jmsResourceManager.closeConnection();
        }
        catch (JMSException e) {
            throw new InternalServerErrorException("trouble closing connection", (Throwable)e);
        }
    }

    private void resetConnection() throws InternalServerErrorException {
        this.closeJmsConnection();
        this.openJmsConnection();
    }

    private class JmsPublisher
    implements Publisher<JsonValue> {
        private JmsPublisher() {
        }

        @Override
        public void startup() throws ResourceException {
            JmsAuditEventHandler.this.openJmsConnection();
        }

        @Override
        public void shutdown() throws ResourceException {
            JmsAuditEventHandler.this.closeJmsConnection();
        }

        @Override
        public void publish(JsonValue message) throws ResourceException {
            JmsAuditEventHandler.this.publishJmsMessagesWithRetry(Collections.singletonList(message));
        }
    }

    private class JmsBatchPublisher
    extends BatchPublisher<JsonValue> {
        public JmsBatchPublisher(BatchPublisherConfiguration configuration) {
            super("JmsBatchPublisher", configuration);
        }

        @Override
        public void startupPublisher() throws ResourceException {
            JmsAuditEventHandler.this.openJmsConnection();
        }

        @Override
        public void shutdownPublisher() throws ResourceException {
            JmsAuditEventHandler.this.closeJmsConnection();
        }

        @Override
        protected void publishMessages(List<JsonValue> messages) {
            try {
                JmsAuditEventHandler.this.publishJmsMessagesWithRetry(messages);
            }
            catch (InternalServerErrorException internalServerErrorException) {
                // empty catch block
            }
        }
    }
}

